/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.jinzuan.cmd.privilege;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.channel.util.Md5Encrypt;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.data.jinzuan.facade.FacadeFactory;
import com.xunlei.niux.data.jinzuan.vo.MemberShip;
import com.xunlei.niux.data.jinzuan.vo.Privilege;
import com.xunlei.niux.data.jinzuan.vo.PrivilegeReceiveInfo;
import com.xunlei.niux.jinzuan.cache.BonusCache;
import com.xunlei.niux.jinzuan.cache.PrivilegeCache;
import com.xunlei.niux.jinzuan.cmd.DefaultCmd;
import com.xunlei.niux.jinzuan.cmd.memeber.MemberCmd;
import com.xunlei.niux.jinzuan.dto.PrivilegeInfo;
import com.xunlei.niux.jinzuan.util.DateUtil;
import com.xunlei.niux.jinzuan.util.IpUtil;
import com.xunlei.util.Log;
import com.xunlei.util.StringTools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class PrivilegeReceiveCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(PrivilegeReceiveCmd.class.getName());
    private static final String privilegekey = "3b53aaf7-ac55-46af-9b2f-115e12f306da";

    @CmdMapper(value={"/privilege/privilegeinfo.do"})
    public Object getPrivilegeInfo(XLHttpRequest request, XLHttpResponse response) {
        response.setInnerContentType(XLHttpResponse.ContentType.plain);
        try {
            String sql = "SELECT DISTINCT privilegeType,simpleName,privilegeDesc FROM jinzuan_privilege WHERE isvalid=1";
            List list = FacadeFactory.INSTANCE.getBaseSo().executeQuery(PrivilegeInfo.class, sql, new ArrayList());
            return JsonObjectUtil.getRtnAndDataJsonObject(0, list);
        }
        catch (Exception e) {
            logger.info("privilege/privilegeinfo.do query failure. the reason:" + e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u67e5\u8be2\u5931\u8d25");
        }
    }

    @CmdMapper(value={"/privilege/getPrivilege.do"})
    public Object getPrivilege(XLHttpRequest request, XLHttpResponse response) {
        String privilegeType = request.getParameter("ptype");
        response.setInnerContentType(XLHttpResponse.ContentType.plain);
        try {
            if (StringTools.isEmpty(privilegeType)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u4e3a\u7a7a");
            }
            privilegeType = privilegeType.trim();
            Privilege query = new Privilege();
            query.setPrivilegeType(Integer.parseInt(privilegeType));
            Page page = new Page();
            page.addOrder("levelNum", OrderType.ESC);
            page.addOrder("isAnnual", OrderType.ESC);
            List<Privilege> list = FacadeFactory.INSTANCE.getBaseSo().findObjects(query, page);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, list);
        }
        catch (Exception e) {
            return JsonObjectUtil.getRtnAndDataJsonObject(2, "\u7f51\u7edc\u5f02\u5e38");
        }
    }

    @CmdMapper(value={"/privilege/updatePrivilege.do"})
    public Object updatePrivilege(XLHttpRequest request, XLHttpResponse response) {
        String uid = request.getParameter("uid");
        response.setInnerContentType(XLHttpResponse.ContentType.plain);
        try {
            String ip = request.getRemoteIP();
            if (!IpUtil.getInstance().validateIp(ip, 1)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(6, "\u65e0\u6548ip");
            }
            if (StringTools.isEmpty(uid)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u4e3a\u7a7a");
            }
            String typeStr = request.getParameter("type");
            if (StringTools.isEmpty(typeStr)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u4e3a\u7a7a");
            }
            int type = Integer.parseInt(typeStr);
            if (type != 0 && type != 1) {
                return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u9519\u8bef");
            }
            FacadeFactory.INSTANCE.getPrivilegeReceiveInfoBo().updatePrivilege(Long.parseLong(uid), type == 1);
            return JsonObjectUtil.getOnlyOkJson();
        }
        catch (Exception e) {
            return JsonObjectUtil.getRtnAndDataJsonObject(2, "\u7f51\u7edc\u5f02\u5e38");
        }
    }

    @CmdMapper(value={"/privilege/initPrivilege.do"})
    public Object initPrivilege(XLHttpRequest request, XLHttpResponse response) {
        String uid = request.getParameter("uid");
        response.setInnerContentType(XLHttpResponse.ContentType.plain);
        try {
            if (StringTools.isEmpty(uid)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u9519\u8bef");
            }
            String ip = request.getRemoteIP();
            if (!IpUtil.getInstance().validateIp(ip, 1)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(6, "\u65e0\u6548ip");
            }
            MemberShip queryship = new MemberShip();
            queryship.setUserId(Long.parseLong(uid));
            MemberShip membership = FacadeFactory.INSTANCE.getBaseSo().findObject(queryship);
            if (membership == null) {
                return JsonObjectUtil.getRtnAndDataJsonObject(3, "\u60a8\u4e0d\u662f\u91d1\u94bb\u7528\u6237");
            }
            boolean yearFlag = MemberCmd.isMember(membership, 2);
            String daytime = DateUtil.getNowDay();
            FacadeFactory.INSTANCE.getPrivilegeReceiveInfoBo().addPrivilege(yearFlag, queryship.getUserId(), membership.getLevelNum(), daytime);
            return JsonObjectUtil.getOnlyOkJson();
        }
        catch (Exception e) {
            return JsonObjectUtil.getRtnAndDataJsonObject(2, "\u7f51\u7edc\u5f02\u5e38");
        }
    }

    @CmdMapper(value={"/privilege/receive.do"})
    public Object getMemberInfo(XLHttpRequest request, XLHttpResponse response) {
        String uid = request.getParameter("uid");
        String privilegeType = request.getParameter("ptype");
        response.setInnerContentType(XLHttpResponse.ContentType.plain);
        try {
            logger.info("jinzuan privilege receive.do uid=" + uid + ",ptype=" + privilegeType);
            String ip = request.getRemoteIP();
            if (!IpUtil.getInstance().validateIp(ip, 1)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(6, "\u65e0\u6548ip");
            }
            if (StringTools.isEmpty(uid) || StringTools.isEmpty(privilegeType)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u4e3a\u7a7a");
            }
            MemberShip queryship = new MemberShip();
            queryship.setUserId(Long.parseLong(uid));
            MemberShip membership = FacadeFactory.INSTANCE.getBaseSo().findObject(queryship);
            if (membership == null) {
                return JsonObjectUtil.getRtnAndDataJsonObject(2, "\u60a8\u4e0d\u662f\u91d1\u94bb\u7528\u6237");
            }
            boolean monthFlag = MemberCmd.isMember(membership, 1);
            boolean yearFlag = MemberCmd.isMember(membership, 2);
            if (!monthFlag && !yearFlag) {
                String experienceDate = membership.getExperienceDate();
                String nowDay = DateUtil.getNowDay();
                if (StringTools.isEmpty(experienceDate) || !DateUtil.compareTime(experienceDate, nowDay)) {
                    return JsonObjectUtil.getRtnAndDataJsonObject(3, "\u60a8\u5df2\u7ecf\u4e0d\u662f\u91d1\u94bb\u4f1a\u5458");
                }
            }
            int ptype = Integer.parseInt(privilegeType);
            PrivilegeReceiveInfo query = new PrivilegeReceiveInfo();
            query.setUserId(Long.parseLong(uid));
            query.setPrivilegeType(ptype);
            query.setYearMonth(DateUtil.getNowDay().substring(0, 7));
            PrivilegeReceiveInfo privilege = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
            if (privilege == null) {
                return JsonObjectUtil.getRtnAndDataJsonObject(4, "\u60a8\u4e0d\u4eab\u6709\u8be5\u7279\u6743");
            }
            if (!privilege.getIsvalid().booleanValue()) {
                return JsonObjectUtil.getRtnAndDataJsonObject(8, "\u8be5\u9879\u7279\u6743\u5df2\u7ecf\u4e0b\u7ebf");
            }
            if (privilege.getAvailableValue() <= 0L) {
                return JsonObjectUtil.getRtnAndDataJsonObject(7, "\u60a8\u8be5\u9879\u7279\u6743\u7684\u4f7f\u7528\u6b21\u6570\u4e0d\u8db3");
            }
            logger.info("jinzuan privilege receive.do success uid=" + uid + ",ptype=" + privilegeType);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, "\u60a8\u53ef\u4ee5\u4f7f\u7528\u8be5\u7279\u6743");
        }
        catch (Exception e) {
            logger.error("getmemberinfo.do exception.uid=" + uid + ",reason:" + e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(5, "\u7f51\u7edc\u5f02\u5e38");
        }
    }

    @CmdMapper(value={"/privilege/getBonus.do"})
    public Object getBonus(XLHttpRequest request, XLHttpResponse response) {
        String uid = request.getParameter("uid");
        response.setInnerContentType(XLHttpResponse.ContentType.plain);
        try {
            String ip = request.getRemoteIP();
            if (!IpUtil.getInstance().validateIp(ip, 1)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u65e0\u6548ip");
            }
            if (StringTools.isEmpty(uid)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(2, "\u53c2\u6570\u9519\u8bef");
            }
            Map<String, Long> map = BonusCache.getInstance().getBonusMap();
            MemberShip shipquery = new MemberShip();
            shipquery.setUserId(Long.parseLong(uid));
            MemberShip ship = FacadeFactory.INSTANCE.getBaseSo().findObject(shipquery);
            if (ship == null) {
                return JsonObjectUtil.getRtnAndDataJsonObject(3, "\u8be5\u7528\u6237\u975e\u91d1\u94bb\u4f1a\u5458");
            }
            boolean validFlag = DateUtil.compareTime(ship.getAnnualMemberExpireDate(), DateUtil.getNowDay());
            Long value = map.get(ship.getLevelNum() + "_" + (validFlag ? 1 : 0));
            HashMap<String, Number> result = new HashMap<String, Number>();
            result.put("levelNum", ship.getLevelNum());
            result.put("value", value);
            logger.info("jinzuan getBonus.do  uid=" + uid + ",levelNum=" + ship.getLevelNum() + ",value=" + value);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
        }
        catch (Exception e) {
            logger.info("jinzuan getBonus.do  error uid=" + uid + ",reason=" + e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(4, "\u672a\u77e5\u9519\u8bef");
        }
    }

    @CmdMapper(value={"/privilege/use.do"})
    public Object usePrivilege(XLHttpRequest request, XLHttpResponse response) {
        String uid = request.getParameter("uid");
        String ptype = request.getParameter("ptype");
        String usedValue = request.getParameter("usedValue");
        try {
            long timestamp0;
            String timestamp = request.getParameter("timestamp");
            String sign = request.getParameter("sign");
            String ip = request.getRemoteIP();
            logger.info("jinzuan privilege use.do uid=" + uid + ",ptype=" + ptype + ",usedValue=" + usedValue + ",timestamp=" + timestamp + ",ip=" + ip + ",sign=" + sign);
            if (!IpUtil.getInstance().validateIp(ip, 1)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(7, "\u65e0\u6548ip");
            }
            response.setInnerContentType(XLHttpResponse.ContentType.plain);
            if (StringTools.isEmpty(uid) || StringTools.isEmpty(ptype) || StringTools.isEmpty(timestamp) || StringTools.isEmpty(sign) || StringTools.isEmpty(usedValue)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u4e3a\u7a7a");
            }
            int type = Integer.parseInt(ptype);
            long amount = Long.parseLong(usedValue);
            String md5msg = String.valueOf(uid) + ptype + usedValue + timestamp + privilegekey;
            String mysign = Md5Encrypt.md5(md5msg);
            if (!sign.trim().equals(mysign)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(3, "\u6570\u5b57\u7b7e\u540d\u9519\u8bef");
            }
            long mytimestamp = System.currentTimeMillis() / 1000L;
            if (mytimestamp - (timestamp0 = Long.parseLong(timestamp)) > 900L) {
                return JsonObjectUtil.getRtnAndDataJsonObject(4, "\u8bf7\u6c42\u8d85\u65f6");
            }
            MemberShip query = new MemberShip();
            query.setUserId(Long.parseLong(uid));
            MemberShip memberShip = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
            if (memberShip == null) {
                return JsonObjectUtil.getRtnAndDataJsonObject(8, "\u8be5\u7528\u6237\u975e\u91d1\u94bb\u7528\u6237");
            }
            String memberExpireDate = memberShip.getMemberExpireDate();
            boolean validFlag = DateUtil.compareTime(memberExpireDate, DateUtil.getNowDay());
            if (!validFlag) {
                String experienceDate = memberShip.getExperienceDate();
                String nowDay = DateUtil.getNowDay();
                if (StringTools.isEmpty(experienceDate) || !DateUtil.compareTime(experienceDate, nowDay)) {
                    return JsonObjectUtil.getRtnAndDataJsonObject(9, "\u8be5\u91d1\u94bb\u7528\u6237\u5df2\u8fc7\u671f");
                }
            }
            Privilege privilegequery = new Privilege();
            privilegequery.setPrivilegeType(new Integer(type));
            privilegequery.setIsvalid(true);
            Privilege privilege = FacadeFactory.INSTANCE.getBaseSo().findObject(privilegequery);
            if (privilege == null) {
                return JsonObjectUtil.getRtnAndDataJsonObject(5, "\u8be5\u9879\u7279\u6743\u4e0d\u5b58\u5728");
            }
            Map<Integer, String> privilegeMap = PrivilegeCache.getInstance().getPrivilegeMap();
            PrivilegeReceiveInfo info = new PrivilegeReceiveInfo();
            info.setUserId(Long.parseLong(uid));
            info.setPrivilegeType(type);
            info.setTotalValue(amount);
            String daytime = DateUtil.getNowDay();
            info.setYearMonth(daytime.substring(0, 7));
            info.setSimpleName(privilegeMap.get(type));
            FacadeFactory.INSTANCE.getPrivilegeReceiveInfoBo().addPrivilegeReceiveInfo(info);
            logger.info("jinzuan privilege use.do success uid=" + uid + ",ptype=" + ptype + ",usedValue=" + usedValue);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, "\u4f7f\u7528\u6210\u529f");
        }
        catch (XLRuntimeException e) {
            logger.info("jinzuan privilege use.do error uid=" + uid + ",ptype=" + ptype + ",usedValue=" + usedValue + ",reason=" + e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(5, e.getMessage());
        }
        catch (Exception e) {
            logger.info("jinzuan privilege use.do error uid=" + uid + ",ptype=" + ptype + ",usedValue=" + usedValue + ",reason=" + e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(6, e.getMessage());
        }
    }
}

