/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.easyutils.commonutils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtil {
    private static final String DEFAULT_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static final String DATE_PATTERN = "yyyy-MM-dd";
    private static final SimpleDateFormat SDF = new SimpleDateFormat("yyyyMMddHHmmss");

    public static String getOrderTime() {
        return SDF.format(new Date());
    }

    public static Date yesterday() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(6, -1);
        return calendar.getTime();
    }

    public static String formatNow(String pattern) {
        return DateUtil.format(new Date(), pattern);
    }

    public static String formatNowByDefault() {
        return DateUtil.formatNow(DEFAULT_PATTERN);
    }

    public static Date nextYear() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(1, 1);
        return calendar.getTime();
    }

    public static String format(Date date, String pattern) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        return dateFormat.format(date);
    }

    public static long compareTime(String fromtime, String totime) {
        SimpleDateFormat df = new SimpleDateFormat(DATE_PATTERN);
        Date one = null;
        Date two = null;
        long days = 0L;
        try {
            one = df.parse(fromtime);
            two = df.parse(totime);
            long time1 = one.getTime();
            long time2 = two.getTime();
            long diff = time1 - time2;
            days = diff / 86400000L;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return days;
    }
}

