/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.bonus.bo;

import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.bonus.bo.BonusTransBo;
import com.xunlei.niux.data.bonus.constant.SqlLock;
import com.xunlei.niux.data.bonus.dao.BonusTransDao;
import com.xunlei.niux.data.bonus.dao.UserBonusDao;
import com.xunlei.niux.data.bonus.exception.BonusRuntimeException;
import com.xunlei.niux.data.bonus.vo.BonusTrans;
import com.xunlei.niux.data.bonus.vo.UserBonus;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BonusTransBoImpl
implements BonusTransBo {
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    @Autowired
    private BonusTransDao bonusTransDao;
    @Autowired
    private UserBonusDao userBonusDao;

    @Override
    public BonusTrans find(String userId, long seqId) {
        BonusTrans bonusTrans = new BonusTrans();
        bonusTrans.setUserId(userId);
        bonusTrans.setSeqId(seqId);
        List<BonusTrans> list = this.find(bonusTrans, new Page());
        return list == null || list.size() == 0 ? null : list.get(0);
    }

    @Override
    public List<BonusTrans> find(BonusTrans bonusTrans, Page page) {
        return this.bonusTransDao.find(bonusTrans, page);
    }

    @Override
    public int count(BonusTrans pTrans) {
        if (pTrans.getUserId() == null || "".equals(pTrans.getUserId())) {
            throw new RuntimeException("userid\u4e3a\u7a7a");
        }
        return this.bonusTransDao.count(pTrans.getUserId(), pTrans);
    }

    @Override
    public BonusTrans find(String userId, String bizNo, String transNo, String transDirect) {
        BonusTrans bonusTrans = new BonusTrans();
        bonusTrans.setUserId(userId);
        bonusTrans.setBizNo(bizNo);
        bonusTrans.setTransNo(transNo);
        bonusTrans.setTransDirect(transDirect);
        List<BonusTrans> list = this.find(bonusTrans, new Page());
        return list == null || list.size() == 0 ? null : list.get(0);
    }

    @Override
    public void insert(BonusTrans bonusTrans) {
        if (bonusTrans == null) {
            throw new BonusRuntimeException("1009", "\u79ef\u5206\u4ea4\u6613\u4e3a\u7a7a");
        }
        this.checkBonusTransParam(bonusTrans);
        if (this.find(bonusTrans.getUserId(), bonusTrans.getBizNo(), bonusTrans.getTransNo(), bonusTrans.getTransDirect()) != null) {
            throw new BonusRuntimeException("1001", "\u4e1a\u52a1\u53f7[" + bonusTrans.getBizNo() + "]\u7684\u4ea4\u6613\u7f16\u53f7[" + bonusTrans.getTransNo() + "]\u4ea4\u6613\u65b9\u5411[" + bonusTrans.getTransDirect() + "]\u5df2\u5904\u7406");
        }
        UserBonus userBonus = this.userBonusDao.find(bonusTrans.getUserId(), SqlLock.UPDATE);
        if ((userBonus = this.calUserBonus(userBonus, bonusTrans)).getSeqId() == null || userBonus.getSeqId() <= 0L) {
            this.userBonusDao.insert(userBonus);
        } else {
            this.userBonusDao.update(userBonus);
        }
        bonusTrans.setTransTime(sdf.format(new Date()));
        this.bonusTransDao.insert(bonusTrans);
    }

    private UserBonus calUserBonus(UserBonus userBonus, BonusTrans bonusTrans) {
        if ("1".equals(bonusTrans.getTransDirect())) {
            return this.calUserBonusConsume(userBonus, bonusTrans);
        }
        if ("2".equals(bonusTrans.getTransDirect())) {
            return this.calUserBonusRecharge(userBonus, bonusTrans);
        }
        if ("3".equals(bonusTrans.getTransDirect())) {
            return this.calUserBonusConsumeReturn(userBonus, bonusTrans);
        }
        throw new BonusRuntimeException("1009", "\u79ef\u5206\u4ea4\u6613\u7c7b\u578b[" + bonusTrans.getTransDirect() + "]\u672a\u77e5");
    }

    private UserBonus calUserBonusRecharge(UserBonus userBonus, BonusTrans bonusTrans) {
        if (userBonus == null) {
            userBonus = new UserBonus();
            userBonus.setUserId(bonusTrans.getUserId());
            userBonus.setUserName(bonusTrans.getUserName());
            userBonus.setBonusLevel(0);
            userBonus.setBonusNum(0);
            userBonus.setConsumeSum(0L);
            userBonus.setRechargeSum(0L);
            userBonus.setBonusStatus(0);
        }
        userBonus.setBonusNum(userBonus.getBonusNum() + bonusTrans.getTransNum());
        userBonus.setRechargeSum(userBonus.getRechargeSum() + (long)bonusTrans.getTransNum().intValue());
        userBonus.setLastRechargeTime(sdf.format(new Date()));
        userBonus.setBonusLevel(this.calUserBonusLevel(userBonus));
        if (userBonus.getBonusNum() < 0) {
            throw new BonusRuntimeException("1002", "\u7528\u6237[" + userBonus.getUserId() + "]\u79ef\u5206\u6ea2\u51fa");
        }
        return userBonus;
    }

    private UserBonus calUserBonusConsumeReturn(UserBonus userBonus, BonusTrans bonusTrans) {
        if (userBonus == null) {
            throw new BonusRuntimeException("1020", "\u79ef\u5206\u4e0d\u5b58\u5728");
        }
        if (userBonus.getConsumeSum() - (long)bonusTrans.getTransNum().intValue() < 0L) {
            throw new BonusRuntimeException("1021", "\u7528\u6237[" + userBonus.getUserId() + "]\u8fd4\u8fd8\u79ef\u5206\u4e0d\u591f");
        }
        userBonus.setBonusNum(userBonus.getBonusNum() + bonusTrans.getTransNum());
        userBonus.setConsumeSum(userBonus.getConsumeSum() - (long)bonusTrans.getTransNum().intValue());
        if (userBonus.getBonusNum() < 0) {
            throw new BonusRuntimeException("1002", "\u7528\u6237[" + userBonus.getUserId() + "]\u79ef\u5206\u6ea2\u51fa");
        }
        return userBonus;
    }

    private UserBonus calUserBonusConsume(UserBonus userBonus, BonusTrans bonusTrans) {
        if (userBonus == null) {
            throw new BonusRuntimeException("1020", "\u79ef\u5206\u4e0d\u5b58\u5728");
        }
        if (userBonus.getBonusStatus() > 0) {
            throw new BonusRuntimeException("1022", "\u7528\u6237[" + userBonus.getUserId() + "]\u79ef\u5206\u88ab\u51bb\u7ed3");
        }
        if (userBonus.getBonusNum() - bonusTrans.getTransNum() < 0) {
            throw new BonusRuntimeException("1021", "\u7528\u6237[" + userBonus.getUserId() + "]\u79ef\u5206\u4e0d\u591f");
        }
        userBonus.setBonusNum(userBonus.getBonusNum() - bonusTrans.getTransNum());
        userBonus.setConsumeSum(userBonus.getConsumeSum() + (long)bonusTrans.getTransNum().intValue());
        if (userBonus.getConsumeSum() < 0L) {
            throw new BonusRuntimeException("1002", "\u7528\u6237[" + userBonus.getUserId() + "]\u6d88\u8d39\u79ef\u5206\u6ea2\u51fa");
        }
        userBonus.setLastConsumeTime(sdf.format(new Date()));
        return userBonus;
    }

    public void checkBonusTransParam(BonusTrans bonusTrans) {
        if (bonusTrans.getTransNo() == null || "".equals(bonusTrans.getTransNo())) {
            throw new BonusRuntimeException("1009", "\u4ea4\u6613\u7f16\u53f7\u4e3a\u7a7a");
        }
        if (bonusTrans.getTransDirect() == null || "".equals(bonusTrans.getTransDirect())) {
            throw new BonusRuntimeException("1009", "\u79ef\u5206\u4ea4\u6613\u65b9\u5411\u4e3a\u7a7a");
        }
        if (bonusTrans.getTransNum() <= 0) {
            throw new BonusRuntimeException("1009", "\u4ea4\u6613\u79ef\u5206\u5c0f\u4e8e\u6216\u7b49\u4e8e0");
        }
    }

    private int calUserBonusLevel(UserBonus userBonus) {
        Long sumbonus = userBonus.getRechargeSum();
        if (sumbonus < 5L) {
            return 0;
        }
        if (sumbonus < 10L) {
            return 1;
        }
        if (sumbonus < 15L) {
            return 2;
        }
        if (sumbonus < 20L) {
            return 3;
        }
        if (sumbonus < 30L) {
            return 4;
        }
        if (sumbonus < 40L) {
            return 5;
        }
        if (sumbonus < 50L) {
            return 6;
        }
        if (sumbonus < 60L) {
            return 7;
        }
        if (sumbonus < 75L) {
            return 8;
        }
        if (sumbonus < 90L) {
            return 9;
        }
        for (int i = 10; i < 99; ++i) {
            if ((long)((i - 4) * (i - 4) * 3) <= sumbonus) continue;
            return i;
        }
        return 99;
    }

    public BonusTransDao getBonusTransDao() {
        return this.bonusTransDao;
    }

    public void setBonusTransDao(BonusTransDao bonusTransDao) {
        this.bonusTransDao = bonusTransDao;
    }

    public UserBonusDao getUserBonusDao() {
        return this.userBonusDao;
    }

    public void setUserBonusDao(UserBonusDao userBonusDao) {
        this.userBonusDao = userBonusDao;
    }
}

