/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.httpserver.util;

import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.util.IPGetter;

public class IPGetterHelper {
    public static final IPGetter DEFAULT_IPGETTER;
    private static IPGetter CURRENT_IPGETTER;
    public static final String PROXY_CLIENT_IP = "Proxy-Client-IP";
    public static final String WL_PROXY_CLIENT_IP = "WL-Proxy-Client-IP";
    public static final String X_FORWARDED_FOR = "X-Forwarded-For";
    public static final String X_REAL_IP = "X-Real-IP";

    static {
        CURRENT_IPGETTER = DEFAULT_IPGETTER = new DefaultIPGetter();
    }

    public static String getIP(XLHttpRequest request) {
        return CURRENT_IPGETTER.getIP(request);
    }

    public static void setIPGetter(IPGetter getter) {
        if (getter != null) {
            CURRENT_IPGETTER = getter;
        }
    }

    public static String getIP(XLHttpRequest request, String proxyHeader) {
        String proxyIp = request.getHeader(proxyHeader);
        if (proxyIp == null) {
            return request.getPrimitiveRemoteIP();
        }
        if ((proxyIp = proxyIp.trim()).isEmpty() || !proxyIp.contains(".")) {
            return request.getPrimitiveRemoteIP();
        }
        return proxyIp;
    }

    public static String getIPByXForwared(XLHttpRequest request) {
        String proxyIp = request.getHeader(X_FORWARDED_FOR);
        if (proxyIp == null) {
            return request.getPrimitiveRemoteIP();
        }
        if ((proxyIp = proxyIp.trim()).isEmpty() || !proxyIp.contains(".")) {
            return request.getPrimitiveRemoteIP();
        }
        int index = proxyIp.indexOf(44);
        if (index > 0) {
            proxyIp = proxyIp.substring(0, index);
        }
        return proxyIp;
    }

    public static String getIP(XLHttpRequest request, String ... proxyHeaders) {
        int i = 0;
        while (i < proxyHeaders.length) {
            String proxyIp = request.getHeader(proxyHeaders[i]);
            if (proxyIp != null && !(proxyIp = proxyIp.trim()).isEmpty() && proxyIp.contains(".")) {
                return proxyIp;
            }
            ++i;
        }
        return request.getPrimitiveRemoteIP();
    }

    private static class DefaultIPGetter
    implements IPGetter {
        private DefaultIPGetter() {
        }

        @Override
        public String getIP(XLHttpRequest request) {
            return request.getPrimitiveRemoteIP();
        }
    }
}

