/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.httpserver.util;

import com.xunlei.netty.httpserver.HttpServerPipelineFactory;
import com.xunlei.netty.httpserver.component.XLAccessLogger;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.netty.httpserver.util.NOPStatistics;
import com.xunlei.netty.httpserver.util.Statistics;
import com.xunlei.spring.AfterConfig;
import com.xunlei.spring.Config;
import com.xunlei.util.Log;
import com.xunlei.util.concurrent.NamedThreadFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.handler.execution.OrderedMemoryAwareThreadPoolExecutor;
import org.jboss.netty.util.internal.ExecutorUtil;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public final class HttpServerConfig {
    public static final Logger ALARMLOG = Log.getLogger("alarm.com.xunlei.netty");
    public static final int CORE_PROCESSOR_NUM = Runtime.getRuntime().availableProcessors();
    private static XLHttpResponse.ContentType respInnerContentType = XLHttpResponse.ContentType.json;
    private XLAccessLogger accessLog = new XLAccessLogger();
    @Config
    private int listen_port = 80;
    @Config
    private int connectTimeoutMillis = 5000;
    @Config
    private int receiveBufferSize = 8192;
    @Config
    private int sendBufferSize = 8192;
    @Config
    private String indexCmdName = "echo";
    @Config
    private String cmdSuffix = "Cmd";
    @Config
    private String cmdDefaultMethod = "process";
    @Config
    private boolean cmdMiscMethodExtenable = true;
    @Config
    private boolean cmdDefaultMethodVisiable = false;
    @Config
    public int workerCount = 0;
    @Config
    private long plMaxChannelMemorySize = 0x6400000L;
    @Config
    private long plMaxTotalMemorySize = 0x40000000L;
    @Config(resetable=true)
    private int plCorePoolSize = CORE_PROCESSOR_NUM * 50;
    @Config(resetable=true)
    private long plKeepAliveSecond = 60L;
    @Config(resetable=true)
    private String plAddBefore = "pageDispatcher";
    @Config(resetable=true)
    private boolean plAddDefalter = false;
    @Config(resetable=true)
    private String respDefaultContentType = "json";
    @Config(resetable=true)
    private int slowThreshold = 1000;
    @Config(resetable=true)
    private static int keepAliveTimeout = 2;
    @Config(resetable=true)
    private int toleranceTimeout = 10;
    @Config(resetable=true)
    private boolean debugEnable = true;
    @Config(resetable=true)
    private boolean statEnable = true;
    @Config(resetable=true)
    private boolean logaccessEnable = true;
    @Autowired
    private Statistics default_statistics;
    @Autowired
    private Statistics statistics;
    @Autowired
    private HttpServerPipelineFactory httpServerPipelineFactory;
    public static ScheduledExecutorService daemonTaskExecutor = Executors.newScheduledThreadPool(CORE_PROCESSOR_NUM, new NamedThreadFactory("HttpServerDaemon", 4, true));
    public static final ExecutorService bossExecutor = Executors.newCachedThreadPool(new NamedThreadFactory("New I/O server boss $", 10));
    public static final ExecutorService workerExecutor = Executors.newCachedThreadPool(new NamedThreadFactory("New I/O server worker $", 9));
    private OrderedMemoryAwareThreadPoolExecutor pipelineExecutor;

    @AfterConfig
    public void initPipelineExecutor() {
        if (this.pipelineExecutor == null) {
            this.pipelineExecutor = new OrderedMemoryAwareThreadPoolExecutor(this.plCorePoolSize, this.plMaxChannelMemorySize, this.plMaxTotalMemorySize, this.plKeepAliveSecond, TimeUnit.SECONDS, (ThreadFactory)new NamedThreadFactory("PIPELINE#", 7));
        } else {
            this.pipelineExecutor.setCorePoolSize(this.plCorePoolSize);
            this.pipelineExecutor.setMaximumPoolSize(this.plCorePoolSize);
            this.pipelineExecutor.setKeepAliveTime(this.plKeepAliveSecond, TimeUnit.SECONDS);
        }
    }

    @AfterConfig
    public void initRespInnerContentType() {
        respInnerContentType = "xml".equalsIgnoreCase(this.respDefaultContentType) ? XLHttpResponse.ContentType.xml : ("html".equalsIgnoreCase(this.respDefaultContentType) ? XLHttpResponse.ContentType.html : ("plain".equalsIgnoreCase(this.respDefaultContentType) ? XLHttpResponse.ContentType.plain : XLHttpResponse.ContentType.json));
    }

    @AfterConfig
    private void initStat() {
        this.statistics = this.statEnable ? this.default_statistics : NOPStatistics.INSTANCE;
    }

    public OrderedMemoryAwareThreadPoolExecutor getPipelineExecutor() {
        if (this.pipelineExecutor == null) {
            this.initPipelineExecutor();
        }
        return this.pipelineExecutor;
    }

    public void setPlCorePoolSize(int plCorePoolSize) {
        this.plCorePoolSize = plCorePoolSize;
        this.pipelineExecutor.setCorePoolSize(plCorePoolSize);
        this.pipelineExecutor.setMaximumPoolSize(plCorePoolSize);
    }

    public void setPlKeepAliveSecond(long plKeepAliveSecond) {
        this.plKeepAliveSecond = plKeepAliveSecond;
        this.pipelineExecutor.setKeepAliveTime(plKeepAliveSecond, TimeUnit.SECONDS);
    }

    public int getRealWorkerCount() {
        if (this.workerCount < 0) {
            return CORE_PROCESSOR_NUM * this.workerCount * -1;
        }
        if (this.workerCount == 0) {
            return CORE_PROCESSOR_NUM * 2;
        }
        return this.workerCount;
    }

    public int getListen_port() {
        return this.listen_port;
    }

    public int getConnectTimeoutMillis() {
        return this.connectTimeoutMillis;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public int getSlowThreshold() {
        return this.slowThreshold;
    }

    public static int getKeepAliveTimeout() {
        return keepAliveTimeout;
    }

    public int getToleranceTimeout() {
        return this.toleranceTimeout;
    }

    public boolean isDebugEnable() {
        return this.debugEnable;
    }

    public boolean isStatEnable() {
        return this.statEnable;
    }

    public String getIndexCmdName() {
        return this.indexCmdName;
    }

    public String getCmdSuffix() {
        return this.cmdSuffix;
    }

    public String getCmdDefaultMethod() {
        return this.cmdDefaultMethod;
    }

    public boolean isCmdMiscMethodExtenable() {
        return this.cmdMiscMethodExtenable;
    }

    public boolean isCmdDefaultMethodVisiable() {
        return this.cmdDefaultMethodVisiable;
    }

    public String getPlAddBefore() {
        return this.plAddBefore;
    }

    public boolean isPlAddDefalter() {
        return this.plAddDefalter;
    }

    public static XLHttpResponse.ContentType getRespInnerContentType() {
        return respInnerContentType;
    }

    public void setRespDefaultContentType(String respDefaultContentType) {
        this.respDefaultContentType = respDefaultContentType;
        this.initRespInnerContentType();
    }

    public void setStatEnable(boolean statEnable) {
        this.statEnable = statEnable;
        this.initStat();
        this.httpServerPipelineFactory.rebuildPipeline();
    }

    public Statistics getStatistics() {
        return this.statistics;
    }

    public void setLogaccessEnable(boolean logaccessEnable) {
        this.logaccessEnable = logaccessEnable;
        this.initAccessLogger();
    }

    @AfterConfig
    private void initAccessLogger() {
        this.accessLog.setLogEanble(this.logaccessEnable);
    }

    public XLAccessLogger getAccessLog() {
        return this.accessLog;
    }

    public void setPlAddBefore(String plAddBefore) {
        this.plAddBefore = plAddBefore;
        this.httpServerPipelineFactory.rebuildPipeline();
    }

    public void setPlAddDefalter(boolean plAddDefalter) {
        this.plAddDefalter = plAddDefalter;
        this.httpServerPipelineFactory.rebuildPipeline();
    }

    public static void releaseExternalResources() {
        ExecutorUtil.terminate(bossExecutor, workerExecutor);
    }
}

