/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.httpserver.handler;

import com.xunlei.netty.httpserver.component.XLContextAttachment;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.netty.httpserver.exception.ProcessTimeoutError;
import com.xunlei.netty.httpserver.exception.ResourceNotFoundError;
import com.xunlei.netty.httpserver.handler.HandlerManager;
import com.xunlei.netty.httpserver.handler.PlainHandler;
import com.xunlei.netty.httpserver.handler.PlainHandlerExt;
import com.xunlei.netty.httpserver.handler.TextResponseHandler;
import com.xunlei.netty.httpserver.util.Checkers;
import com.xunlei.netty.httpserver.util.HttpServerConfig;
import com.xunlei.spring.AfterConfig;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.Resource;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TextResponseHandlerManager
extends HandlerManager<TextResponseHandler> {
    @Autowired
    private HttpServerConfig serverConfig;
    @Resource
    private PlainHandler plainHandler;
    @Resource
    private PlainHandlerExt plainHandlerExt;
    private static final String HTTP_HEADER_KEEP_ALIVE = "Keep-Alive";

    @AfterConfig
    public void initHandlerChain() {
        this.addFirst(this.plainHandlerExt);
        this.addLast(this.plainHandler);
    }

    private void setContent(XLContextAttachment attach, Object cmdReturnObj) {
        XLHttpResponse response = attach.getResponse();
        if (!response.isContentSetted()) {
            String contentStr = null;
            for (TextResponseHandler trh : this.getHandlerChain()) {
                contentStr = trh.buildContentString(attach, cmdReturnObj);
                if (contentStr == null) continue;
                response.setContentString(contentStr);
                return;
            }
        }
    }

    private boolean setHeader(XLHttpRequest request, XLHttpResponse response) {
        int timeout = response.getKeepAliveTimeout();
        boolean close = true;
        try {
            close = timeout == -1 ? "close".equalsIgnoreCase(request.getHeader("Connection")) || request.getProtocolVersion().equals(HttpVersion.HTTP_1_0) && !"keep-alive".equalsIgnoreCase(request.getHeader("Connection")) : timeout <= 0;
        }
        finally {
            response.setHeader("Content-Length", String.valueOf(response.getContentLength()));
            if (close) {
                response.setHeader("Connection", "close");
            } else if (timeout != -1) {
                response.setHeader("Connection", "keep-alive");
                response.setHeader(HTTP_HEADER_KEEP_ALIVE, "timeout=" + timeout);
            }
        }
        return close;
    }

    public void writeResponse(XLContextAttachment attach, Object cmdReturnObj) {
        XLHttpResponse response = attach.getResponse();
        XLHttpRequest request = attach.getRequest();
        Channel channel = attach.getChannelHandlerContext().getChannel();
        Checkers.checkChannelOpen(channel);
        this.serverConfig.getStatistics().writeBegin(attach);
        this.setContent(attach, cmdReturnObj);
        response.packagingCookies();
        boolean close = this.setHeader(request, response);
        ChannelFuture future = channel.write(response);
        attach.markLastWriteTime();
        if (close) {
            future.addListener(ChannelFutureListener.CLOSE);
        }
        this.serverConfig.getAccessLog().log(request, response);
    }

    public Object handleThrowable(XLContextAttachment attach, Throwable e) throws Exception {
        Object cmdReturnObj = null;
        Throwable ex = e;
        if (ex instanceof NoSuchMethodException || ex instanceof SecurityException) {
            ex = ResourceNotFoundError.INSTANCE;
        } else if (ex instanceof InvocationTargetException) {
            ex = ((InvocationTargetException)ex).getTargetException();
        } else if (ex instanceof InterruptedException) {
            ex = ProcessTimeoutError.INSTANCE;
        }
        attach.registerThrowable(ex);
        for (TextResponseHandler th : this.getHandlerChain()) {
            cmdReturnObj = th.handleThrowable(attach, ex);
            if (cmdReturnObj == null) continue;
            return cmdReturnObj;
        }
        return cmdReturnObj;
    }
}

