/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.httpserver.component;

import com.xunlei.util.Log;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.jboss.netty.handler.codec.http.Cookie;
import org.jboss.netty.handler.codec.http.DefaultCookie;
import org.slf4j.Logger;

public class XLCookieDecoder {
    public static final CaseIgnoringComparator CaseIgnoringComparatorInstance = new CaseIgnoringComparator();
    public static final XLCookieDecoder INSTANCE = new XLCookieDecoder();
    private static final Logger log = Log.getLogger();
    public static final Set<String> RESERVED_NAMES = new TreeSet<String>(CaseIgnoringComparatorInstance);

    static {
        RESERVED_NAMES.add("$Domain");
        RESERVED_NAMES.add("$Path");
        RESERVED_NAMES.add("$Comment");
        RESERVED_NAMES.add("$CommentURL");
        RESERVED_NAMES.add("$Discard");
        RESERVED_NAMES.add("$Port");
        RESERVED_NAMES.add("$Max-Age");
        RESERVED_NAMES.add("$Expires");
        RESERVED_NAMES.add("$Version");
        RESERVED_NAMES.add("$Secure");
        RESERVED_NAMES.add("$HTTPOnly");
    }

    private static String stripQuote(String value) {
        if (value.startsWith("\"") && value.endsWith("\"")) {
            try {
                return value.substring(1, value.length() - 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return value;
    }

    public Map<String, Cookie> decode(String cookieString, Map<String, Cookie> map) {
        StringTokenizer tok = new StringTokenizer(cookieString, ";", false);
        while (tok.hasMoreTokens()) {
            String name;
            String token = tok.nextToken();
            int i = token.indexOf("=");
            if (i <= -1 || RESERVED_NAMES.contains(name = token.substring(0, i).trim())) continue;
            String value = XLCookieDecoder.stripQuote(token.substring(i + 1).trim());
            try {
                map.put(name, new DefaultCookie(name, value));
            }
            catch (Exception e) {
                log.warn("new DefaultCookie fail,name:{},value:{}", new Object[]{name, value});
            }
        }
        return map;
    }

    public static class CaseIgnoringComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 4582133183775373862L;

        @Override
        public int compare(String o1, String o2) {
            return o1.compareToIgnoreCase(o2);
        }

        private Object readResolve() {
            return CaseIgnoringComparatorInstance;
        }
    }
}

