/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.httpserver.component;

import com.xunlei.netty.httpserver.component.XLContextAttachment;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.netty.httpserver.util.HttpServerConfig;
import com.xunlei.spring.Config;
import com.xunlei.util.Log;
import com.xunlei.util.concurrent.ConcurrentHashSet;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.channel.Channel;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class TimeoutInterrupter {
    private static final Logger log = Log.getLogger();
    private Runnable _defaultInterrupter = new Runnable(){

        private void close(XLContextAttachment attach, String tips) {
            Channel channel = attach.getChannelHandlerContext().getChannel();
            channel.close();
            TimeoutInterrupter timeoutInterrupter = TimeoutInterrupter.this;
            timeoutInterrupter.sweepedChannelNum = timeoutInterrupter.sweepedChannelNum + 1L;
            log.warn("close {} attach:{}", (Object)tips, (Object)attach);
        }

        @Override
        public void run() {
            for (XLContextAttachment attach : TimeoutInterrupter.this.liveAttach) {
                long span;
                Thread t = attach.getProcessThread();
                if (t == null) {
                    long read = attach.getLastReadTime();
                    long write = attach.getLastWriteTime();
                    long all = Math.max(read, write);
                    int allTimeout = TimeoutInterrupter.this.allIdleTimeSeconds;
                    long now = System.currentTimeMillis();
                    XLHttpResponse response = attach.getResponse();
                    if (response == null) {
                        if (TimeoutInterrupter.this.readerIdleTimeSeconds > 0 && now - read > (long)(TimeoutInterrupter.this.readerIdleTimeSeconds * 1000)) {
                            this.close(attach, "readIdle-" + TimeoutInterrupter.this.readerIdleTimeSeconds);
                            continue;
                        }
                        if (TimeoutInterrupter.this.writerIdleTimeSeconds > 0 && now - write > (long)(TimeoutInterrupter.this.writerIdleTimeSeconds * 1000)) {
                            this.close(attach, "writeIdle-" + TimeoutInterrupter.this.writerIdleTimeSeconds);
                            continue;
                        }
                    } else {
                        int keepAliveTimeout = response.getKeepAliveTimeout();
                        allTimeout = Math.max(TimeoutInterrupter.this.allIdleTimeSeconds, keepAliveTimeout);
                    }
                    if (allTimeout <= 0 || now - all <= (long)(allTimeout * 1000)) continue;
                    this.close(attach, "allIdle-" + allTimeout);
                    continue;
                }
                long timeout = attach.getCmdMeta().getTimeout();
                if (timeout <= 0L || (span = System.currentTimeMillis() - attach.getProcess()) <= timeout * 1000L) continue;
                log.warn("interrupt {} [{}ms]", attach, (Object)span);
                attach.interrupt();
            }
        }
    };
    public final AttachRegister _defaultRegister = new AttachRegister(){

        @Override
        public void registerAttach(XLContextAttachment attach) {
            TimeoutInterrupter.this.liveAttach.add(attach);
        }

        @Override
        public void unregisterAttach(XLContextAttachment attach) {
            TimeoutInterrupter.this.liveAttach.remove(attach);
        }
    };
    public final AttachRegister _nopRegister = new AttachRegister(){

        @Override
        public void registerAttach(XLContextAttachment attach) {
        }

        @Override
        public void unregisterAttach(XLContextAttachment attach) {
        }
    };
    @Config(resetable=true)
    public volatile int allIdleTimeSeconds = 0;
    private AttachRegister attachRegister = this._nopRegister;
    private final Set<XLContextAttachment> liveAttach = new ConcurrentHashSet<XLContextAttachment>();
    @Config(resetable=true)
    public volatile int readerIdleTimeSeconds = 0;
    private ScheduledFuture<?> scheduledFuture;
    private volatile long sweepedChannelNum;
    private boolean threadInterrupterEnable;
    @Config(resetable=true)
    public volatile int writerIdleTimeSeconds = 0;

    public int currentChannelsNum() {
        return this.liveAttach.size();
    }

    public AttachRegister getAttachRegister() {
        return this.attachRegister;
    }

    public boolean isEnable() {
        return this.threadInterrupterEnable || this.readerIdleTimeSeconds > 0 || this.allIdleTimeSeconds > 0 || this.writerIdleTimeSeconds > 0;
    }

    private synchronized boolean reset() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
        }
        if (this.isEnable()) {
            this.attachRegister = this._defaultRegister;
            log.warn("TimeoutInterrupter ENABLE,ioIdle:{},{},{},cmdTimeout:{}", new Object[]{this.readerIdleTimeSeconds, this.writerIdleTimeSeconds, this.allIdleTimeSeconds, this.threadInterrupterEnable});
            this.scheduledFuture = HttpServerConfig.daemonTaskExecutor.scheduleWithFixedDelay(this._defaultInterrupter, 100L, 100L, TimeUnit.MILLISECONDS);
            return true;
        }
        this.attachRegister = this._nopRegister;
        this.liveAttach.clear();
        log.warn("TimeoutInterrupter DISABLE");
        return false;
    }

    public void setThreadInterrupterEnable(boolean threadInterrupterEnable) {
        boolean ori = this.isEnable();
        this.threadInterrupterEnable = threadInterrupterEnable;
        boolean now = this.isEnable();
        if (ori != now) {
            this.reset();
        }
    }

    public long sweepedChannelNum() {
        return this.sweepedChannelNum;
    }

    public void setAllIdleTimeSeconds(int allIdleTimeSeconds) {
        boolean ori = this.isEnable();
        this.allIdleTimeSeconds = allIdleTimeSeconds;
        boolean now = this.isEnable();
        if (ori != now) {
            this.reset();
        }
    }

    public void setReaderIdleTimeSeconds(int readerIdleTimeSeconds) {
        boolean ori = this.isEnable();
        this.readerIdleTimeSeconds = readerIdleTimeSeconds;
        boolean now = this.isEnable();
        if (ori != now) {
            this.reset();
        }
    }

    public void setWriterIdleTimeSeconds(int writerIdleTimeSeconds) {
        boolean ori = this.isEnable();
        this.writerIdleTimeSeconds = writerIdleTimeSeconds;
        boolean now = this.isEnable();
        if (ori != now) {
            this.reset();
        }
    }

    public Set<XLContextAttachment> getLiveAttach() {
        return this.liveAttach;
    }

    public static interface AttachRegister {
        public void registerAttach(XLContextAttachment var1);

        public void unregisterAttach(XLContextAttachment var1);
    }
}

