/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.httpserver.cmd.common;

import com.xunlei.netty.httpserver.cmd.BaseStatCmd;
import com.xunlei.netty.httpserver.cmd.CmdMappers;
import com.xunlei.netty.httpserver.component.TimeoutInterrupter;
import com.xunlei.netty.httpserver.component.XLContextAttachment;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.netty.httpserver.util.HttpServerConfig;
import com.xunlei.netty.httpserver.util.Statistics;
import com.xunlei.netty.httpserver.util.StatisticsHelper;
import com.xunlei.spring.AfterConfig;
import com.xunlei.util.HumanReadableUtil;
import com.xunlei.util.Log;
import com.xunlei.util.stat.AbstarctTimeSpanStat;
import com.xunlei.util.stat.StatUtil;
import com.xunlei.util.stat.SystemInfo;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.WriteCompletionEvent;
import org.jboss.netty.channel.socket.nio.NioWorkerStat;
import org.jboss.netty.handler.execution.OrderedMemoryAwareThreadPoolExecutor;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StatCmd
extends BaseStatCmd
implements Statistics {
    private static final Logger log = Log.getLogger();
    private static final String streamStatFmt = "%-21s %-8s %-20s %-19s %-20s\n";
    private StageTimeSpanStat allTSS;
    private AtomicLong channelCloses;
    private AtomicLong channelInterruptCloses;
    private AtomicLong channelOpens;
    @Autowired
    private TimeoutInterrupter timeoutInterrupter;
    @Autowired
    private HttpServerConfig config;
    private StageTimeSpanStat decodeTSS;
    private StageTimeSpanStat encodeTSS;
    private StreamStat inbound;
    private StageTimeSpanStat okTSS;
    private StreamStat outbound;
    private StageTimeSpanStat processTSS;
    private AtomicLong reqs_401;
    private AtomicLong reqs_403;
    private AtomicLong reqs_404;
    private AtomicLong reqs_500;
    private AtomicLong reqs_503;
    private long statBeginTime;
    @Autowired
    private CmdMappers cmdMappers;
    @Autowired
    private StatisticsHelper statisticsHelper;

    @Override
    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) {
        this.channelCloses.incrementAndGet();
    }

    @Override
    public void channelInterruptClosed(ChannelHandlerContext ctx) {
        this.channelInterruptCloses.incrementAndGet();
    }

    @Override
    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) {
        this.channelOpens.incrementAndGet();
    }

    public String getExecutorInfo() {
        StringBuilder tmp = new StringBuilder();
        OrderedMemoryAwareThreadPoolExecutor pipelineExecutor = this.config.getPipelineExecutor();
        String executorStatFmt = "%-23s %-13s %-12s %-16s %-12s %-12s %-18s %-16s %-16s %-16s %-12s\n";
        tmp.append(String.format(executorStatFmt, "Executor", "activeCount", "poolSize", "largestPoolSize", "queueSize", "taskCount", "completedTaskCount", "corePoolSize", "maximumPoolSize", "keepAliveTime", "coreTimeOut"));
        tmp.append(String.format(executorStatFmt, "pipeline", pipelineExecutor.getActiveCount(), pipelineExecutor.getPoolSize(), pipelineExecutor.getLargestPoolSize(), pipelineExecutor.getQueue().size(), pipelineExecutor.getTaskCount(), pipelineExecutor.getCompletedTaskCount(), pipelineExecutor.getCorePoolSize(), pipelineExecutor.getMaximumPoolSize(), HumanReadableUtil.timeSpan(pipelineExecutor.getKeepAliveTime(TimeUnit.MILLISECONDS)), pipelineExecutor.allowsCoreThreadTimeOut()));
        return tmp.toString();
    }

    public String getRuntimeInfo() {
        StringBuilder tmp = new StringBuilder();
        tmp.append("STAT\u7edf\u8ba1\u65f6\u957f:\t\t").append(HumanReadableUtil.timeSpan(System.currentTimeMillis() - this.getStatBeginTime())).append("\n");
        tmp.append("\u901a\u9053\u6253\u5f00\u6b21\u6570:\t\t").append(this.channelOpens.get()).append("\n");
        tmp.append("\u901a\u9053\u5173\u95ed\u6b21\u6570:\t\t").append(this.channelCloses.get()).append("\n");
        tmp.append("\u5f53\u524d\u6253\u5f00\u901a\u9053:\t\t").append(this.timeoutInterrupter.currentChannelsNum()).append("\n");
        tmp.append("\u670d\u52a1\u5668\u6e05\u9664\u901a\u9053:\t\t").append(this.timeoutInterrupter.sweepedChannelNum()).append("\n");
        tmp.append("\u901a\u9053\u88ab\u63d0\u524d\u5173\u95ed:\t\t").append(this.channelInterruptCloses.get()).append("\n");
        tmp.append("\n");
        tmp.append(String.format(streamStatFmt, "\u7c7b\u522b", "times", "all_bytes", "avg_bytes", "max"));
        tmp.append(this.inbound);
        tmp.append(this.outbound);
        tmp.append("\n");
        tmp.append(AbstarctTimeSpanStat.tableHeader);
        tmp.append(this.decodeTSS);
        tmp.append(this.processTSS);
        tmp.append(this.encodeTSS);
        tmp.append(this.allTSS);
        tmp.append(this.okTSS);
        tmp.append("401IP\u53d7\u9650:\t\t").append(this.reqs_401).append("\n");
        tmp.append("403\u7981\u6b62\u8bbf\u95ee:\t\t").append(this.reqs_403).append("\n");
        tmp.append("404\u672a\u627e\u5230:\t\t").append(this.reqs_404).append("\n");
        tmp.append("500\u5185\u90e8\u9519\u8bef:\t\t").append(this.reqs_500).append("\n");
        tmp.append("503\u5904\u7406\u8d85\u65f6:\t\t").append(this.reqs_503).append("\n");
        return tmp.toString();
    }

    public long getStatBeginTime() {
        return this.statBeginTime;
    }

    @Override
    public void messageReceived(XLContextAttachment attach) {
        this.decodeTSS.record(attach.getProcess(), attach.getDecode(), attach);
    }

    @Override
    public void messageReceiving(MessageEvent e) {
        if (e.getMessage() instanceof ChannelBuffer) {
            ChannelBuffer b = (ChannelBuffer)e.getMessage();
            this.inbound.record(b.capacity());
        }
    }

    public Object nioworkers(XLHttpRequest request, XLHttpResponse response) throws Exception {
        this.init(request, response);
        return NioWorkerStat.statNioWorkers();
    }

    public Object nioworkersAll(XLHttpRequest request, XLHttpResponse response) throws Exception {
        this.init(request, response);
        return NioWorkerStat.statNioWorkersAll();
    }

    @Override
    public Object process(XLHttpRequest request, XLHttpResponse response) throws Exception {
        this.init(request, response);
        StringBuilder tmp = new StringBuilder();
        tmp.append(this.getRuntimeInfo());
        tmp.append(StatUtil.getSplitStr("-", 160));
        tmp.append(this.getExecutorInfo());
        tmp.append(StatUtil.getSplitStr("-", 160));
        tmp.append(SystemInfo.getSytemInfo());
        tmp.append(StatUtil.getSplitStr("-", 160));
        return tmp.toString();
    }

    public Object tps(XLHttpRequest request, XLHttpResponse response) throws Exception {
        this.init(request, response);
        int sampleSize = request.getParameterInteger("size", 20);
        int interval = request.getParameterInteger("interval", 600);
        boolean calcTps = request.getParameterBoolean("tps", true);
        List<StatisticsHelper.Snapshot> r = this.statisticsHelper.getSnapshot(sampleSize, interval * 1000, calcTps);
        StringBuilder tmp = new StringBuilder();
        for (StatisticsHelper.Snapshot dss : r) {
            tmp.append(dss).append("\n");
        }
        tmp.append("\n");
        if (calcTps) {
            tmp.append("------HISTORY MAX------\n");
            tmp.append(this.statisticsHelper.getMaxTps());
        }
        return tmp.toString();
    }

    public Object runningAttach(XLHttpRequest request, XLHttpResponse response) throws Exception {
        this.init(request, response);
        StringBuilder sb = new StringBuilder();
        sb.append(this.timeoutInterrupter.currentChannelsNum()).append("\n-------------------------\n");
        for (XLContextAttachment attach : this.timeoutInterrupter.getLiveAttach()) {
            Thread t = attach.getProcessThread();
            sb.append(attach).append("\t").append(t == null ? "" : t).append("\n");
        }
        return sb;
    }

    @AfterConfig
    public void reset() {
        this.statBeginTime = System.currentTimeMillis();
        this.channelOpens = new AtomicLong();
        this.channelCloses = new AtomicLong();
        this.channelInterruptCloses = new AtomicLong();
        this.reqs_401 = new AtomicLong();
        this.reqs_503 = new AtomicLong();
        this.reqs_403 = new AtomicLong();
        this.reqs_404 = new AtomicLong();
        this.reqs_500 = new AtomicLong();
        this.decodeTSS = new StageTimeSpanStat("\u89e3\u7801", true);
        this.processTSS = new StageTimeSpanStat("\u4e1a\u52a1", true);
        this.encodeTSS = new StageTimeSpanStat("\u7f16\u7801", true);
        this.allTSS = new StageTimeSpanStat("\u6240\u6709", false);
        this.okTSS = new StageTimeSpanStat("200\u6210\u529f", false);
        this.outbound = new StreamStat("\u53d1\u5305");
        this.inbound = new StreamStat("\u89e3\u5305");
        this.cmdMappers.resetAllCounter();
    }

    public Object threads(XLHttpRequest request, XLHttpResponse response) throws Exception {
        this.init(request, response);
        int max_frames = request.getParameterInteger("max_frames", 8);
        return SystemInfo.getThreadsDetailInfo(max_frames);
    }

    @Override
    public void writeBegin(XLContextAttachment attach) {
        attach.markWriteBegin();
        this.processTSS.record(attach.getEncode(), attach.getProcess(), attach);
    }

    @Override
    public void writeComplete(XLContextAttachment attach, WriteCompletionEvent e) {
        this.outbound.record(e.getWrittenAmount());
        XLHttpResponse resp = attach.getResponse();
        long incr = attach.markWriteEnd();
        long complete = attach.getComplete();
        if (incr == -1L) {
            this.encodeTSS.record(complete, attach.getEncode(), attach);
            this.allTSS.record(complete, attach.getDecode(), attach);
            switch (resp.getStatus().getCode()) {
                case 200: {
                    this.okTSS.record(complete, attach.getDecode(), attach);
                    break;
                }
                case 503: {
                    this.reqs_503.incrementAndGet();
                    break;
                }
                case 401: {
                    this.reqs_401.incrementAndGet();
                    break;
                }
                case 403: {
                    this.reqs_403.incrementAndGet();
                    break;
                }
                case 404: {
                    this.reqs_404.incrementAndGet();
                    break;
                }
                case 500: {
                    this.reqs_500.incrementAndGet();
                }
            }
        } else {
            this.encodeTSS.recordForWriteComplete(incr, complete, attach.getEncode(), attach);
            this.allTSS.recordForWriteComplete(incr, complete, attach.getDecode(), attach);
            if (resp.getStatus().getCode() == 200) {
                this.okTSS.recordForWriteComplete(incr, complete, attach.getDecode(), attach);
            }
        }
    }

    public StageTimeSpanStat getProcessTSS() {
        return this.processTSS;
    }

    @Override
    public void cmdAccess(XLContextAttachment attach) {
        attach.getCmdMeta().access();
    }

    public class StageTimeSpanStat
    extends AbstarctTimeSpanStat {
        private boolean warn;

        public StageTimeSpanStat(String name, boolean warn) {
            super(name);
            this.warn = warn;
        }

        private void record(long end, long begin, XLContextAttachment attach) {
            if (begin <= 0L || end <= 0L) {
                return;
            }
            this.all_num.incrementAndGet();
            long span = end - begin;
            this.all_span.addAndGet(span);
            if (span >= (long)StatCmd.this.config.getSlowThreshold()) {
                this.slow_num.incrementAndGet();
                this.slow_span.addAndGet(span);
                if (this.warn) {
                    log.error("SLOW_PROCESS:{}:{} [{}ms]\n[uri:{}]", new Object[]{this.name, attach, span, attach.getRequest().getUri()});
                }
            }
            if (span > this.max_span) {
                this.max_span = span;
            }
        }

        private void recordForWriteComplete(long incr, long end, long begin, XLContextAttachment attach) {
            if (incr <= 0L || end <= 0L || begin <= 0L) {
                return;
            }
            long span = end - begin;
            long lastSpan = span - incr;
            this.all_span.addAndGet(incr);
            int st = StatCmd.this.config.getSlowThreshold();
            if (span >= (long)st) {
                if (lastSpan >= (long)st) {
                    this.slow_span.addAndGet(incr);
                } else {
                    this.slow_span.addAndGet(span);
                    this.slow_num.incrementAndGet();
                }
            }
            if (span > this.max_span) {
                this.max_span = span;
            }
        }
    }

    public class StreamStat {
        private AtomicLong bytes = new AtomicLong();
        private volatile long max;
        private String name;
        private AtomicLong num = new AtomicLong();

        public StreamStat(String name) {
            this.name = name;
        }

        private void record(long byte_len) {
            this.num.incrementAndGet();
            this.bytes.addAndGet(byte_len);
            if (byte_len > this.max) {
                this.max = byte_len;
            }
        }

        public String toString() {
            long numTmp = this.num.get();
            long bytesTmp = this.bytes.get();
            long avg = numTmp > 0L ? bytesTmp / numTmp : 0L;
            return String.format(StatCmd.streamStatFmt, this.name, numTmp, HumanReadableUtil.byteSize(bytesTmp), HumanReadableUtil.byteSize(avg), HumanReadableUtil.byteSize(this.max));
        }
    }
}

