/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.httpserver.cmd.common;

import com.xunlei.netty.httpserver.HttpServerPipelineFactory;
import com.xunlei.netty.httpserver.cmd.BaseStatCmd;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.cmd.CmdMappers;
import com.xunlei.netty.httpserver.cmd.common.StatCmd;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.netty.httpserver.util.HttpServerConfig;
import com.xunlei.netty.httpserver.util.IPAuthenticator;
import com.xunlei.spring.ConfigAnnotationBeanPostProcessor;
import com.xunlei.util.HttpUtil;
import com.xunlei.util.Log;
import com.xunlei.util.StringTools;
import com.xunlei.util.stat.StatUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SettingCmd
extends BaseStatCmd {
    private static final Logger log = Log.getLogger();
    @Autowired
    private CmdMappers cmdMappers;
    @Autowired
    private HttpServerConfig config;
    @Autowired
    private ConfigAnnotationBeanPostProcessor configProcessor;
    @Autowired
    private HttpServerPipelineFactory pipelineFactory;
    @Autowired
    private StatCmd statCmd;

    @CmdMapper(value={"/robots.txt"})
    public Object robots(XLHttpRequest request, XLHttpResponse response) throws Exception {
        response.setInnerContentType(XLHttpResponse.ContentType.plain);
        return "User-agent: *\nDisallow: /\n";
    }

    public Object cmds(XLHttpRequest request, XLHttpResponse response) throws Exception {
        this.init(request, response);
        boolean useTxt = request.getParameterBoolean("txt", false);
        if (!useTxt) {
            response.setInnerContentType(XLHttpResponse.ContentType.html);
        }
        StringBuilder tmp = new StringBuilder();
        long allNum = this.statCmd.getProcessTSS().getAllNum() + 1L;
        if (useTxt) {
            for (Map.Entry<String, CmdMappers.CmdMeta> e : this.cmdMappers.getCmdAllSortedMap().entrySet()) {
                if (e.getValue() == null) {
                    tmp.append(e.getKey()).append("\n");
                    continue;
                }
                long cmdNum = e.getValue().getNum();
                String cmdNumStr = cmdNum == 0L ? "" : String.valueOf(cmdNum);
                String percentageStr = allNum == 0L || cmdNum == 0L ? "" : StatUtil.getPercentage(cmdNum, allNum);
                tmp.append(String.format("%-4s%-8s%-50s%-50s\n", cmdNumStr, percentageStr, e.getValue(), e.getKey()));
            }
        } else {
            tmp.append("<html><body><table><tbody>\n");
            for (Map.Entry<String, CmdMappers.CmdMeta> e : this.cmdMappers.getCmdAllSortedMap().entrySet()) {
                String percentageStr;
                String url = e.getKey();
                CmdMappers.CmdMeta meta = e.getValue();
                if (meta == null) {
                    tmp.append("<tr><td>&nbsp;&nbsp;&nbsp;&nbsp;</td><td>&nbsp;&nbsp;&nbsp;&nbsp;</td><td>").append(url).append("</td><td></td></tr>\n");
                    continue;
                }
                long cmdNum = e.getValue().getNum();
                String cmdNumStr = cmdNum == 0L ? "" : String.valueOf(cmdNum);
                String string = percentageStr = allNum == 0L || cmdNum == 0L ? "" : StatUtil.getPercentage(cmdNum, allNum);
                String tips = meta.isDisable() ? "Disable" : (meta.getTimeout() == 0 ? "NoTimeout" : String.valueOf(meta.getTimeout()));
                tmp.append(String.format("<tr><td>%-8s</td><td>%-8s</td><td>%-50s</td><td><a title=\"%s\" href=\"%s\" target=\"_blank\">%s</a></td></tr>\n", cmdNumStr, percentageStr, meta, tips, url, url));
            }
            tmp.append("</tbody></table></body></html>");
        }
        return tmp.toString();
    }

    public Object config(XLHttpRequest request, XLHttpResponse response) throws Exception {
        this.init(request, response);
        return this.configProcessor.printCurrentConfig(new StringBuilder());
    }

    public Object configHistory(XLHttpRequest request, XLHttpResponse response) throws Exception {
        this.init(request, response);
        StringBuilder tmp = new StringBuilder();
        return tmp.append((CharSequence)this.configProcessor.getResetHistory());
    }

    public Object httpServerConfig(XLHttpRequest request, XLHttpResponse response) throws Exception {
        this.init(request, response);
        StringBuilder tmp = new StringBuilder();
        Field[] fieldArray = this.config.getClass().getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            if (!Modifier.isStatic(f.getModifiers())) {
                f.setAccessible(true);
                try {
                    tmp.append(String.format("%-24s%-10s\n", String.valueOf(f.getName()) + ":", f.get(this.config)));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        tmp.append("\u672c\u5730IP:\t\t\t").append(HttpUtil.getLocalIP()).append("\n");
        tmp.append("IP\u767d\u540d\u5355:\t\t").append(IPAuthenticator.getIPAuthenticatorInfo()).append("\n");
        try {
            tmp.append("PIPELINE:\t\t").append(this.pipelineFactory.getPipeline()).append("\n");
        }
        catch (Exception e) {
            log.error("", e);
            tmp.append(e.getMessage()).append("\n");
        }
        return tmp.toString();
    }

    public Object reloadConfig(XLHttpRequest request, XLHttpResponse response) throws Exception {
        this.init(request, response);
        StringBuilder tmp = new StringBuilder();
        this.configProcessor.reloadConfig(tmp);
        return tmp.toString();
    }

    public Object reloadCmdConfig(XLHttpRequest request, XLHttpResponse response) throws Exception {
        this.init(request, response);
        return this.cmdMappers.resetCmdConfig();
    }

    public Object reloadIpfilter(XLHttpRequest request, XLHttpResponse response) throws Exception {
        this.init(request, response);
        boolean localhostpass = request.getParameterBoolean("localpass", IPAuthenticator.LOCALHOST_PASS);
        log.error("START RELOAD IPFILTER,localpass:{}", localhostpass);
        IPAuthenticator.reload(localhostpass);
        return "reset success";
    }

    public Object activeIpfilter(XLHttpRequest request, XLHttpResponse response) throws Exception {
        response.setInnerContentType(XLHttpResponse.ContentType.plain);
        int step = request.getParameterInteger("step", -1);
        String key = request.getParameter("key");
        if (step == 1) {
            String mail = request.getParameterCompelled("mail");
            boolean r = IPAuthenticator.sendActiveMail(mail, request.getRemoteIP());
            return "sendActiveMail:" + r;
        }
        if (StringTools.isNotEmpty(key)) {
            boolean r = IPAuthenticator.handleActiveMail(request.getParameterCompelled("mail"), request.getRemoteIP(), request.getParameterLong("time"), request.getParameterCompelled("key"));
            return "activeIpfilter:" + r;
        }
        Set<String> list = IPAuthenticator.getActiveMailList();
        if (list.isEmpty()) {
            return "ActiveMailList isEmpty";
        }
        response.setInnerContentType(XLHttpResponse.ContentType.html);
        StringBuilder tmp = new StringBuilder();
        tmp.append("<html><body><table><tbody>\n");
        for (String m : list) {
            tmp.append(String.format("<tr><td><a href=\"?step=1&mail=%s\">%s</a></td></tr>\n", m, m));
        }
        tmp.append("</tbody></table></body></html>");
        return tmp.toString();
    }

    public Object resetGuardedConfig(XLHttpRequest request, XLHttpResponse response) throws Exception {
        this.init(request, response);
        StringBuilder tmp = new StringBuilder("reset guarded config...\n");
        this.configProcessor.resetGuradedConfig(tmp);
        return tmp;
    }

    public Object resetStat(XLHttpRequest request, XLHttpResponse response) throws Exception {
        this.init(request, response);
        this.statCmd.reset();
        return "reset stat success";
    }

    public Object setConfig(XLHttpRequest request, XLHttpResponse response) throws Exception {
        this.init(request, response);
        StringBuilder tmp = new StringBuilder("set tmp config...\n");
        for (Map.Entry<String, List<String>> e : request.getParameters().entrySet()) {
            String fieldName = e.getKey();
            String value = e.getValue().get(0);
            this.configProcessor.setFieldValue(fieldName, value, tmp);
        }
        return tmp.toString();
    }
}

