/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.httpserver.cmd;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class PathMap
extends HashMap<Object, Object>
implements Externalizable {
    private static String pathSeperators = ":,";
    StringMap _prefixMap = new StringMap();
    StringMap _suffixMap = new StringMap();
    StringMap _exactMap = new StringMap();
    List _defaultSingletonList = null;
    Entry _prefixDefault = null;
    Set _entrySet;

    public static void setPathSpecSeparators(String s) {
        pathSeperators = s;
    }

    public PathMap() {
        super(11);
        this._entrySet = this.entrySet();
    }

    public PathMap(int capacity) {
        super(capacity);
        this._entrySet = this.entrySet();
    }

    public PathMap(Map m) {
        this.putAll(m);
        this._entrySet = this.entrySet();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        HashMap<Object, Object> map = new HashMap<Object, Object>(this);
        out.writeObject(map);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        HashMap map = (HashMap)in.readObject();
        this.putAll(map);
    }

    @Override
    public synchronized Object put(Object pathSpec, Object object) {
        StringTokenizer tok = new StringTokenizer(pathSpec.toString(), pathSeperators);
        Object old = null;
        while (tok.hasMoreTokens()) {
            String spec = tok.nextToken();
            if (!spec.startsWith("/") && !spec.startsWith("*.")) {
                throw new IllegalArgumentException("PathSpec " + spec + ". must start with '/' or '*.'");
            }
            old = super.put(spec, object);
            Entry<Object> entry = new Entry<Object>(spec, object);
            if (!entry.getKey().equals(spec)) continue;
            if (spec.equals("/*")) {
                this._prefixDefault = entry;
                continue;
            }
            if (spec.endsWith("/*")) {
                String mapped = spec.substring(0, spec.length() - 2);
                entry.setMapped(mapped);
                this._prefixMap.put(mapped, (Object)entry);
                this._exactMap.put(mapped, (Object)entry);
                continue;
            }
            if (!spec.startsWith("*.")) continue;
            this._suffixMap.put(spec.substring(2), (Object)entry);
        }
        return old;
    }

    public Object match(String path) {
        Entry entry = this.getMatch(path);
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }

    public Entry getMatch(String path) {
        if (path == null) {
            return null;
        }
        int l = path.length();
        Map.Entry entry = this._exactMap.getEntry(path, 0, l);
        if (entry != null) {
            return (Entry)entry.getValue();
        }
        int i = l;
        while ((i = path.lastIndexOf(47, i - 1)) >= 0) {
            entry = this._prefixMap.getEntry(path, 0, i);
            if (entry == null) continue;
            return (Entry)entry.getValue();
        }
        if (this._prefixDefault != null) {
            return this._prefixDefault;
        }
        i = 0;
        while ((i = path.indexOf(46, i + 1)) > 0) {
            entry = this._suffixMap.getEntry(path, i + 1, l - i - 1);
            if (entry == null) continue;
            return (Entry)entry.getValue();
        }
        return null;
    }

    public Object getLazyMatches(String path) {
        Object entries = null;
        if (path == null) {
            return PathMap.getList(entries);
        }
        int l = path.length();
        Map.Entry entry = this._exactMap.getEntry(path, 0, l);
        if (entry != null) {
            entries = PathMap.add(entries, entry.getValue());
        }
        int i = l - 1;
        while ((i = path.lastIndexOf(47, i - 1)) >= 0) {
            entry = this._prefixMap.getEntry(path, 0, i);
            if (entry == null) continue;
            entries = PathMap.add(entries, entry.getValue());
        }
        if (this._prefixDefault != null) {
            entries = PathMap.add(entries, this._prefixDefault);
        }
        i = 0;
        while ((i = path.indexOf(46, i + 1)) > 0) {
            entry = this._suffixMap.getEntry(path, i + 1, l - i - 1);
            if (entry == null) continue;
            entries = PathMap.add(entries, entry.getValue());
        }
        return entries;
    }

    public List getMatches(String path) {
        return PathMap.getList(this.getLazyMatches(path));
    }

    public boolean containsMatch(String path) {
        Entry match = this.getMatch(path);
        return match != null;
    }

    @Override
    public synchronized Object remove(Object pathSpec) {
        if (pathSpec != null) {
            String spec = (String)pathSpec;
            if (spec.equals("/*")) {
                this._prefixDefault = null;
            } else if (spec.endsWith("/*")) {
                this._prefixMap.remove(spec.substring(0, spec.length() - 2));
                this._exactMap.remove(spec.substring(0, spec.length() - 1));
                this._exactMap.remove(spec.substring(0, spec.length() - 2));
            } else if (spec.startsWith("*.")) {
                this._suffixMap.remove(spec.substring(2));
            } else if (spec.equals("/")) {
                this._defaultSingletonList = null;
            } else {
                this._exactMap.remove(spec);
            }
        }
        return super.remove(pathSpec);
    }

    @Override
    public void clear() {
        this._exactMap = new StringMap();
        this._prefixMap = new StringMap();
        this._suffixMap = new StringMap();
        this._defaultSingletonList = null;
        super.clear();
    }

    public static boolean match(String pathSpec, String path) throws IllegalArgumentException {
        return PathMap.match(pathSpec, path, false);
    }

    public static boolean match(String pathSpec, String path, boolean noDefault) throws IllegalArgumentException {
        char c = pathSpec.charAt(0);
        if (c == '/') {
            if (!noDefault && pathSpec.length() == 1 || pathSpec.equals(path)) {
                return true;
            }
            if (PathMap.isPathWildcardMatch(pathSpec, path)) {
                return true;
            }
        } else if (c == '*') {
            return path.regionMatches(path.length() - pathSpec.length() + 1, pathSpec, 1, pathSpec.length() - 1);
        }
        return false;
    }

    private static boolean isPathWildcardMatch(String pathSpec, String path) {
        int cpl = pathSpec.length() - 2;
        return pathSpec.endsWith("/*") && path.regionMatches(0, pathSpec, 0, cpl) && (path.length() == cpl || '/' == path.charAt(cpl));
    }

    public static String pathMatch(String pathSpec, String path) {
        char c = pathSpec.charAt(0);
        if (c == '/') {
            if (pathSpec.length() == 1) {
                return path;
            }
            if (pathSpec.equals(path)) {
                return path;
            }
            if (PathMap.isPathWildcardMatch(pathSpec, path)) {
                return path.substring(0, pathSpec.length() - 2);
            }
        } else if (c == '*' && path.regionMatches(path.length() - (pathSpec.length() - 1), pathSpec, 1, pathSpec.length() - 1)) {
            return path;
        }
        return null;
    }

    public static String pathInfo(String pathSpec, String path) {
        char c = pathSpec.charAt(0);
        if (c == '/') {
            if (pathSpec.length() == 1) {
                return null;
            }
            boolean wildcard = PathMap.isPathWildcardMatch(pathSpec, path);
            if (pathSpec.equals(path) && !wildcard) {
                return null;
            }
            if (wildcard) {
                if (path.length() == pathSpec.length() - 2) {
                    return null;
                }
                return path.substring(pathSpec.length() - 2);
            }
        }
        return null;
    }

    public static String relativePath(String base, String pathSpec, String path) {
        String info = PathMap.pathInfo(pathSpec, path);
        if (info == null) {
            info = path;
        }
        if (info.startsWith("./")) {
            info = info.substring(2);
        }
        path = base.endsWith("/") ? (info.startsWith("/") ? String.valueOf(base) + info.substring(1) : String.valueOf(base) + info) : (info.startsWith("/") ? String.valueOf(base) + info : String.valueOf(base) + "/" + info);
        return path;
    }

    public static Object add(Object list, Object item) {
        if (list == null) {
            if (item instanceof List || item == null) {
                ArrayList<Object> l = new ArrayList<Object>();
                l.add(item);
                return l;
            }
            return item;
        }
        if (list instanceof List) {
            ((List)list).add(item);
            return list;
        }
        ArrayList<Object> l = new ArrayList<Object>();
        l.add(list);
        l.add(item);
        return l;
    }

    public static List getList(Object list) {
        if (list == null) {
            return null;
        }
        if (list instanceof List) {
            return (List)list;
        }
        ArrayList<Object> l = new ArrayList<Object>(1);
        l.add(list);
        return l;
    }

    public static class Entry<K>
    implements Map.Entry<Object, Object> {
        private K key;
        private K value;
        private K mapped;

        Entry(K key, K value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public K getValue() {
            return this.value;
        }

        @Override
        public K setValue(Object o) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        public K getMapped() {
            return this.mapped;
        }

        void setMapped(K mapped) {
            this.mapped = mapped;
        }
    }

    public static class StringMap
    extends AbstractMap
    implements Externalizable {
        public static final boolean CASE_INSENSTIVE = true;
        protected static final int __HASH_WIDTH = 17;
        protected int _width = 17;
        protected Node _root = new Node();
        protected boolean _ignoreCase = false;
        protected Object _nullValue = null;
        protected HashSet _entrySet = new HashSet(3);

        public StringMap() {
        }

        public StringMap(boolean ignoreCase) {
            this();
            this._ignoreCase = ignoreCase;
        }

        public StringMap(boolean ignoreCase, int width) {
            this();
            this._ignoreCase = ignoreCase;
            this._width = width;
        }

        public void setIgnoreCase(boolean ic) {
            if (this._root._children != null) {
                throw new IllegalStateException("Must be set before first put");
            }
            this._ignoreCase = ic;
        }

        public boolean isIgnoreCase() {
            return this._ignoreCase;
        }

        public void setWidth(int width) {
            this._width = width;
        }

        public int getWidth() {
            return this._width;
        }

        @Override
        public Object put(Object key, Object value) {
            if (key == null) {
                return this.put(null, value);
            }
            return this.put(key.toString(), value);
        }

        @Override
        public Object put(String key, Object value) {
            if (key == null) {
                Object oldValue = this._nullValue;
                this._nullValue = value;
                return oldValue;
            }
            Node node = this._root;
            int ni = -1;
            Node prev = null;
            Node parent = null;
            int i = 0;
            while (i < key.length()) {
                block15: {
                    char c = key.charAt(i);
                    if (ni == -1) {
                        parent = node;
                        prev = null;
                        ni = 0;
                        node = node._children == null ? null : node._children[c % this._width];
                    }
                    while (node != null) {
                        if (node._char[ni] == c || this._ignoreCase && node._ochar[ni] == c) {
                            prev = null;
                            if (++ni == node._char.length) {
                                ni = -1;
                            }
                        } else {
                            if (ni == 0) {
                                prev = node;
                                node = node._next;
                                continue;
                            }
                            node.split(this, ni);
                            --i;
                            ni = -1;
                        }
                        break block15;
                    }
                    node = new Node(this._ignoreCase, key, i);
                    if (prev != null) {
                        prev._next = node;
                        break;
                    }
                    if (parent != null) {
                        if (parent._children == null) {
                            parent._children = new Node[this._width];
                        }
                        parent._children[c % this._width] = node;
                        int oi = node._ochar[0] % this._width;
                        if (node._ochar == null || node._char[0] % this._width == oi) break;
                        if (parent._children[oi] == null) {
                            parent._children[oi] = node;
                            break;
                        }
                        Node n = parent._children[oi];
                        while (n._next != null) {
                            n = n._next;
                        }
                        n._next = node;
                        break;
                    }
                    this._root = node;
                    break;
                }
                ++i;
            }
            if (node != null) {
                if (ni > 0) {
                    node.split(this, ni);
                }
                Object old = node._value;
                node._key = key;
                node._value = value;
                this._entrySet.add(node);
                return old;
            }
            return null;
        }

        @Override
        public Object get(Object key) {
            if (key == null) {
                return this._nullValue;
            }
            if (key instanceof String) {
                return this.get((String)key);
            }
            return this.get(key.toString());
        }

        public Object get(String key) {
            if (key == null) {
                return this._nullValue;
            }
            Map.Entry entry = this.getEntry(key, 0, key.length());
            if (entry == null) {
                return null;
            }
            return entry.getValue();
        }

        public Map.Entry getEntry(String key, int offset, int length) {
            if (key == null) {
                return null;
            }
            Node node = this._root;
            int ni = -1;
            int i = 0;
            while (i < length) {
                block9: {
                    char c = key.charAt(offset + i);
                    if (ni == -1) {
                        ni = 0;
                        node = node._children == null ? null : node._children[c % this._width];
                    }
                    while (node != null) {
                        if (node._char[ni] == c || this._ignoreCase && node._ochar[ni] == c) {
                            if (++ni == node._char.length) {
                                ni = -1;
                            }
                            break block9;
                        }
                        if (ni > 0) {
                            return null;
                        }
                        node = node._next;
                    }
                    return null;
                }
                ++i;
            }
            if (ni > 0) {
                return null;
            }
            if (node != null && node._key == null) {
                return null;
            }
            return node;
        }

        public Map.Entry getEntry(char[] key, int offset, int length) {
            if (key == null) {
                return null;
            }
            Node node = this._root;
            int ni = -1;
            int i = 0;
            while (i < length) {
                block9: {
                    char c = key[offset + i];
                    if (ni == -1) {
                        ni = 0;
                        node = node._children == null ? null : node._children[c % this._width];
                    }
                    while (node != null) {
                        if (node._char[ni] == c || this._ignoreCase && node._ochar[ni] == c) {
                            if (++ni == node._char.length) {
                                ni = -1;
                            }
                            break block9;
                        }
                        if (ni > 0) {
                            return null;
                        }
                        node = node._next;
                    }
                    return null;
                }
                ++i;
            }
            if (ni > 0) {
                return null;
            }
            if (node != null && node._key == null) {
                return null;
            }
            return node;
        }

        public Map.Entry getBestEntry(byte[] key, int offset, int maxLength) {
            if (key == null) {
                return null;
            }
            Node node = this._root;
            int ni = -1;
            int i = 0;
            while (i < maxLength) {
                block10: {
                    char c = (char)key[offset + i];
                    if (ni == -1) {
                        Node child;
                        ni = 0;
                        Node node2 = child = node._children == null ? null : node._children[c % this._width];
                        if (child == null && i > 0) {
                            return node;
                        }
                        node = child;
                    }
                    while (node != null) {
                        if (node._char[ni] == c || this._ignoreCase && node._ochar[ni] == c) {
                            if (++ni == node._char.length) {
                                ni = -1;
                            }
                            break block10;
                        }
                        if (ni > 0) {
                            return null;
                        }
                        node = node._next;
                    }
                    return null;
                }
                ++i;
            }
            if (ni > 0) {
                return null;
            }
            if (node != null && node._key == null) {
                return null;
            }
            return node;
        }

        @Override
        public Object remove(Object key) {
            if (key == null) {
                return this.remove(null);
            }
            return this.remove(key.toString());
        }

        public Object remove(String key) {
            if (key == null) {
                Object oldValue = this._nullValue;
                return oldValue;
            }
            Node node = this._root;
            int ni = -1;
            int i = 0;
            while (i < key.length()) {
                block9: {
                    char c = key.charAt(i);
                    if (ni == -1) {
                        ni = 0;
                        node = node._children == null ? null : node._children[c % this._width];
                    }
                    while (node != null) {
                        if (node._char[ni] == c || this._ignoreCase && node._ochar[ni] == c) {
                            if (++ni == node._char.length) {
                                ni = -1;
                            }
                            break block9;
                        }
                        if (ni > 0) {
                            return null;
                        }
                        node = node._next;
                    }
                    return null;
                }
                ++i;
            }
            if (ni > 0) {
                return null;
            }
            if (node != null && node._key == null) {
                return null;
            }
            Object old = node._value;
            this._entrySet.remove(node);
            node._value = null;
            node._key = null;
            return old;
        }

        public HashSet entrySet() {
            return this._entrySet;
        }

        @Override
        public int size() {
            return this._entrySet.size();
        }

        @Override
        public boolean isEmpty() {
            return this._entrySet.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            if (key == null) {
                return false;
            }
            return this.getEntry(key.toString(), 0, key == null ? 0 : key.toString().length()) != null;
        }

        @Override
        public void clear() {
            this._root = new Node();
            this._nullValue = null;
            this._entrySet.clear();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            HashMap map = new HashMap(this);
            out.writeBoolean(this._ignoreCase);
            out.writeObject(map);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            boolean ic = in.readBoolean();
            HashMap map = (HashMap)in.readObject();
            this.setIgnoreCase(ic);
            this.putAll(map);
        }

        private static class Node
        implements Map.Entry {
            char[] _char;
            char[] _ochar;
            Node _next;
            Node[] _children;
            String _key;
            Object _value;

            Node() {
            }

            Node(boolean ignoreCase, String s, int offset) {
                int l = s.length() - offset;
                this._char = new char[l];
                this._ochar = new char[l];
                int i = 0;
                while (i < l) {
                    char c;
                    this._char[i] = c = s.charAt(offset + i);
                    if (ignoreCase) {
                        char o = c;
                        if (Character.isUpperCase(c)) {
                            o = Character.toLowerCase(c);
                        } else if (Character.isLowerCase(c)) {
                            o = Character.toUpperCase(c);
                        }
                        this._ochar[i] = o;
                    }
                    ++i;
                }
            }

            Node split(StringMap map, int offset) {
                Node split = new Node();
                int sl = this._char.length - offset;
                char[] tmp = this._char;
                this._char = new char[offset];
                split._char = new char[sl];
                System.arraycopy(tmp, 0, this._char, 0, offset);
                System.arraycopy(tmp, offset, split._char, 0, sl);
                if (this._ochar != null) {
                    tmp = this._ochar;
                    this._ochar = new char[offset];
                    split._ochar = new char[sl];
                    System.arraycopy(tmp, 0, this._ochar, 0, offset);
                    System.arraycopy(tmp, offset, split._ochar, 0, sl);
                }
                split._key = this._key;
                split._value = this._value;
                this._key = null;
                this._value = null;
                if (map._entrySet.remove(this)) {
                    map._entrySet.add(split);
                }
                split._children = this._children;
                this._children = new Node[map._width];
                this._children[split._char[0] % map._width] = split;
                if (split._ochar != null && this._children[split._ochar[0] % map._width] != split) {
                    this._children[split._ochar[0] % map._width] = split;
                }
                return split;
            }

            public Object getKey() {
                return this._key;
            }

            public Object getValue() {
                return this._value;
            }

            public Object setValue(Object o) {
                Object old = this._value;
                this._value = o;
                return old;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String toString() {
                StringBuffer buf;
                StringBuffer stringBuffer = buf = new StringBuffer();
                synchronized (stringBuffer) {
                    this.toString(buf);
                }
                return buf.toString();
            }

            private void toString(StringBuffer buf) {
                int i;
                buf.append("{[");
                if (this._char == null) {
                    buf.append('-');
                } else {
                    i = 0;
                    while (i < this._char.length) {
                        buf.append(this._char[i]);
                        ++i;
                    }
                }
                buf.append(':');
                buf.append(this._key);
                buf.append('=');
                buf.append(this._value);
                buf.append(']');
                if (this._children != null) {
                    i = 0;
                    while (i < this._children.length) {
                        buf.append('|');
                        if (this._children[i] != null) {
                            this._children[i].toString(buf);
                        } else {
                            buf.append("-");
                        }
                        ++i;
                    }
                }
                buf.append('}');
                if (this._next != null) {
                    buf.append(",\n");
                    this._next.toString(buf);
                }
            }
        }
    }
}

