/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.netty.httpserver;

import com.xunlei.netty.httpserver.Bootstrap;
import com.xunlei.netty.httpserver.component.AbstractPageDispatcher;
import com.xunlei.netty.httpserver.component.NOPDispatcher;
import com.xunlei.netty.httpserver.component.XLHttpRequestDecoder;
import com.xunlei.netty.httpserver.component.XLHttpResponseEncoder;
import com.xunlei.netty.httpserver.util.HttpServerConfig;
import com.xunlei.spring.AfterConfig;
import com.xunlei.util.Log;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.codec.http.HttpChunkAggregator;
import org.jboss.netty.handler.codec.http.HttpContentCompressor;
import org.jboss.netty.handler.codec.http.HttpResponseEncoder;
import org.jboss.netty.handler.execution.ExecutionHandler;
import org.jboss.netty.handler.timeout.IdleStateAwareChannelHandler;
import org.jboss.netty.handler.timeout.IdleStateEvent;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HttpServerPipelineFactory
implements ChannelPipelineFactory {
    private static final Logger log = Log.getLogger();
    @Autowired
    private Bootstrap bootstrap;
    @Autowired
    private HttpServerConfig config;
    private Map<String, ChannelHandler> currentPipelineMap;
    private HttpContentCompressor deflater = new HttpContentCompressor();
    private HttpResponseEncoder encoder = new XLHttpResponseEncoder();
    private ExecutionHandler executionHandler;
    private IdleStateAwareChannelHandler idleAwareHandler;
    private Timer idleCheckTimer;
    @Autowired
    private NOPDispatcher nopDispatcher;
    @Autowired
    private AbstractPageDispatcher pageDispatcher;

    public ChannelPipeline _getPipeline() throws Exception {
        ChannelPipeline pipeline = Channels.pipeline();
        boolean https = false;
        boolean chunks = false;
        boolean idle_check = true;
        pipeline.addLast("decoder", new XLHttpRequestDecoder(this.config.getStatistics(), this.config));
        if (chunks) {
            pipeline.addLast("aggregator", new HttpChunkAggregator(0x100000));
        }
        pipeline.addLast("encoder", this.encoder);
        if (idle_check) {
            pipeline.addLast("idleAwareHandler", this.getIdleAwareHandle());
        }
        pipeline.addLast("pageDispatcher", this.pageDispatcher);
        if (log.isDebugEnabled()) {
            log.debug("pipeline#{}:{}", pipeline.hashCode(), (Object)pipeline);
        }
        return pipeline;
    }

    public IdleStateAwareChannelHandler getIdleAwareHandle() {
        if (this.idleAwareHandler == null) {
            this.idleAwareHandler = new SimpleIdleStateAwareChannelHandler();
        }
        return this.idleAwareHandler;
    }

    public Timer getIdleCheckTimer() {
        if (this.idleCheckTimer == null) {
            this.idleCheckTimer = new HashedWheelTimer();
        }
        return this.idleCheckTimer;
    }

    @Override
    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline pipeline = Channels.pipeline();
        for (Map.Entry<String, ChannelHandler> e : this.currentPipelineMap.entrySet()) {
            pipeline.addLast(e.getKey(), e.getValue());
        }
        pipeline.replace("DECODER", "decoder", (ChannelHandler)new XLHttpRequestDecoder(this.config.getStatistics(), this.config));
        return pipeline;
    }

    @AfterConfig
    public void init() {
        this.executionHandler = new ExecutionHandler(this.config.getPipelineExecutor());
    }

    private ChannelPipeline initPipeline() {
        ChannelPipeline pipeline = Channels.pipeline();
        if (this.bootstrap.isStop()) {
            pipeline.addLast("nop", this.nopDispatcher);
            return pipeline;
        }
        pipeline.addLast("DECODER", new XLHttpRequestDecoder(this.config.getStatistics(), this.config));
        pipeline.addLast("encoder", this.encoder);
        if (this.config.isPlAddDefalter()) {
            pipeline.addLast("deflater", this.deflater);
        }
        pipeline.addLast("pageDispatcher", this.pageDispatcher);
        String addBefore = this.config.getPlAddBefore();
        if (addBefore != null) {
            if (addBefore.isEmpty()) {
                pipeline.addFirst("executor", this.executionHandler);
            } else {
                try {
                    pipeline.addBefore(addBefore, "executor", this.executionHandler);
                }
                catch (NoSuchElementException e) {
                    log.error("config error,config.plAddBefore:{} NOT FOUND,execption:{}", (Object)addBefore, (Object)e);
                    pipeline.addFirst("executor", this.executionHandler);
                }
            }
        }
        return pipeline;
    }

    public void rebuildPipeline() {
        if (this.bootstrap == null || this.config == null) {
            return;
        }
        ChannelPipeline pipeline = this.initPipeline();
        Map<String, ChannelHandler> pipelineMap = pipeline.toMap();
        log.error("CurrentPipelineMap[{}]:{}", pipelineMap.size(), pipelineMap);
        this.currentPipelineMap = pipelineMap;
    }

    public class SimpleIdleStateAwareChannelHandler
    extends IdleStateAwareChannelHandler {
        @Override
        public void channelIdle(ChannelHandlerContext ctx, IdleStateEvent e) {
            log.debug("channel:{},idleState:{}", e.getChannel(), (Object)e.getState());
            e.getChannel().close();
        }
    }
}

