/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.httptool.login;

import com.xunlei.proxy.ProxyFactory;
import com.xunlei.proxy.socket.HaoProxy;
import com.xunlei.proxy.socket.LoginProxy;
import com.xunlei.proxy.socket.UserInfoProxy;
import com.xunlei.proxy.socket.bin.resp.Resp_register;
import com.xunlei.proxy.socket.bin.resp.Resp_registeruser;
import com.xunlei.proxy.socket.bin.resp.Resp_set;
import com.xunlei.spring.Config;
import com.xunlei.util.Log;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class RegisterBo {
    private static final Logger log = Log.getLogger();
    private static final UserInfoProxy userInfoProxy = ProxyFactory.getInstance().getUserInfoProxy();
    private static final HaoProxy haoProxy = ProxyFactory.getInstance().getHaoProxy();
    private static final LoginProxy loginProxy = ProxyFactory.getInstance().getLoginProxy();
    @Config(resetable=true)
    private int registerapplyiid = 4;

    public Register quickRegister(String mail, String nickname, String md5pwd, String remoteIp) {
        long newUserId = haoProxy.getone();
        Register result = new Register();
        result.mail = mail;
        result.nickName = nickname;
        if (newUserId < 0L) {
            log.error("error:getone,mail:{},md5pwd:{},ip:{}", new Object[]{mail, md5pwd, remoteIp});
            result.sessionId = "error:getone";
            return result;
        }
        Resp_registeruser resp_registeruser = userInfoProxy.registeruser(String.valueOf(newUserId), (byte)1, md5pwd, "nickname", nickname, "registerip", remoteIp, "registerapplyiid", this.registerapplyiid);
        if (resp_registeruser.isOk()) {
            long userId = resp_registeruser.getUserno();
            result.userId = userId;
            Resp_set resp_set = userInfoProxy.bind(String.valueOf(userId), (byte)2, mail, (byte)4);
            if (resp_set.isOk()) {
                Resp_register resp_register = loginProxy.register(userId);
                if (resp_register.isOk()) {
                    result.sessionId = resp_register.getSessionid();
                } else {
                    log.error("error:register,mail:{},md5pwd:{},ip:{},userId:{},resp_register:{}", new Object[]{mail, md5pwd, remoteIp, userId, resp_register});
                    result.sessionId = "error:register:" + resp_register.getResult();
                }
            } else {
                log.error("error:bind,mail:{},md5pwd:{},ip:{},userId:{},resp_set:{}", new Object[]{mail, md5pwd, remoteIp, userId, resp_set});
                result.sessionId = "error:bind:" + resp_set.getResult();
            }
        } else {
            log.error("error:registeruser,mail:{},md5pwd:{},ip:{},resp_set:{}", new Object[]{mail, md5pwd, remoteIp, resp_registeruser});
            result.sessionId = "error:registeruser:" + resp_registeruser.getResult();
        }
        return result;
    }

    public class Register {
        private String sessionId;
        private long userId;
        private String nickName;
        private String mail;

        public String getSessionId() {
            return this.sessionId;
        }

        public long getUserId() {
            return this.userId;
        }

        public String getNickName() {
            return this.nickName;
        }

        public String getMail() {
            return this.mail;
        }
    }
}

