/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.httptool;

import com.xunlei.netty.httpserver.cmd.BaseCmd;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.netty.httpserver.util.IPAuthenticator;
import com.xunlei.proxy.ProxyFactory;
import com.xunlei.proxy.http.VipProxy;
import com.xunlei.proxy.socket.LoginProxy;
import com.xunlei.proxy.socket.UserInfoProxy;
import org.springframework.stereotype.Service;

@Service
public class ServerProxyCmd
extends BaseCmd {
    private LoginProxy loginProxy = ProxyFactory.getInstance().getLoginProxy();
    private UserInfoProxy userInfoProxy = ProxyFactory.getInstance().getUserInfoProxy();
    private VipProxy vipProxy = ProxyFactory.getInstance().getVipProxy();

    private String getUserId(XLHttpRequest request, XLHttpResponse response) throws Exception {
        return this.initOneParam(request, response, "userid");
    }

    private byte getUserType(XLHttpRequest request, XLHttpResponse response) throws Exception {
        return (byte)request.getParameterInteger("type", 2);
    }

    public Object getuserinfo_base(XLHttpRequest request, XLHttpResponse response) throws Exception {
        return this.userInfoProxy.getuserinfo_base(this.getUserId(request, response), this.getUserType(request, response));
    }

    public Object getuserinfo_score(XLHttpRequest request, XLHttpResponse response) throws Exception {
        return this.userInfoProxy.getuserinfo_score(this.getUserId(request, response), this.getUserType(request, response));
    }

    public Object getuserinfo_sec(XLHttpRequest request, XLHttpResponse response) throws Exception {
        return this.userInfoProxy.getuserinfo_sec(this.getUserId(request, response), this.getUserType(request, response));
    }

    public Object getUserVas(XLHttpRequest request, XLHttpResponse response) throws Exception {
        return this.vipProxy.getUserVas(this.getUserId(request, response), this.getUserType(request, response));
    }

    public Object getusrinfor(XLHttpRequest request, XLHttpResponse response) throws Exception {
        return this.loginProxy.getusrinfor(this.initOneParam(request, response, "sessionid"));
    }

    public Object validateSessionId(XLHttpRequest request, XLHttpResponse response) throws Exception {
        return this.loginProxy.validateSessionId(this.initOneParam(request, response, "sessionid"));
    }

    public Object getVipState(XLHttpRequest request, XLHttpResponse response) throws Exception {
        return this.vipProxy.getVipState(Long.valueOf(this.getUserId(request, response)));
    }

    private String initOneParam(XLHttpRequest request, XLHttpResponse response, String key) throws Exception {
        response.setInnerContentType(XLHttpResponse.ContentType.json);
        IPAuthenticator.auth(this, request);
        String r = request.getParameter(key);
        if (r == null) {
            r = request.getCookieValueCompelled(key);
        }
        return r;
    }

    public Object name2id(XLHttpRequest request, XLHttpResponse response) throws Exception {
        return this.userInfoProxy.name2id(this.getUserId(request, response), this.getUserType(request, response));
    }

    public Object used2be(XLHttpRequest request, XLHttpResponse response) throws Exception {
        return this.vipProxy.used2be(Long.valueOf(this.getUserId(request, response)));
    }
}

