/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.web.model;

import com.xunlei.common.plugin.FilterPluginable;
import com.xunlei.common.plugin.ThrowableHanderPluginable;
import com.xunlei.common.plugin.UserCookiePluginable;
import com.xunlei.common.util.ApplicationConfigUtil;
import com.xunlei.common.util.StringTools;
import com.xunlei.common.util.UserCookie;
import com.xunlei.common.vo.UserInfo;
import com.xunlei.common.web.model.LoginTool;
import com.xunlei.common.web.model.LoginUserContainer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import javax.faces.FacesException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class WebCommonFilter
implements Filter {
    private static Logger log = null;
    private String webroot = null;
    private String exceptionTemplate = null;
    private String[] excludepages = new String[0];
    private String[] excludecatalogs = new String[0];
    private Map<String, String> filterpathsMap = new HashMap<String, String>();
    private final List<FilterPluginable> filterplugins = new ArrayList<FilterPluginable>(1);
    private final List<UserCookiePluginable> userCookiePlugins = new ArrayList<UserCookiePluginable>(1);
    private final List<ThrowableHanderPluginable> throwableplugins = new ArrayList<ThrowableHanderPluginable>(1);
    protected static Log logger = LogFactory.getLog(WebCommonFilter.class);

    private void initFilterPluginable() {
        ServiceLoader<FilterPluginable> loader = ServiceLoader.load(FilterPluginable.class);
        Iterator<FilterPluginable> it = loader.iterator();
        while (it.hasNext()) {
            this.filterplugins.add(it.next());
        }
    }

    private void initThrowableHanderPluginable() {
        ServiceLoader<ThrowableHanderPluginable> loader = ServiceLoader.load(ThrowableHanderPluginable.class);
        Iterator<ThrowableHanderPluginable> it = loader.iterator();
        while (it.hasNext()) {
            this.throwableplugins.add(it.next());
        }
    }

    private void initUserCookiePluginable() {
        ServiceLoader<UserCookiePluginable> loader = ServiceLoader.load(UserCookiePluginable.class);
        Iterator<UserCookiePluginable> it = loader.iterator();
        while (it.hasNext()) {
            this.userCookiePlugins.add(it.next());
        }
    }

    private FilterPluginable.ResultType doBeforeProcessing(String servletpath, HttpServletRequest httprequest, ServletResponse response) throws IOException, ServletException {
        FilterPluginable plugin;
        if (!(servletpath.endsWith(".jsf") || servletpath.endsWith(".jsp") || this.filterpathsMap.containsKey(servletpath))) {
            return FilterPluginable.ResultType.GOON;
        }
        if (servletpath.indexOf("/servlet/DisplayChart") >= 0) {
            return FilterPluginable.ResultType.GOON;
        }
        if (servletpath.endsWith("/plaf/exception.jsp")) {
            return FilterPluginable.ResultType.GOON;
        }
        if (servletpath.indexOf("ajax4jsf") >= 0) {
            return FilterPluginable.ResultType.GOON;
        }
        for (String s : this.excludepages) {
            if (servletpath.indexOf(s) < 0) continue;
            return FilterPluginable.ResultType.GOON;
        }
        for (String s : this.excludecatalogs) {
            if (s.isEmpty() || !servletpath.startsWith(s)) continue;
            return FilterPluginable.ResultType.GOON;
        }
        FilterPluginable.ResultType result = FilterPluginable.ResultType.GOON;
        Iterator<FilterPluginable> i$ = this.filterplugins.iterator();
        while (i$.hasNext() && (result = (plugin = i$.next()).doBeforeProcessing(this.webroot, httprequest, (HttpServletResponse)response)) == FilterPluginable.ResultType.GOON) {
        }
        if (result != FilterPluginable.ResultType.GOON) {
            return result;
        }
        HttpSession session = httprequest.getSession(true);
        UserInfo userInfo = (UserInfo)session.getAttribute("userinfo");
        if (userInfo == null) {
            if (ApplicationConfigUtil.isCookies()) {
                if (this.filterWithCookie(httprequest, (HttpServletResponse)response) == FilterPluginable.ResultType.ABORT) {
                    return FilterPluginable.ResultType.ABORT;
                }
            } else if (servletpath.indexOf("index.jsf") < 0 && servletpath.indexOf("index.jsp") < 0) {
                HttpServletResponse resp = (HttpServletResponse)response;
                resp.getWriter().write("<script type='text/javascript'>top.location='" + httprequest.getContextPath() + "/plaf/invaliduserinfo.html'</script>");
                return FilterPluginable.ResultType.ABORT;
            }
        } else {
            LoginUserContainer luc = (LoginUserContainer)session.getServletContext().getAttribute("LoginUserContainer");
            if (!luc.isOnline(userInfo.getUserlogno(), session.getId(), userInfo.isSinglelogin(), httprequest.getRemoteAddr())) {
                session.invalidate();
                if (servletpath.indexOf("index.jsf") < 0 && servletpath.indexOf("index.jsp") < 0) {
                    HttpServletResponse resp = (HttpServletResponse)response;
                    resp.getWriter().write("<script type='text/javascript'>top.location='" + httprequest.getContextPath() + "/plaf/invaliduserinfo.html'</script>");
                    return FilterPluginable.ResultType.ABORT;
                }
            }
        }
        return FilterPluginable.ResultType.GOON;
    }

    private FilterPluginable.ResultType filterWithCookie(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String servletpath;
        LoginUserContainer luc;
        HttpSession session = request.getSession(true);
        request.setCharacterEncoding("utf-8");
        boolean isPluginSession = false;
        boolean isCommonSession = false;
        UserCookie userCookie = new UserCookie(request, response, null, null);
        UserInfo userinfo = (UserInfo)userCookie.getCByobject(UserInfo.class);
        if (userinfo != null && !userinfo.getUserlogno().isEmpty() && !(luc = (LoginUserContainer)session.getServletContext().getAttribute("LoginUserContainer")).isOtherLogin(userinfo.getUserlogno(), session.getId())) {
            UserInfo newUserInfo = LoginTool.login(request, userinfo.getUserlogno());
            if (newUserInfo != null) {
                if (newUserInfo.same(userinfo)) {
                    session.setAttribute("loginclientip", request.getRemoteAddr());
                    session.setAttribute("userinfo", userinfo);
                    isCommonSession = true;
                } else {
                    logger.info("\u7528\u6237(" + userinfo.getUserlogno() + ")\u5ba2\u6237\u7aef\u4fdd\u5b58\u6709cookie\u4fe1\u606f\u4f46\u662f\u670d\u52a1\u7aef\u7684\u6b64\u7528\u6237\u4fe1\u606f\u5df2\u7ecf\u6539\u53d8\uff0c\u6240\u4ee5cookie\u9a8c\u8bc1\u672a\u901a\u8fc7\uff0c\u9700\u91cd\u65b0\u767b\u5f55");
                }
            } else {
                logger.info("\u7528\u6237(" + userinfo.getUserlogno() + ")\u5ba2\u6237\u7aef\u4fdd\u5b58\u6709cookie\u4fe1\u606f\u4f46\u662f\u670d\u52a1\u7aef\u5df2\u7ecf\u5220\u9664\u4e86\u6b64\u7528\u6237\uff0c\u6240\u4ee5cookie\u9a8c\u8bc1\u672a\u901a\u8fc7");
            }
        }
        if (this.userCookiePlugins.size() > 0) {
            for (UserCookiePluginable plugin : this.userCookiePlugins) {
                plugin.setRequest(request);
                plugin.setResponse(response);
                isPluginSession = plugin.filterCookie();
                if (isPluginSession) continue;
                break;
            }
        } else {
            isPluginSession = true;
        }
        if (!(isPluginSession && isCommonSession || (servletpath = request.getServletPath().toLowerCase()).indexOf("index.jsf") >= 0 || servletpath.indexOf("index.jsp") >= 0)) {
            HttpServletResponse resp = response;
            resp.getWriter().write("<script type='text/javascript'>top.location='" + request.getContextPath() + "/plaf/invaliduserinfo.html'</script>");
            return FilterPluginable.ResultType.ABORT;
        }
        return FilterPluginable.ResultType.GOON;
    }

    private void doAfterProcessing(ServletRequest request, ServletResponse response) throws IOException, ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httprequest = (HttpServletRequest)request;
        String servletpath = httprequest.getServletPath().toLowerCase();
        try {
            if (this.doBeforeProcessing(servletpath, httprequest, response) == FilterPluginable.ResultType.ABORT) {
                return;
            }
        }
        catch (Throwable t) {
            this.sendProcessingMessage(t, response);
            return;
        }
        try {
            chain.doFilter(request, response);
        }
        catch (Throwable t) {
            ThrowableHanderPluginable plugin;
            t.printStackTrace();
            log.error("unkown error : ", t);
            boolean result = true;
            Iterator<ThrowableHanderPluginable> i$ = this.throwableplugins.iterator();
            while (i$.hasNext() && (result = (plugin = i$.next()).sendProcessingException(this.webroot, t, httprequest, (HttpServletResponse)response))) {
            }
            if (result) {
                this.sendProcessingMessageFromFile(t, response, this.webroot, httprequest.getContextPath());
            }
            return;
        }
    }

    private void sendProcessingMessageFromFile(Throwable t, ServletResponse response, String webroot, String contextpath) {
        try {
            if (this.exceptionTemplate == null) {
                this.exceptionTemplate = WebCommonFilter.readSmallFile(new File(webroot + "/plaf/exception.html"));
                this.exceptionTemplate = this.exceptionTemplate.replaceAll("\\$\\{appContextPath\\}", contextpath);
            }
            String content = this.exceptionTemplate;
            int index1 = content.indexOf("${message}");
            String header = content.substring(0, index1);
            int index2 = content.indexOf("${stackTrace}");
            String middle = content.substring(index1 + "${message}".length(), index2);
            String footer = content.substring(index2 + "${stackTrace}".length());
            content = header + WebCommonFilter.getMessage(t) + middle + WebCommonFilter.getStackTrace(t) + footer;
            response.setContentType("text/html");
            response.setCharacterEncoding("GBK");
            PrintStream ps = new PrintStream(response.getOutputStream());
            PrintWriter pw = new PrintWriter(ps);
            pw.print(content);
            pw.close();
            ps.close();
            response.getOutputStream().close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void sendProcessingMessage(Throwable t, ServletResponse response) {
        try {
            response.setContentType("text/html");
            response.setCharacterEncoding("GBK");
            PrintStream ps = new PrintStream(response.getOutputStream());
            PrintWriter pw = new PrintWriter(ps);
            pw.print(t.getMessage());
            pw.close();
            ps.close();
            response.getOutputStream().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void sendProcessingException(Throwable t, ServletResponse response, File file) {
        try {
            String content = WebCommonFilter.readSmallFile(file);
            int index1 = content.indexOf("${message}");
            String header = content.substring(0, index1);
            int index2 = content.indexOf("${stackTrace}");
            String middle = content.substring(index1 + "${message}".length(), index2);
            String footer = content.substring(index2 + "${stackTrace}".length());
            content = header + WebCommonFilter.getMessage(t) + middle + WebCommonFilter.getStackTrace(t) + footer;
            response.setContentType("text/html");
            response.setCharacterEncoding("GBK");
            PrintStream ps = new PrintStream(response.getOutputStream());
            PrintWriter pw = new PrintWriter(ps);
            pw.print(content);
            pw.close();
            ps.close();
            response.getOutputStream().close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) {
        if (filterConfig != null) {
            this.webroot = filterConfig.getServletContext().getRealPath("").replace('\\', '/');
            this.configlog(null);
            log = Logger.getLogger(WebCommonFilter.class);
            this.excludepages = ApplicationConfigUtil.getExcludePages();
            this.excludecatalogs = ApplicationConfigUtil.getExcludeCatalogs();
            String[] fp = ApplicationConfigUtil.getFilterpaths();
            if (fp != null) {
                for (String s : fp) {
                    this.filterpathsMap.put(s, null);
                }
            }
        }
        this.initFilterPluginable();
        this.initThrowableHanderPluginable();
        this.initUserCookiePluginable();
    }

    private void configlog(String contextpath) {
        if (Logger.getRootLogger().getAllAppenders().hasMoreElements()) {
            return;
        }
        new File(ApplicationConfigUtil.WEBROOT + "logs").mkdirs();
        Properties prop = new Properties();
        if (contextpath == null || contextpath.length() == 0) {
            contextpath = "/rootlog";
        } else if (contextpath.endsWith("/") || contextpath.endsWith("//")) {
            contextpath = contextpath.substring(0, contextpath.length() - 1);
        }
        System.out.println("load default log4j config.");
        prop.put("log4j.rootLogger", "WARN,xlweb");
        prop.put("log4j.appender.xlweb", "org.apache.log4j.RollingFileAppender");
        prop.put("log4j.appender.xlweb.File", ApplicationConfigUtil.WEBROOT + "logs/" + contextpath + ".log");
        prop.put("log4j.appender.xlweb.Append", "true");
        prop.put("log4j.appender.xlweb.MaxFileSize", "8MB");
        prop.put("log4j.appender.xlweb.MaxBackupIndex", "3");
        prop.put("log4j.appender.xlweb.layout", "org.apache.log4j.PatternLayout");
        prop.put("log4j.appender.xlweb.layout.ConversionPattern", "%d{[yyyy-MM-dd HH:mm:ss.SSS]}:[%p]  %l %m%n");
        PropertyConfigurator.configure(prop);
    }

    private static String getMessage(Throwable t) {
        ServletException se;
        if (t instanceof ServletException && (se = (ServletException)t).getRootCause() instanceof FacesException) {
            FacesException fe = (FacesException)se.getRootCause();
            if (fe.getCause() != null) {
                return StringTools.escapeHtml(fe.getCause().getCause() == null ? fe.getCause().getMessage() : fe.getCause().getCause().getMessage());
            }
            return StringTools.escapeHtml(fe.getMessage());
        }
        Throwable buf = t;
        while (buf.getCause() != null) {
            buf = buf.getCause();
        }
        return StringTools.escapeHtml(buf.getMessage());
    }

    private static String getStackTrace(Throwable t) {
        String stackTrace = "";
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            pw.close();
            sw.close();
            stackTrace = StringEscapeUtils.escapeHtml(sw.getBuffer().toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stackTrace;
    }

    private static String readSmallFile(File file) throws IOException {
        if (!file.isFile()) {
            return "not found file (\"" + file.getName() + "\").";
        }
        StringBuilder sb = new StringBuilder((int)file.length() + 300);
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "GBK"));
        String str = null;
        while ((str = br.readLine()) != null) {
            sb.append(str + "\n");
        }
        br.close();
        return sb.toString();
    }
}

