/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.web.model;

import com.xunlei.common.plugin.UserToRolePluginable;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.common.vo.Roles;
import com.xunlei.common.vo.Users;
import com.xunlei.common.web.model.AbstractManagedBean;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import javax.faces.model.SelectItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FunRef(value="Users")
public class UsersManagedBean
extends AbstractManagedBean {
    private String in2out_seqids;
    private String out2in_seqids;

    public String getIn2out_seqids() {
        return this.in2out_seqids;
    }

    public void setIn2out_seqids(String in2out) {
        this.in2out_seqids = in2out;
    }

    public String getOut2in_seqids() {
        return this.out2in_seqids;
    }

    public void setOut2in_seqids(String out2in) {
        this.out2in_seqids = out2in;
    }

    public List<Roles> getInRoles() {
        String curr_username = this.findParameter("curr_username");
        Users u = new Users();
        u.setUserlogno(curr_username);
        return commfacade.getAllRolesInUsers(u);
    }

    public List<Roles> getOutRoles() {
        String curr_username = this.findParameter("curr_username");
        Users u = new Users();
        u.setUserlogno(curr_username);
        return commfacade.getAllRolesNotInUsers(u);
    }

    public String forin2out() {
        this.authenticateEdit();
        String[] strseqids = this.getIn2out_seqids().split("\\|");
        long[] seqids = new long[strseqids.length];
        for (int i = 0; i < strseqids.length; ++i) {
            seqids[i] = Long.valueOf(strseqids[i]);
        }
        String userlogno = this.findParameter("curr_username");
        Users user = commfacade.getUsersByUserLogNo(userlogno);
        try {
            ServiceLoader<UserToRolePluginable> loader = ServiceLoader.load(UserToRolePluginable.class);
            Iterator<UserToRolePluginable> it = loader.iterator();
            while (it.hasNext()) {
                it.next().out(user, seqids);
            }
        }
        catch (Exception ex) {
            this.alertJS(ex.getMessage());
            return "";
        }
        commfacade.removeRolesfromUserToRoles(user, seqids);
        return "";
    }

    public String forout2in() {
        this.authenticateEdit();
        String[] strseqids = this.getOut2in_seqids().split("\\|");
        long[] seqids = new long[strseqids.length];
        for (int i = 0; i < strseqids.length; ++i) {
            seqids[i] = Long.valueOf(strseqids[i]);
        }
        String userlogno = this.findParameter("curr_username");
        Users user = commfacade.getUsersByUserLogNo(userlogno);
        try {
            ServiceLoader<UserToRolePluginable> loader = ServiceLoader.load(UserToRolePluginable.class);
            Iterator<UserToRolePluginable> it = loader.iterator();
            while (it.hasNext()) {
                it.next().in(user, seqids);
            }
        }
        catch (Exception ex) {
            this.alertJS(ex.getMessage());
            return "";
        }
        commfacade.addRolestoUserToRoles(user, seqids);
        return "";
    }

    public String getQueryUserlist() {
        this.authenticateRun();
        PagedFliper fliper = this.getFliper();
        fliper.setSortColumnIfEmpty("userlogno asc");
        this.mergePagedDataModel(commfacade.queryAllUsers(this.findBean(Users.class, 2), fliper), fliper);
        return "";
    }

    public String delete() {
        this.authenticateDel();
        commfacade.removeUsers(this.findParamSeqid());
        return "";
    }

    public String deleteSome() {
        this.authenticateDel();
        try {
            for (long seqid : this.findParamSeqids()) {
                commfacade.removeUsers(seqid);
            }
        }
        catch (XLRuntimeException ex) {
            this.alertJS(ex.getMessage());
        }
        this.getQueryUserlist();
        return "";
    }

    public String add() {
        this.authenticateAdd();
        Users data = this.findBean(Users.class);
        if (this.isEmpty(data.getCopartnerno())) {
            data.setCopartnerno("");
        }
        data.setEditby(this.currentUserLogo());
        data.setEdittime(this.now());
        try {
            commfacade.insertUsers(data);
        }
        catch (XLRuntimeException e) {
            this.mergeBean((Object)e.getMessage(), "jsmessage");
        }
        this.getQueryUserlist();
        return "";
    }

    public String edit() {
        this.authenticateEdit();
        Users data = this.findBean(Users.class);
        data.setEditby(this.currentUserLogo());
        try {
            commfacade.editUsers(data);
        }
        catch (XLRuntimeException e) {
            this.mergeBean((Object)e.getMessage(), "jsmessage");
        }
        this.getQueryUserlist();
        return "";
    }

    public String getFindme() {
        this.authenticate("ModifyUser", "run");
        this.mergeBean(commfacade.getUsersByUserLogNo(this.currentUserLogo()));
        return "";
    }

    public String resetpassword() {
        this.authenticate("ModifyPassword", "edit");
        String newpwd = this.findParameter("input_resetpassword");
        if (this.isNotEmpty(newpwd)) {
            long seqid = Long.parseLong(this.findParameter("reset_param_seqid"));
            commfacade.resetPassword(seqid, newpwd);
            this.alertJS("\u91cd\u7f6e\u5bc6\u7801\u6210\u529f.");
        }
        this.getQueryUserlist();
        return "";
    }

    public String modify() {
        this.authenticate("ModifyUser", "edit");
        String oldpwd = this.findParameter("oldpassword");
        String newpwd = this.findParameter("newpassword");
        Users newuser = this.findBean(Users.class);
        try {
            commfacade.updatePassword(this.currentUserLogo(), oldpwd, newpwd, newuser.getTel(), newuser.getQq(), newuser.getEmail());
        }
        catch (Exception ex) {
            this.alertJS(ex.getMessage());
        }
        this.mergeBean(commfacade.getUsersByUserLogNo(this.currentUserLogo()));
        this.alertJS("\u4fee\u6539\u8d44\u6599\u6210\u529f.");
        return "";
    }

    public SelectItem[] getCopartnerlist() {
        Map<String, String> map = commfacade.getCopartnerNoAndName();
        SelectItem[] items = new SelectItem[map.size() + 1];
        items[0] = new SelectItem((Object)"", "");
        int index = 0;
        for (Map.Entry<String, String> enty : map.entrySet()) {
            items[++index] = new SelectItem((Object)enty.getKey(), enty.getValue());
        }
        return items;
    }

    public SelectItem[] getUpuserlognolist() {
        Map<String, String> map = commfacade.getUpuserlognolist();
        SelectItem[] items = new SelectItem[map.size() + 1];
        items[0] = new SelectItem((Object)"", "");
        int index = 0;
        for (Map.Entry<String, String> enty : map.entrySet()) {
            items[++index] = new SelectItem((Object)enty.getKey(), enty.getValue());
        }
        return items;
    }
}

