/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.web.model;

import com.mysql.jdbc.CommunicationsException;
import com.xunlei.common.plugin.LoginPluginable;
import com.xunlei.common.util.ApplicationConfigUtil;
import com.xunlei.common.util.Constants;
import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.StringTools;
import com.xunlei.common.util.UserCookie;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.common.vo.UserInfo;
import com.xunlei.common.vo.UserToRole;
import com.xunlei.common.vo.Users;
import com.xunlei.common.web.model.AbstractManagedBean;
import com.xunlei.common.web.model.LoginTool;
import com.xunlei.common.web.model.LoginUserContainer;
import com.xunlei.common.web.model.MenuManagedBean;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ServiceLoader;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class LoginManagedBean
extends AbstractManagedBean {
    private static Logger logger = Logger.getLogger(LoginManagedBean.class);

    public String login() {
        String userlogo = this.findParameter("userlogo");
        String password = this.findParameter("password");
        String cookiev = this.findParameter("cookie");
        this.mergeBean((Object)userlogo, "userlogo");
        Users user = null;
        try {
            user = commfacade.getUsersByUserLogNo(userlogo);
        }
        catch (XLRuntimeException ex) {
            this.mergeErrorMessage("-1|" + ex.getMessage());
            logger.error(ex);
            return "";
        }
        catch (Exception ex) {
            if (ex.getClass() == CommunicationsException.class) {
                this.mergeErrorMessage("-1|\u7cfb\u7edf\u4e0e\u6570\u636e\u5e93\u901a\u4fe1\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002");
            } else {
                this.mergeErrorMessage("-1|\u67e5\u8be2\u6570\u636e\u5e93\u65f6\u53d1\u751f\u9519\u8bef\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002");
                logger.error(ex);
            }
            return "";
        }
        if (user == null) {
            this.mergeErrorMessage("-1|\u5e10\u53f7(" + userlogo + ") \u4e0d\u5b58\u5728.");
            return "";
        }
        if (!user.getUserlogintype().equals("A")) {
            this.mergeErrorMessage("-1|\u6b64\u5e10\u53f7\u4e0d\u5141\u8bb8\u767b\u5f55\u540e\u53f0.");
            return "";
        }
        if (StringTools.isNotEmpty(user.getBindip())) {
            String[] strs = user.getBindip().split(",");
            String ip = this.getClientAddr();
            boolean illed = true;
            for (String s : strs) {
                if (!ip.equals(s.trim())) continue;
                illed = false;
                break;
            }
            if (illed) {
                this.mergeErrorMessage("-1|\u975e\u6cd5\u5ba2\u6237\u7aef\u767b\u5f55.");
                return "";
            }
        }
        if (!user.getDecodePassword().equals(password)) {
            this.mergeErrorMessage("-2|\u5bc6\u7801\u9519\u8bef.");
            return "";
        }
        if (user.getInuse() != 1) {
            this.mergeErrorMessage("-1|\u5e10\u53f7(" + userlogo + ")\u672a\u751f\u6548.");
            return "";
        }
        logger.debug(StringTools.isNotEmpty(user.getStartvaliddate()) && user.getStartvaliddate().compareTo(DatetimeUtil.today()) > 0);
        if (StringTools.isNotEmpty(user.getStartvaliddate()) && user.getStartvaliddate().compareTo(DatetimeUtil.today()) > 0) {
            this.mergeErrorMessage("-1|\u5e10\u53f7(" + userlogo + ")\u672a\u751f\u6548.");
            return "";
        }
        logger.debug(StringTools.isNotEmpty(user.getEndvaliddate()) && user.getEndvaliddate().compareTo(DatetimeUtil.today()) < 0);
        if (StringTools.isNotEmpty(user.getEndvaliddate()) && user.getEndvaliddate().compareTo(DatetimeUtil.today()) < 0) {
            this.mergeErrorMessage("-1|\u5e10\u53f7(" + userlogo + ")\u5df2\u5931\u6548.");
            return "";
        }
        ArrayList<String> sysroles = new ArrayList<String>(3);
        ArrayList<String> recroles = new ArrayList<String>(3);
        for (UserToRole utr : user.getRoles()) {
            if ("SYS".equals(utr.getRoletype())) {
                sysroles.add(utr.getRoleno());
                continue;
            }
            if (!"REC".equals(utr.getRoletype())) continue;
            recroles.add(utr.getRoleno());
        }
        UserInfo userinfo = new UserInfo(userlogo, user.getTruename(), sysroles.toArray(new String[sysroles.size()]), recroles.toArray(new String[recroles.size()]), user.getSuperman() > 0, commfacade.getIfMyDataOnly(userlogo), user.getWorkingplatform(), user.isBoolsinglelogin());
        String[] usermailclassid = commfacade.queryMailclassidbyusername(userlogo);
        userinfo.setMailclassids(usermailclassid);
        this.mergeBean((Object)userinfo, "userinfo");
        HttpSession session = this.getHttpServletRequest().getSession(true);
        session.setAttribute("loginclientip", this.getHttpServletRequest().getRemoteAddr());
        session.setAttribute("userinfo", userinfo);
        commfacade.deleteFunctionLogsdaily();
        if (ApplicationConfigUtil.isCookies()) {
            String contextPath;
            int maxage = -1;
            if (this.isNotEmpty(cookiev) && (maxage = Integer.valueOf(cookiev).intValue()) < Constants.COOKIE_TIME.length) {
                maxage = Constants.COOKIE_TIME[maxage];
            }
            if (StringTools.isEmpty(contextPath = this.getContextPath())) {
                contextPath = "/";
            }
            UserCookie userCookie = new UserCookie(this.getHttpServletRequest(), this.getHttpServletResponse(), contextPath, null);
            userCookie.addCByObject(userinfo, maxage);
        }
        String result = null;
        try {
            ServiceLoader<LoginPluginable> loader = ServiceLoader.load(LoginPluginable.class);
            Iterator<LoginPluginable> it = loader.iterator();
            while (it.hasNext()) {
                result = it.next().run();
            }
        }
        catch (Exception ex) {
            this.mergeErrorMessage(ex.getMessage());
            return "";
        }
        if (result != null) {
            return result;
        }
        this.getHttpServletRequest().getSession(true).setAttribute("gleam_logined", "logined");
        MenuManagedBean menumb = new MenuManagedBean();
        menumb.constantMenus();
        this.mergeBean((Object)"1|success", "jsmessage");
        return "";
    }

    public String getOtherLoginStatus() {
        String userlogo = this.findParameter("userlogo");
        String password = this.findParameter("password");
        Users user = commfacade.getUsersByUserLogNo(userlogo);
        if (user == null || !user.getDecodePassword().equals(password) || !this.isOtherLogin(userlogo)) {
            this.mergeBean((Object)"var t={otherLogin:false}", "jsmessage");
        } else {
            String ip = this.getLoginIp(userlogo);
            this.mergeBean((Object)("var t={otherLogin:true,ip:'" + ip + "',username:'" + userlogo + "'}"), "jsmessage");
        }
        return "";
    }

    private boolean isOtherLogin(String userlogo) {
        LoginUserContainer luc = (LoginUserContainer)this.getContext().getAttribute("LoginUserContainer");
        return luc.isOtherLogin(userlogo, this.getHttpServletRequest().getSession(true).getId());
    }

    private String getLoginIp(String userlogo) {
        LoginUserContainer luc = (LoginUserContainer)this.getContext().getAttribute("LoginUserContainer");
        return luc.getLoginIp(userlogo, "");
    }

    public String canLoginFromCookie() {
        UserCookie userCookie = new UserCookie(this.getHttpServletRequest(), this.getHttpServletResponse(), null, null);
        UserInfo userinfo = (UserInfo)userCookie.getCByobject(UserInfo.class);
        if (userinfo != null && this.isOtherLogin(userinfo.getUserlogno())) {
            String ip = this.getLoginIp(userinfo.getUserlogno());
            this.mergeBean((Object)("var t={cookieLogin:true,ip:'" + ip + "',username:'" + userinfo.getUserlogno() + "'}"), "jsmessage");
        } else {
            this.mergeBean((Object)"var t={cookieLogin:false}", "jsmessage");
        }
        return "";
    }

    public String loginByCookie() {
        UserInfo newUserInfo;
        UserCookie userCookie = new UserCookie(this.getHttpServletRequest(), this.getHttpServletResponse(), null, null);
        UserInfo userinfo = (UserInfo)userCookie.getCByobject(UserInfo.class);
        if (userinfo != null && (newUserInfo = LoginTool.login(this.getHttpServletRequest(), userinfo.getUserlogno())).same(userinfo)) {
            this.getHttpServletRequest().getSession(true).setAttribute("userinfo", userinfo);
            this.mergeBean((Object)"1|success", "jsmessage");
            return "";
        }
        this.mergeBean((Object)"-1|\u4f7f\u7528Cookie\u4fe1\u606f\u8fdb\u884c\u767b\u5f55\u5931\u8d25", "jsmessage");
        return "";
    }

    private void mergeErrorMessage(String msg) {
        String jsmessage = StringTools.encodeURL(msg);
        this.getHttpServletRequest().getSession(true).setAttribute("login_error_msg", jsmessage);
        this.mergeBean((Object)jsmessage, "jsmessage");
    }
}

