/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.web.model;

import com.xunlei.common.util.StringTools;

class FileNameNode {
    private String filename;
    private String savename;
    private int width;
    private int height;
    private boolean uploadSuccess;
    private boolean alreadyGet;
    private String ext;

    public FileNameNode(String filename, String savename, int width, int height) {
        this.filename = filename.toLowerCase();
        this.savename = savename;
        this.width = width;
        this.height = height;
        this.uploadSuccess = false;
        this.alreadyGet = false;
    }

    public FileNameNode(String filename, String savename) {
        this.filename = filename.toLowerCase();
        this.savename = savename;
        this.uploadSuccess = false;
        this.alreadyGet = false;
    }

    public static FileNameNode parseToFileNameNode(String str) {
        String[] vs = str.split("\\|");
        FileNameNode fn = new FileNameNode(vs[0], vs[1]);
        if (vs.length == 4) {
            fn.width = StringTools.safeToInt(vs[2]);
            fn.height = StringTools.safeToInt(vs[3]);
        }
        return fn;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getSavename() {
        return this.savename;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isUploadSuccess() {
        return this.uploadSuccess;
    }

    public void setUploadSuccess(boolean uploadSuccess) {
        this.uploadSuccess = uploadSuccess;
    }

    public boolean isAlreadyGet() {
        return this.alreadyGet;
    }

    public void setAlreadyGet(boolean alreadyGet) {
        this.alreadyGet = alreadyGet;
    }

    public String getExt() {
        return this.ext;
    }

    public void setExt(String ext) {
        this.ext = ext;
    }

    public String getFileFullName() {
        return this.savename + "." + this.getExt();
    }
}

