/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.web.bean;

import com.xunlei.common.plugin.PagedDataModelPluginable;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.common.vo.LibConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.ServiceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PagedDataModel
implements Serializable {
    private static final long serialVersionUID = 210476721351113518L;
    private final int index;
    private final Sheet<?> sheet;
    private final PagedFliper fliper;
    private static final PagedDataModelPluginable plugin;
    private static final int[] initPagesizeArray;
    private static int[] pagesizeArray;

    public PagedDataModel() {
        this.sheet = Sheet.EMPTY;
        this.fliper = null;
        this.index = 0;
    }

    public PagedDataModel(Sheet<?> sheet, PagedFliper fliper, int index) {
        this.sheet = sheet;
        this.fliper = fliper;
        this.index = index;
    }

    public Collection<?> getDatas() {
        return this.getSheet().getDatas();
    }

    @Deprecated
    public String getHiddenhtml() {
        return this.getFliper().getFormathtml();
    }

    public String getFooterhtml() {
        int i;
        if (this.getSheet() == null || this.getFliper() == null) {
            return "";
        }
        int rowcount = this.getSheet().getRowcount();
        this.getFliper().setRecordCount(rowcount);
        int pageSize = this.getFliper().getPageSize();
        int pageNo = this.getFliper().getPageNo();
        int pagecount = (rowcount + pageSize - 1) / pageSize;
        StringBuilder sb = new StringBuilder(300);
        sb.append("<span class='pagerDisp'>");
        if (pagecount > 0) {
            sb.append("<script type='text/javascript'>function setPageSize(pageno,pagesize,index){var pagesizehdid='__hidden_pagesize_';if(index>1){pagesizehdid+=index;}var o=document.getElementById(pagesizehdid);o.value=pagesize;skipto(1,index);}</script>");
            sb.append("&nbsp;&nbsp;\u6bcf\u9875\u663e\u793a\uff1a");
            for (i = 0; i < pagesizeArray.length; ++i) {
                int a = pagesizeArray[i];
                if (pageSize == a) {
                    sb.append(a);
                } else {
                    sb.append("<a href='javascript:void(0)' onclick=\"setPageSize(").append(pageNo).append(",").append(a).append(",").append(this.getIndex()).append(")\">").append(a).append("</a>");
                }
                if (pagesizeArray.length - 1 <= i) continue;
                sb.append("\uff0c");
            }
        }
        sb.append("</span>");
        sb.append("<span class='pagerNum'>");
        sb.append(PagedDataModel.escapeHtml("\u5171")).append(pagecount).append(PagedDataModel.escapeHtml("\u9875")).append("&nbsp;[");
        sb.append(this.fliper.getCurrentPageRecordStartIndex()).append("..").append(this.fliper.getCurrentPageRecordEndIndex()).append("/").append(rowcount);
        sb.append("]&nbsp;&nbsp;[");
        if (pageNo > 1) {
            sb.append("<a class='listtree' href=\"javascript:skipto('").append(pageNo - 1).append("'," + this.getIndex() + ");\">");
        }
        sb.append(PagedDataModel.escapeHtml("\u4e0a\u4e00\u9875")).append(pageNo > 1 ? "</a>" : "").append("]").append(PagedDataModel.escapeHtml("\u7b2c"));
        if (pagecount <= 50) {
            sb.append("<select onChange = \"skipto(this.value," + this.getIndex() + ");\">");
            for (i = 1; i <= pagecount; ++i) {
                sb.append("<option value=\"").append(i).append("\" ").append(pageNo == i ? "selected" : "").append(">").append(i).append("</option>");
            }
            sb.append("</select>");
        } else {
            sb.append("&nbsp;<input title='" + PagedDataModel.escapeHtml("\u56de\u8f66\u8df3\u5230\u6307\u5b9a\u9875") + "' value='" + pageNo + "' onkeypress='pressskippage(this, event, " + pagecount + ", " + this.getIndex() + ");' style='text-align: center;height: 20px;font-size: 11px;' size='3'>&nbsp;");
        }
        sb.append(PagedDataModel.escapeHtml("\u9875")).append("&nbsp;[");
        if (pageNo < pagecount) {
            sb.append("<a class='listtree' href=\"javascript:skipto('").append(pageNo + 1).append("'," + this.getIndex() + ");\">");
        }
        sb.append(PagedDataModel.escapeHtml("\u4e0b\u4e00\u9875")).append(pageNo < pagecount ? "</a>" : "").append("]&nbsp;&nbsp;</span>");
        return sb.toString();
    }

    public String getFooterhtml2() {
        if (plugin == null) {
            return this.getFooterhtml();
        }
        String html = plugin.getFooterhtml2(this);
        return html == null ? this.getFooterhtml() : html;
    }

    public String getFooterhtml3() {
        if (plugin == null) {
            return this.getFooterhtml();
        }
        String html = plugin.getFooterhtml3(this);
        return html == null ? this.getFooterhtml() : html;
    }

    public String getFooterhtml4() {
        if (plugin == null) {
            return this.getFooterhtml();
        }
        String html = plugin.getFooterhtml4(this);
        return html == null ? this.getFooterhtml() : html;
    }

    public String getFooterhtml5() {
        if (plugin == null) {
            return this.getFooterhtml();
        }
        String html = plugin.getFooterhtml5(this);
        return html == null ? this.getFooterhtml() : html;
    }

    public String getFooterhtml6() {
        if (plugin == null) {
            return this.getFooterhtml();
        }
        String html = plugin.getFooterhtml6(this);
        return html == null ? this.getFooterhtml() : html;
    }

    public String getFooterhtml7() {
        if (plugin == null) {
            return this.getFooterhtml();
        }
        String html = plugin.getFooterhtml7(this);
        return html == null ? this.getFooterhtml() : html;
    }

    public String getFooterhtml8() {
        if (plugin == null) {
            return this.getFooterhtml();
        }
        String html = plugin.getFooterhtml8(this);
        return html == null ? this.getFooterhtml() : html;
    }

    public String getFooterhtml9() {
        if (plugin == null) {
            return this.getFooterhtml();
        }
        String html = plugin.getFooterhtml9(this);
        return html == null ? this.getFooterhtml() : html;
    }

    public String getFooterhtml10() {
        if (plugin == null) {
            return this.getFooterhtml();
        }
        String html = plugin.getFooterhtml10(this);
        return html == null ? this.getFooterhtml() : html;
    }

    private static String escapeHtml(String str) {
        return StringTools.escapeHtml(str);
    }

    public int getIndex() {
        return this.index;
    }

    public Sheet<?> getSheet() {
        return this.sheet;
    }

    public PagedFliper getFliper() {
        return this.fliper;
    }

    public static void initPageSizeArray() {
        int defalutPageSize = Integer.parseInt(LibConfig.getValue("PageSize"));
        ArrayList<Integer> pages = new ArrayList<Integer>();
        boolean hasAdd = false;
        for (int i : initPagesizeArray) {
            if (i == defalutPageSize) {
                hasAdd = true;
            }
            pages.add(i);
        }
        if (!hasAdd) {
            pages.add(defalutPageSize);
            Collections.sort(pages);
        }
        pagesizeArray = new int[pages.size()];
        for (int i = 0; i < pages.size(); ++i) {
            PagedDataModel.pagesizeArray[i] = (Integer)pages.get(i);
        }
    }

    static {
        initPagesizeArray = new int[]{20, 50, 100};
        pagesizeArray = null;
        PagedDataModelPluginable one = null;
        try {
            ServiceLoader<PagedDataModelPluginable> loader = ServiceLoader.load(PagedDataModelPluginable.class);
            Iterator<PagedDataModelPluginable> it = loader.iterator();
            if (it.hasNext()) {
                one = it.next();
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        PagedDataModel.initPageSizeArray();
        plugin = one;
    }
}

