/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.vo;

import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.common.util.Extendable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibConfig
implements Serializable {
    @Extendable
    private static Logger logger = Logger.getLogger(LibConfig.class);
    @Extendable
    private static Map<String, LibConfig> libconfigMap = null;
    private long seqid = 0L;
    private String configno;
    private String configname;
    private String configvalue;
    private String remark;
    private String editby;
    private String edittime;

    public static void loadLibconfig() {
        libconfigMap = new HashMap<String, LibConfig>();
        List libs = (List)IFacadeCommon.INSTANCE.queryLibconfigs(new LibConfig(), null).getDatas();
        for (LibConfig lib : libs) {
            libconfigMap.put(lib.getConfigno(), lib);
        }
        logger.debug("\u8f7d\u5165 libconfigMap \u5b8c\u6210");
    }

    public static void clearLibconfig() {
        libconfigMap = null;
        logger.debug("\u7f6e\u7a7a libconfigMap \u5b8c\u6210");
    }

    public static LibConfig getLibConfig(String configno) {
        if (libconfigMap == null) {
            LibConfig.loadLibconfig();
        }
        return libconfigMap.get(configno);
    }

    public static List<LibConfig> getLibConfigList() {
        if (libconfigMap == null) {
            LibConfig.loadLibconfig();
        }
        ArrayList<LibConfig> list = new ArrayList<LibConfig>();
        for (Map.Entry<String, LibConfig> entry : libconfigMap.entrySet()) {
            list.add(entry.getValue());
        }
        return list;
    }

    public static String getValue(String configno) {
        try {
            return LibConfig.getLibConfig(configno).getConfigvalue();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String getValue(String configno, String defaultValue) {
        String v = LibConfig.getValue(configno);
        return v == null ? defaultValue : v;
    }

    public static int getIntValue(String configno) {
        return Integer.parseInt(LibConfig.getValue(configno));
    }

    public static int getIntValue(String configno, int defaultValue) {
        String v = LibConfig.getValue(configno);
        return v == null ? defaultValue : Integer.parseInt(v);
    }

    public static float getFloatValue(String configno) {
        return Float.parseFloat(LibConfig.getValue(configno));
    }

    public static float getFloatValue(String configno, float defaultValue) {
        String v = LibConfig.getValue(configno);
        return v == null ? defaultValue : Float.parseFloat(v);
    }

    public LibConfig() {
    }

    public LibConfig(String configno, String configname, String configvalue, String editby, String edittime) {
        this.configno = configno;
        this.configname = configname;
        this.configvalue = configvalue;
        this.editby = editby;
        this.edittime = edittime;
    }

    public LibConfig(String configno, String configname, String configvalue, String remark, String editby, String edittime) {
        this.configno = configno;
        this.configname = configname;
        this.configvalue = configvalue;
        this.remark = remark;
        this.editby = editby;
        this.edittime = edittime;
    }

    public long getSeqid() {
        return this.seqid;
    }

    public void setSeqid(long seqid) {
        this.seqid = seqid;
    }

    public String getConfigno() {
        return this.configno;
    }

    public void setConfigno(String configno) {
        this.configno = configno;
    }

    public String getConfigname() {
        return this.configname;
    }

    public void setConfigname(String configname) {
        this.configname = configname;
    }

    public String getConfigvalue() {
        return this.configvalue;
    }

    public void setConfigvalue(String configvalue) {
        this.configvalue = configvalue;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getEditby() {
        return this.editby;
    }

    public void setEditby(String editby) {
        this.editby = editby;
    }

    public String getEdittime() {
        return this.edittime;
    }

    public void setEdittime(String edittime) {
        this.edittime = edittime;
    }
}

