/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.util;

import com.xunlei.common.util.Constants;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.common.util.base64.BASE64Decoder;
import com.xunlei.common.util.base64.BASE64Encoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.commons.lang.StringEscapeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringTools {
    private static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final Format numformat = new DecimalFormat("#.##");
    private static final String zeros = "00000000000000000000";
    private static final String[][] sqlhandles = new String[][]{{"'", "`"}, {"#", ""}};

    public static boolean isContainsString(String str, String[] array) {
        if (array == null) {
            return false;
        }
        for (String s : array) {
            if (!s.equals(str)) continue;
            return true;
        }
        return false;
    }

    private StringTools() {
    }

    public static String encrypt(String s) {
        return StringTools.variance(s, 2006, true);
    }

    public static String decrypt(String s) {
        return StringTools.variance(s, 2006, false);
    }

    private static String variance(String s, int key, boolean isEncrypt) {
        int seedA = 3467;
        int seedB = 1239;
        try {
            byte[] src = isEncrypt ? s.getBytes() : new BASE64Decoder().decodeBuffer(s);
            byte[] buf = new byte[src.length];
            for (int i = 0; i < src.length; ++i) {
                byte pr;
                byte ps = src[i];
                buf[i] = pr = (byte)(ps ^ key >>> 8);
                key = isEncrypt ? (pr + key) * 3467 + 1239 : (ps + key) * 3467 + 1239;
            }
            return isEncrypt ? new BASE64Encoder().encode(buf) : new String(buf);
        }
        catch (Exception e) {
            throw new XLRuntimeException(e);
        }
    }

    public static String listingString(Object data) {
        return StringTools.listingString(data, true);
    }

    public static String listingString(Object data, boolean snapped) {
        StringBuilder sb = new StringBuilder(100);
        sb.append(data.getClass().getSimpleName()).append("[");
        try {
            boolean flag = false;
            boolean isstring = true;
            Object obj = null;
            String str = "";
            for (Method m : data.getClass().getDeclaredMethods()) {
                if (!m.getName().startsWith("get") && !m.getName().startsWith("is") || m.getParameterTypes().length != 0) continue;
                int l = m.getName().startsWith("get") ? 3 : 2;
                obj = m.invoke(data, new Object[0]);
                if (snapped && obj == null || !(isstring = obj instanceof String) && snapped && (obj instanceof Number && ((Number)obj).intValue() == 0 || obj instanceof Boolean && !((Boolean)obj).booleanValue())) continue;
                String string = str = isstring ? "\"" + obj + "\"" : String.valueOf(obj);
                if (flag) {
                    sb.append(", ");
                }
                sb.append(m.getName().substring(l).toLowerCase()).append("=").append(str);
                flag = true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        sb.append("]");
        return sb.toString();
    }

    public static String subString(String t, int size) {
        int hansize;
        if (t == null) {
            return null;
        }
        int len = hansize = size * 3 / 2;
        if (t.length() > size) {
            int p = 0;
            for (int i = 0; i < hansize && i < t.length(); ++i) {
                if (t.charAt(i) <= '\u007f') continue;
                ++p;
            }
            if ((len -= p * 2 / 3) < size) {
                len = size;
            }
            if (t.length() <= len) {
                return t;
            }
            return t.substring(0, len) + "...";
        }
        return t;
    }

    public static String createSequence() {
        return UUID.randomUUID().toString();
    }

    public static String formatFileLength(long sizes) {
        if (sizes < 0L) {
            sizes = 0L;
        }
        String str = "";
        str = sizes < 1024L ? str + "" + sizes + "B" : (sizes < 0x100000L ? str + "" + numformat.format((double)sizes / 1024.0) + "K" : (sizes < 0x40000000L ? str + "" + numformat.format((double)sizes / 1048576.0) + "M" : (sizes < 0x10000000000L ? str + "" + numformat.format((double)sizes / 1.073741824E9) + "G" : str + "" + numformat.format((double)sizes / 1.099511627776E12) + "T")));
        for (int i = 0; i < 8 - str.length(); ++i) {
            str = " " + str;
        }
        return str;
    }

    public static String toHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            sb.append(hex[b >> 4 & 0xF]).append(hex[b >> 0 & 0xF]);
        }
        return sb.toString();
    }

    public static byte[] hexStringToBytes(String inString) {
        int fromLen = inString.length();
        int toLen = (fromLen + 1) / 2;
        byte[] b = new byte[toLen];
        for (int i = 0; i < toLen; ++i) {
            b[i] = (byte)StringTools.hexPairToInt(inString.substring(i * 2, (i + 1) * 2));
        }
        return b;
    }

    public static String ArrayToSortString(List<String> totalStringList) {
        String str = "";
        if (totalStringList != null && totalStringList.size() > 0) {
            Object[] strs = totalStringList.toArray(new String[totalStringList.size()]);
            Arrays.sort(strs);
            for (Object s : strs) {
                str = str + (String)s;
            }
        }
        return str;
    }

    public static byte[] convertStringCid2Bytes(String sCid) {
        byte[] cid = new byte[20];
        for (int i = 0; i < cid.length; ++i) {
            cid[i] = (byte)Integer.parseInt(sCid.substring(i * 2, i * 2 + 2), 16);
        }
        return cid;
    }

    public static int search(String no, String[] noes) {
        for (int i = 0; i < noes.length; ++i) {
            if (!no.equals(noes[i])) continue;
            return i;
        }
        return -1;
    }

    private static int hexPairToInt(String inString) {
        String digits = "0123456789abcdef";
        String s = inString.toLowerCase();
        int n = 0;
        int thisDigit = 0;
        int sLen = s.length();
        if (sLen > 2) {
            sLen = 2;
        }
        for (int i = 0; i < sLen; ++i) {
            thisDigit = digits.indexOf(s.substring(i, i + 1));
            if (thisDigit < 0) {
                throw new NumberFormatException();
            }
            if (i == 0) {
                thisDigit *= 16;
            }
            n += thisDigit;
        }
        return n;
    }

    public static String read(InputStream in, String charset) throws IOException {
        int pos = -1;
        byte[] buf = new byte[8192];
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((pos = in.read(buf)) != -1) {
            out.write(buf, 0, pos);
        }
        return charset == null ? new String(out.toByteArray()) : new String(out.toByteArray(), charset);
    }

    public static String read(InputStream in) throws IOException {
        return StringTools.read(in, null);
    }

    public static final String escapeJs(String unicode) {
        return StringEscapeUtils.escapeJavaScript(unicode);
    }

    public static String encodeURL(String str) {
        try {
            return URLEncoder.encode(str, "utf-8").replaceAll("\\+", "%20");
        }
        catch (Exception ex) {
            return "";
        }
    }

    public static String decodeURL(String str) {
        try {
            return URLDecoder.decode(str, "utf-8");
        }
        catch (Exception ex) {
            return "";
        }
    }

    public static final String escapeHtml(String unicode) {
        return StringEscapeUtils.escapeHtml(unicode);
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }

    public static boolean isNotEmpty(String str) {
        return str != null && !str.trim().isEmpty();
    }

    public static final String escapeSql(String str) {
        if (str == null) {
            return "";
        }
        for (String[] ss : sqlhandles) {
            str = str.replaceAll(ss[0], ss[1]);
        }
        return str;
    }

    public static String toLenString(long value, int length) {
        String val = value + "";
        if (val.length() > length) {
            throw new XLRuntimeException("\u5b9a\u4e49\u7684\u957f\u5ea6\u5c0f\u4e8e\u6570\u503c\u7684\u957f\u5ea6\u3002");
        }
        if (val.length() < length) {
            return zeros.substring(0, length - val.length()) + val;
        }
        return val;
    }

    public static final String escapeSql(Object obj) {
        if (obj == null) {
            return "";
        }
        return StringTools.escapeSql(obj.toString());
    }

    public static int safeToInt(Object o) {
        int rs = 0;
        try {
            rs = Integer.parseInt(o.toString());
        }
        catch (Exception ex) {
            rs = 0;
        }
        return rs;
    }

    public static int safeToShort(Object o) {
        short rs = 0;
        try {
            rs = Short.parseShort(o.toString());
        }
        catch (Exception ex) {
            rs = 0;
        }
        return rs;
    }

    public static long safeToLong(Object o) {
        long rs = 0L;
        try {
            rs = Long.parseLong(o.toString());
        }
        catch (Exception ex) {
            rs = 0L;
        }
        return rs;
    }

    public static double safeToDouble(Object o) {
        double rs = 0.0;
        try {
            rs = Double.parseDouble(o.toString());
        }
        catch (Exception ex) {
            rs = 0.0;
        }
        return rs;
    }

    public static boolean isCommonOperate(String operate) {
        for (String opt : Constants.COMMON_OPERATE) {
            if (!opt.equalsIgnoreCase(operate)) continue;
            return true;
        }
        return false;
    }

    public static String getTradeSn() {
        return "" + new Date().getTime();
    }

    public static String compress(String str) {
        Deflater compresser = new Deflater();
        compresser.setInput(str.getBytes());
        compresser.finish();
        byte[] buf = new byte[4096];
        int len = compresser.deflate(buf);
        byte[] out = new byte[len];
        for (int i = 0; i < len; ++i) {
            out[i] = buf[i];
        }
        return new BASE64Encoder().encode(out);
    }

    public static String decompress(String str) throws Exception {
        byte[] decodeBytes = new BASE64Decoder().decodeBuffer(str);
        Inflater decompresser = new Inflater();
        decompresser.setInput(decodeBytes, 0, decodeBytes.length);
        byte[] buf = new byte[4096];
        int len = decompresser.inflate(buf);
        decompresser.end();
        byte[] out = new byte[len];
        for (int i = 0; i < len; ++i) {
            out[i] = buf[i];
        }
        return new String(out);
    }

    public static double tryParseDouble(Object fieldValue) {
        try {
            double rs = (Double)fieldValue;
            return rs;
        }
        catch (Exception ex) {
            try {
                return Double.parseDouble(fieldValue.toString());
            }
            catch (Exception exx) {
                return 0.0;
            }
        }
    }

    public static void main(String[] args) {
        System.out.println(537461015);
        System.out.println(Integer.reverseBytes(537461015));
    }
}

