/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.util;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.imageio.ImageIO;

public class ImagesHandle {
    private static BufferedImage resize(BufferedImage source, int targetW, int targetH) {
        double sy;
        int type = source.getType();
        BufferedImage target = null;
        double sx = (double)targetW / (double)source.getWidth();
        if (sx < (sy = (double)targetH / (double)source.getHeight())) {
            sx = sy;
            targetW = (int)(sx * (double)source.getWidth());
        } else {
            sy = sx;
            targetH = (int)(sy * (double)source.getHeight());
        }
        if (type == 0) {
            ColorModel cm = source.getColorModel();
            WritableRaster raster = cm.createCompatibleWritableRaster(targetW, targetH);
            boolean alphaPremultiplied = cm.isAlphaPremultiplied();
            target = new BufferedImage(cm, raster, alphaPremultiplied, null);
        } else {
            target = new BufferedImage(targetW, targetH, type);
        }
        Graphics2D g = target.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.drawRenderedImage(source, AffineTransform.getScaleInstance(sx, sy));
        g.dispose();
        return target;
    }

    private static void saveSubImage(BufferedImage image, Rectangle subImageBounds, File subImageFile) throws IOException {
        if (subImageBounds.x < 0 || subImageBounds.y < 0 || subImageBounds.width - subImageBounds.x > image.getWidth() || subImageBounds.height - subImageBounds.y > image.getHeight()) {
            System.out.println("Bad   subimage   bounds");
            return;
        }
        BufferedImage subImage = image.getSubimage(subImageBounds.x, subImageBounds.y, subImageBounds.width, subImageBounds.height);
        String fileName = subImageFile.getName();
        String formatName = fileName.substring(fileName.lastIndexOf(46) + 1);
        ImageIO.write((RenderedImage)subImage, formatName, subImageFile);
    }

    public static void saveImageAsJpg(String inFilePath, String outFilePath, int width, int hight, boolean proportion) throws Exception {
        File file = new File(inFilePath);
        FileInputStream in = new FileInputStream(file);
        File saveFile = new File(outFilePath);
        BufferedImage srcImage = ImageIO.read(in);
        if (width > 0 || hight > 0) {
            int sw = srcImage.getWidth();
            int sh = srcImage.getHeight();
            if (sw > width && sh > hight) {
                srcImage = ImagesHandle.resize(srcImage, width, hight);
            } else {
                String fileName = saveFile.getName();
                String formatName = fileName.substring(fileName.lastIndexOf(46) + 1);
                ImageIO.write((RenderedImage)srcImage, formatName, saveFile);
                return;
            }
        }
        int w = srcImage.getWidth();
        int h = srcImage.getHeight();
        if (w == width) {
            int x = 0;
            int y = h / 2 - hight / 2;
            ImagesHandle.saveSubImage(srcImage, new Rectangle(x, y, width, hight), saveFile);
        } else if (h == hight) {
            int x = w / 2 - width / 2;
            int y = 0;
            ImagesHandle.saveSubImage(srcImage, new Rectangle(x, y, width, hight), saveFile);
        }
        ((InputStream)in).close();
    }

    public static void main(String[] args) throws IOException {
        String path = "";
        File f = new File(path);
        ImagesHandle.load(f);
    }

    public static void load(File dir) {
        Object[] files = dir.listFiles();
        Arrays.sort(files);
        for (int i = 0; i < files.length; ++i) {
            Object f = files[i];
            if (((File)f).isDirectory()) {
                ImagesHandle.load((File)f);
                continue;
            }
            String name = ((File)f).getName();
            File p = ((File)f).getParentFile();
            String oldFile = p.getPath() + File.separator + name;
            String newFile = p.getPath() + File.separator + "b_" + name;
            if (!name.endsWith(".jpg") && !name.endsWith(".jpeg")) continue;
            try {
                ImagesHandle.saveImageAsJpg(oldFile, newFile, 200, 150, false);
                System.out.println("ok: file name is " + newFile);
                continue;
            }
            catch (Exception e) {
                System.out.println("error: file name is " + newFile);
            }
        }
    }
}

