/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.util;

import com.xunlei.common.util.XLRuntimeException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtil {
    public static void copyFile(InputStream sfile, String dfile) {
        File outputFile = new File(dfile);
        try {
            int bytes_read;
            BufferedInputStream bis = new BufferedInputStream(sfile);
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(outputFile));
            byte[] buffer = new byte[4096];
            while ((bytes_read = bis.read(buffer)) != -1) {
                bos.write(buffer, 0, bytes_read);
            }
            sfile.close();
            bis.close();
            bos.close();
        }
        catch (Exception e) {
            throw new XLRuntimeException("\u62f7\u8d1d\u6587\u4ef6\u51fa\u9519\uff1a" + e);
        }
    }

    public static void copyFile(String sfile, String dfile) {
        File inputFile = new File(sfile);
        File outputFile = new File(dfile);
        try {
            int bytes_read;
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(inputFile));
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(outputFile));
            byte[] buffer = new byte[4096];
            while ((bytes_read = bis.read(buffer)) != -1) {
                bos.write(buffer, 0, bytes_read);
            }
            bis.close();
            bos.flush();
            bos.close();
        }
        catch (Exception e) {
            throw new XLRuntimeException("\u62f7\u8d1d\u6587\u4ef6" + sfile + "\u51fa\u9519\uff1a" + e);
        }
    }

    public static void copyFiles(String spath, String dpath) {
        String[] files = FileUtil.listFile(spath, null);
        for (int i = 0; i < files.length; ++i) {
            String srcfile = spath + File.separator + files[i];
            String decfile = dpath + File.separator + files[i];
            FileUtil.copyFile(srcfile, decfile);
        }
    }

    public static void copyFolder(String spath, String dpath) {
        new File(dpath).mkdirs();
        String[] files = new File(spath).list();
        File tf = null;
        String tfspath = null;
        for (int i = 0; i < files.length; ++i) {
            tfspath = spath.endsWith(File.separator) ? spath + files[i] : spath + File.separator + files[i];
            tf = new File(tfspath);
            if (tf.isFile()) {
                FileUtil.copyFile(tfspath, dpath + File.separator + tf.getName());
                continue;
            }
            if (!tf.isDirectory()) continue;
            FileUtil.copyFolder(spath + File.separator + files[i], dpath + File.separator + files[i]);
        }
    }

    public static List<String> readFile(String file) {
        String str = null;
        ArrayList<String> result = new ArrayList<String>();
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "GBK"));
            while ((str = br.readLine()) != null) {
                result.add(str);
            }
            br.close();
        }
        catch (Exception e) {
            throw new XLRuntimeException("\u8bfb\u6587\u4ef6" + file + "\u51fa\u9519\uff1a" + e);
        }
        return result;
    }

    public static String readFile2Str(String file) {
        String str = null;
        StringBuffer sb = new StringBuffer();
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "GBK"));
            while ((str = br.readLine()) != null) {
                sb.append(str + "\n");
            }
            br.close();
        }
        catch (Exception e) {
            throw new XLRuntimeException("\u8bfb\u6587\u4ef6" + file + "\u51fa\u9519\uff1a" + e);
        }
        return sb.toString();
    }

    public static void writeFile(Collection<String> lines, String file) {
        FileUtil.newFile(file, "");
        StringBuffer buf = new StringBuffer();
        Iterator<String> it = lines.iterator();
        while (it.hasNext()) {
            String line = it.next().toString();
            buf.append(line).append("\n");
        }
        try {
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "GBK");
            osw.write(buf.toString(), 0, buf.toString().length());
            osw.flush();
            osw.close();
        }
        catch (Exception e) {
            throw new XLRuntimeException("\u5199\u6587\u4ef6" + file + "\u51fa\u9519\uff1a" + e);
        }
    }

    public static void writeFile(String filelines, String file) {
        try {
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "GBK");
            osw.write(filelines);
            osw.flush();
            osw.close();
        }
        catch (Exception e) {
            throw new XLRuntimeException("\u5199\u6587\u4ef6" + file + "\u51fa\u9519\uff1a" + e);
        }
    }

    public static String[] listFile(String path, String extnames) {
        String[] names = null;
        File file = new File(path);
        if (extnames == null || extnames.trim().equals("")) {
            names = file.list();
        } else {
            final String[] exts = extnames.split(",");
            names = file.list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return this.inlist(name);
                }

                private boolean inlist(String name) {
                    if (name.lastIndexOf(".") == -1) {
                        return false;
                    }
                    String ext = name.substring(name.lastIndexOf("."));
                    for (int i = 0; i < exts.length; ++i) {
                        if (!exts[i].equalsIgnoreCase(ext)) continue;
                        return true;
                    }
                    return false;
                }
            });
        }
        return names;
    }

    public static void deleteFiles(String path) {
        File p = new File(path);
        if (p.exists() && p.isDirectory()) {
            File[] files = p.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].isFile()) continue;
                files[i].delete();
            }
        }
    }

    public static void deleteFiles(String path, String[] files) {
        File p;
        if (!path.endsWith(File.separator)) {
            path = path + File.separator;
        }
        if ((p = new File(path)).exists() && p.isDirectory()) {
            for (int i = 0; i < files.length; ++i) {
                File f = new File(path + files[i]);
                f.delete();
            }
        }
    }

    public static void deleteFile(String file) {
        File f = new File(file);
        f.delete();
    }

    public static void newFolder(String folderPath) {
        try {
            File myFilePath = new File(folderPath);
            if (!myFilePath.exists()) {
                myFilePath.mkdir();
            }
        }
        catch (Exception e) {
            throw new XLRuntimeException("\u65b0\u5efa\u76ee\u5f55" + folderPath + "\u51fa\u9519\uff1a" + e);
        }
    }

    public static void newFile(String filePathAndName, String fileContent) {
        try {
            File myFilePath = new File(filePathAndName);
            if (!myFilePath.exists()) {
                myFilePath.createNewFile();
            }
            FileWriter resultFile = new FileWriter(myFilePath);
            PrintWriter myFile = new PrintWriter(resultFile);
            myFile.println(fileContent);
            myFile.close();
            resultFile.close();
        }
        catch (Exception e) {
            throw new XLRuntimeException("\u65b0\u5efa\u6587\u4ef6" + filePathAndName + "\u51fa\u9519\uff1a" + e);
        }
    }

    public static void delAll(File f) throws IOException {
        if (!f.exists()) {
            throw new IOException("\u6307\u5b9a\u76ee\u5f55\u4e0d\u5b58\u5728:" + f.getName());
        }
        boolean rslt = true;
        rslt = f.delete();
        if (!rslt) {
            File[] subs = f.listFiles();
            for (int i = 0; i < subs.length; ++i) {
                if (subs[i].isDirectory()) {
                    FileUtil.delAll(subs[i]);
                }
                rslt = subs[i].delete();
            }
            rslt = f.delete();
        }
        if (!rslt) {
            throw new IOException("\u65e0\u6cd5\u5220\u9664:" + f.getName());
        }
    }

    public static void main(String[] args) {
        FileUtil.deleteFiles("D:/workspace/XLRelease/configfile/package/test/");
    }
}

