/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.dao;

import com.xunlei.common.dao.IUtilDao;
import com.xunlei.common.dao.JdbcBaseDao;
import com.xunlei.common.util.FrameworkUtil;
import com.xunlei.common.util.XLRuntimeException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.StringTokenizer;
import javax.sql.DataSource;
import org.apache.commons.beanutils.RowSetDynaClass;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class UtilDaoImpl
extends JdbcBaseDao
implements IUtilDao {
    @Override
    public int getRecordCount(Class cls, String where) {
        String sql = "select count(*) from " + cls.getName().toLowerCase() + " as cls ";
        if (this.isNotEmpty(where)) {
            sql = sql + " where " + where;
        }
        return this.getSingleInt(sql);
    }

    @Override
    public int getRecordCount(String cls, String where) {
        String sql = "select count(*) from " + cls.toLowerCase() + " as cls ";
        if (this.isNotEmpty(where)) {
            sql = sql + " where " + where;
        }
        return this.getSingleInt(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public int getRecordCount(String sql) {
        int count = -1;
        DataSource ds = (DataSource)FrameworkUtil.getApplicationContext().getBean("dataSource");
        try {
            Connection con = ds.getConnection();
            try {
                Statement st = con.createStatement();
                ResultSet rs = st.executeQuery(sql);
                rs.next();
                count = rs.getInt(1);
                rs.close();
                st.close();
            }
            finally {
                con.close();
                con = null;
            }
        }
        catch (Exception e) {
            count = -1;
            e.printStackTrace();
        }
        return count;
    }

    @Override
    public int execUpdSql(String sql) {
        return this.getJdbcTemplate().update(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public int execUpdSql_BK(String sql) {
        int n;
        DataSource ds = (DataSource)FrameworkUtil.getApplicationContext().getBean("dataSource");
        Connection con = ds.getConnection();
        con.setAutoCommit(true);
        try {
            Statement st = con.createStatement();
            int count = st.executeUpdate(sql);
            st.close();
            n = count;
        }
        catch (Throwable throwable) {
            try {
                con.close();
                con = null;
                throw throwable;
            }
            catch (Exception e) {
                throw new XLRuntimeException(e);
            }
        }
        con.close();
        con = null;
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public int[] execUpdBatchSql(List<String> sqls) {
        int[] nArray;
        DataSource ds = (DataSource)FrameworkUtil.getApplicationContext().getBean("dataSource");
        Connection con = ds.getConnection();
        try {
            Statement st = con.createStatement();
            for (String s : sqls) {
                st.addBatch(s);
            }
            int[] counts = st.executeBatch();
            st.close();
            nArray = counts;
        }
        catch (Throwable throwable) {
            try {
                con.close();
                con = null;
                throw throwable;
            }
            catch (Exception e) {
                throw new XLRuntimeException(e);
            }
        }
        con.close();
        con = null;
        return nArray;
    }

    @Override
    @Deprecated
    public int getRecordCount(String sql, boolean needamendsql) {
        if (needamendsql) {
            String lsql = sql.substring(0, sql.toLowerCase().indexOf("select ") + 7);
            String rsql = sql.substring(sql.toLowerCase().indexOf(" from "));
            sql = lsql + "count(*)" + rsql;
        }
        return this.getRecordCount(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public <T> List<T> getRecords(String sql) {
        List list;
        DataSource ds = (DataSource)FrameworkUtil.getApplicationContext().getBean("dataSource");
        Connection con = ds.getConnection();
        try {
            Statement st = con.createStatement();
            ResultSet rs = st.executeQuery(sql);
            RowSetDynaClass rsdc = new RowSetDynaClass(rs);
            rs.close();
            st.close();
            list = rsdc.getRows();
        }
        catch (Throwable throwable) {
            try {
                con.close();
                con = null;
                throw throwable;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        con.close();
        con = null;
        return list;
    }

    @Override
    @Deprecated
    public String[] executeProc(String procstr, String[] parastr) {
        Statement proc = null;
        Connection con = null;
        String[] out = new String[]{};
        int ParaNum = 0;
        int RetValueNum = 0;
        try {
            int i;
            DataSource ds = (DataSource)FrameworkUtil.getApplicationContext().getBean("dataSource");
            con = ds.getConnection();
            StringTokenizer ParseStr = new StringTokenizer(procstr, "?");
            ParaNum = ParseStr.countTokens() - 1;
            ParseStr = new StringTokenizer(procstr, "^");
            RetValueNum = ParseStr.countTokens() - 1;
            if (RetValueNum >= 0) {
                out = new String[RetValueNum];
            }
            procstr = procstr.replace('^', '?');
            proc = con.prepareCall(procstr);
            if (ParaNum > 0) {
                for (i = 0; i < ParaNum; ++i) {
                    proc.setString(i + 1, parastr[i]);
                }
            }
            if (RetValueNum > 0) {
                for (i = 0; i < RetValueNum; ++i) {
                    proc.registerOutParameter(ParaNum + i + 1, 12);
                }
            }
            proc.execute();
            if (RetValueNum > 0) {
                for (i = 0; i < RetValueNum; ++i) {
                    out[i] = proc.getString(ParaNum + i + 1);
                }
            }
        }
        catch (Exception ex) {
            throw new XLRuntimeException(ex);
        }
        finally {
            try {
                if (proc != null) {
                    proc.close();
                }
                con.close();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        return out;
    }

    @Override
    public <T> List<T> getRecords(Class<T> clazz, String where) {
        try {
            T o = clazz.newInstance();
            return this.findObjects(o, where, null);
        }
        catch (Exception ex) {
            throw new XLRuntimeException(ex);
        }
    }
}

