/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.dao;

import com.xunlei.common.dao.IMailinfoDao;
import com.xunlei.common.dao.JdbcBaseDao;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.common.vo.MailPrevAndNext;
import com.xunlei.common.vo.MailcountInfo;
import com.xunlei.common.vo.Mailinfo;
import java.util.List;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class MailinfoDaoImpl
extends JdbcBaseDao
implements IMailinfoDao {
    @Override
    public Mailinfo getMailinfoById(long seqid) {
        Mailinfo p = new Mailinfo();
        p.setSeqid(seqid);
        return this.findObject(p);
    }

    @Override
    public Mailinfo insertMailinfo(Mailinfo data) {
        return this.saveObject(data);
    }

    @Override
    public void updateMailinfo(Mailinfo data) {
        this.updateObject(data);
    }

    @Override
    public void deleteMailinfoById(long seqid) {
        Mailinfo p = new Mailinfo();
        p.setSeqid(seqid);
        this.deleteMailinfo(p);
    }

    @Override
    public void deleteMailinfo(Mailinfo data) {
        this.deleteObjectByCondition(data, null);
    }

    @Override
    public Sheet<Mailinfo> queryMailinfo(Mailinfo data, PagedFliper fliper) {
        StringBuilder exWhere = new StringBuilder();
        if (data.getQueryreceiverdeltype() == -1) {
            exWhere.append(" and receiverdel=0");
        } else if (data.getQueryreceiverdeltype() == 1) {
            exWhere.append(" and receiverdel=1");
        }
        if (data.getQuerysenderdeltype() == -1) {
            exWhere.append(" and senderdel=0");
        } else if (data.getQuerysenderdeltype() == 1) {
            exWhere.append(" and senderdel=1");
        }
        if (data.getReceiverclassids() != null) {
            exWhere.append(" and receiver in ").append(MailinfoDaoImpl.uniteForIn(data.getReceiverclassids()));
        }
        if (data.getSenderclassids() != null) {
            exWhere.append(" and sender in ").append(MailinfoDaoImpl.uniteForIn(data.getSenderclassids()));
        }
        if (StringTools.isNotEmpty(data.getFromdate())) {
            exWhere.append(" and inputtime >= '").append(StringTools.escapeSql(data.getFromdate())).append(" 00:00:00' ");
        }
        if (StringTools.isNotEmpty(data.getTodate())) {
            exWhere.append(" and inputtime <= '").append(StringTools.escapeSql(data.getTodate())).append(" 23:59:59' ");
        }
        if (StringTools.isNotEmpty(data.getTitlelike())) {
            exWhere.append(" and title like '%").append(StringTools.escapeSql(data.getTitlelike())).append("%' ");
        }
        return this.findPagedObjects(data, exWhere.toString(), fliper);
    }

    @Override
    public MailPrevAndNext getMailPrevAndNextSeqid(Mailinfo data) {
        Sheet<Mailinfo> prevmails;
        MailPrevAndNext pn = new MailPrevAndNext();
        long seqid = data.getSeqid();
        data.setSeqid(0L);
        PagedFliper fliper = new PagedFliper();
        fliper.setPageSize(1);
        fliper.setSortColumn("seqid desc");
        StringBuilder exWhere = new StringBuilder();
        if (data.getQueryreceiverdeltype() == -1) {
            exWhere.append(" and receiverdel=0");
        } else if (data.getQueryreceiverdeltype() == 1) {
            exWhere.append(" and receiverdel=1");
        }
        if (data.getQuerysenderdeltype() == -1) {
            exWhere.append(" and senderdel=0");
        } else if (data.getQuerysenderdeltype() == 1) {
            exWhere.append(" and senderdel=1");
        } else if (data.getMaildirection() > 0) {
            exWhere.append(" and maildirection=" + data.getMaildirection());
        }
        if (data.getReceiverclassids() != null) {
            exWhere.append(" and receiver in " + MailinfoDaoImpl.uniteForIn(data.getReceiverclassids()));
        }
        if (data.getSenderclassids() != null) {
            exWhere.append(" and sender in " + MailinfoDaoImpl.uniteForIn(data.getSenderclassids()));
        }
        if ((prevmails = this.findPagedObjects(data, "and seqid<" + seqid + exWhere.toString(), fliper)).getRowcount() > 0) {
            pn.setPrevseqid(((Mailinfo)((List)prevmails.getDatas()).get(0)).getSeqid());
        }
        fliper.setSortColumn("seqid asc");
        Sheet<Mailinfo> nextmails = this.findPagedObjects(data, "and seqid>" + seqid + exWhere.toString(), fliper);
        if (nextmails.getRowcount() > 0) {
            pn.setNextseqid(((Mailinfo)((List)nextmails.getDatas()).get(0)).getSeqid());
        }
        pn.setSeqid(seqid);
        return pn;
    }

    @Override
    public MailcountInfo getMailinfocount(String username) {
        String sql = "select count(1) from mailinfo where receiver='" + StringTools.escapeSql(username) + "' and receiverdel=0 and maildirection=1";
        MailcountInfo mc = new MailcountInfo();
        mc.setUsername(username);
        mc.setTotal(this.getSingleInt(sql));
        sql = sql + " and readed=0";
        mc.setUnread(this.getSingleInt(sql));
        return mc;
    }

    @Override
    public MailcountInfo getClassMailinfocount(String[] classid) {
        String sql = "select count(1) from mailinfo where receiver in " + MailinfoDaoImpl.uniteForIn(classid) + " and receiverdel=0 and maildirection=2";
        MailcountInfo mc = new MailcountInfo();
        mc.setTotal(this.getSingleInt(sql));
        sql = sql + " and readed=0";
        mc.setUnread(this.getSingleInt(sql));
        return mc;
    }
}

