/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.bo;

import com.xunlei.common.bo.BaseBo;
import com.xunlei.common.bo.IMailinfoBo;
import com.xunlei.common.dao.IMailinfoDao;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.common.vo.MailPrevAndNext;
import com.xunlei.common.vo.MailcountInfo;
import com.xunlei.common.vo.Mailinfo;
import com.xunlei.common.vo.Mailsendtemp;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class MailinfoBoImpl
extends BaseBo
implements IMailinfoBo {
    private static final String SPLIT = ",";
    private static final String FRONTALL = "\u524d\u53f0\u7fa4\u53d1";
    @Autowired
    private IMailinfoDao mailinfoDaoImpl;

    @Override
    public Mailinfo getMailinfoById(long seqid) {
        return this.mailinfoDaoImpl.getMailinfoById(seqid);
    }

    @Override
    public Mailinfo insertMailinfo(Mailinfo data) {
        return this.mailinfoDaoImpl.insertMailinfo(data);
    }

    @Override
    public void updateMailinfo(Mailinfo data) {
        this.mailinfoDaoImpl.updateMailinfo(data);
    }

    @Override
    public void deleteMailinfoById(long seqid) {
        this.mailinfoDaoImpl.deleteMailinfoById(seqid);
    }

    @Override
    public void deleteMailinfo(Mailinfo data) {
        this.mailinfoDaoImpl.deleteMailinfo(data);
    }

    @Override
    public Sheet<Mailinfo> queryMailinfo(Mailinfo data, PagedFliper fliper) {
        return this.mailinfoDaoImpl.queryMailinfo(data, fliper);
    }

    @Override
    public Mailinfo getMailinfo(Mailinfo data) {
        Sheet<Mailinfo> mail = this.mailinfoDaoImpl.queryMailinfo(data, null);
        Mailinfo m = null;
        if (mail.getRowcount() > 0) {
            m = (Mailinfo)((List)mail.getDatas()).get(0);
        }
        return m;
    }

    @Override
    public MailPrevAndNext getMailPrevAndNextSeqid(Mailinfo data) {
        return this.mailinfoDaoImpl.getMailPrevAndNextSeqid(data);
    }

    @Override
    public MailcountInfo getMailinfocount(String username) {
        return this.mailinfoDaoImpl.getMailinfocount(username);
    }

    @Override
    public MailcountInfo getClassMailinfocount(String[] classid) {
        return this.mailinfoDaoImpl.getClassMailinfocount(classid);
    }

    @Override
    public void doSendMail(Mailinfo mailinfo) {
        mailinfo.setMaildirection((short)1);
        mailinfo.setInputtime(DatetimeUtil.now());
        String receivers = mailinfo.getReceiver();
        if (receivers.indexOf(SPLIT) >= 0 || receivers.equals(FRONTALL)) {
            if (receivers.equals(FRONTALL)) {
                String[] frontusers = IFacadeCommon.INSTANCE.getFrontUsersLognoAndTrueName();
                StringBuilder buildReceivers = new StringBuilder();
                for (int i = 0; i < frontusers.length; ++i) {
                    buildReceivers.append(frontusers[i].split("\\|")[0]);
                    if (i >= frontusers.length - 1) continue;
                    buildReceivers.append(SPLIT);
                }
                receivers = buildReceivers.toString();
            }
            Mailsendtemp temp = new Mailsendtemp();
            temp.setReceivers(receivers);
            temp.setAllsendno(StringTools.getTradeSn());
            temp.setTitle(mailinfo.getTitle());
            temp.setContent(mailinfo.getContent());
            temp.setClassid(mailinfo.getClassid());
            temp.setInputby(mailinfo.getInputby());
            temp.setInputtime(DatetimeUtil.now());
            temp.setStatus("S");
            IFacadeCommon.INSTANCE.insertMailsendtemp(temp);
            this.doAsyncSendmailbysn(temp.getAllsendno());
        } else {
            Mailinfo omail;
            boolean isReply = "reply".equalsIgnoreCase(mailinfo.getType());
            if (isReply && (omail = this.getMailinfoById(mailinfo.getSeqid())) != null) {
                omail.setReplyed((short)1);
                omail.setReaded((short)1);
                this.updateMailinfo(omail);
                mailinfo.setPmailid(mailinfo.getSeqid());
            }
            this.insertMailinfo(mailinfo);
        }
    }

    @Override
    public void doResendTemp(String allsendno) {
        Mailsendtemp querytemp = new Mailsendtemp();
        querytemp.setAllsendno(allsendno);
        Mailsendtemp temp = IFacadeCommon.INSTANCE.queryMailsendtemp(querytemp);
        if (temp != null) {
            temp.setStatus("S");
            IFacadeCommon.INSTANCE.updateMailsendtemp(temp);
        }
        this.doAsyncSendmailbysn(allsendno);
    }

    private void doAsyncSendmailbysn(final String sn) {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                Mailsendtemp querytemp = new Mailsendtemp();
                querytemp.setAllsendno(sn);
                Mailsendtemp temp = IFacadeCommon.INSTANCE.queryMailsendtemp(querytemp);
                if (temp != null) {
                    String[] receivers = temp.getReceivers().split("\\,");
                    Mailinfo queryforsend = new Mailinfo();
                    queryforsend.setAllsendno(temp.getAllsendno());
                    Mailinfo mailtoSend = new Mailinfo();
                    mailtoSend.setTitle(temp.getTitle());
                    mailtoSend.setContent(temp.getContent());
                    mailtoSend.setAllsendno(temp.getAllsendno());
                    mailtoSend.setSender(temp.getClassid());
                    mailtoSend.setClassid(temp.getClassid());
                    mailtoSend.setMaildirection((short)1);
                    mailtoSend.setInputby(temp.getInputby());
                    mailtoSend.setInputtime(DatetimeUtil.now());
                    try {
                        for (int i = 0; i < receivers.length; ++i) {
                            if (StringTools.isEmpty(receivers[i])) continue;
                            queryforsend.setReceiver(receivers[i]);
                            if (MailinfoBoImpl.this.getMailinfo(queryforsend) == null) {
                                mailtoSend.setReceiver(receivers[i]);
                                MailinfoBoImpl.this.insertMailinfo(mailtoSend);
                            }
                            MailinfoBoImpl.this.logger.debug("\u540e\u53f0\u53d1\u9001" + mailtoSend.getAllsendno() + "\u7b2c" + (i + 1) + "\u4e2a\u8bb0\u5f55");
                        }
                        IFacadeCommon.INSTANCE.deleteMailsendtemp(querytemp);
                        MailinfoBoImpl.this.logger.debug("\u72ec\u7acb\u7ebf\u7a0b\u53d1\u9001\u90ae\u4ef6\u5b8c\u6210");
                    }
                    catch (Exception ex) {
                        MailinfoBoImpl.this.logger.debug("\u540e\u53f0\u53d1\u9001" + mailtoSend.getAllsendno() + "\u7684\u90ae\u4ef6\u5931\u8d25\u3002" + ex);
                        temp.setExceptiondesp(ex.getMessage());
                        temp.setStatus("F");
                        IFacadeCommon.INSTANCE.updateMailsendtemp(temp);
                    }
                }
            }
        });
        thread.start();
        this.logger.debug("\u542f\u52a8\u7ebf\u7a0b\u5e76\u8fd4\u56de");
    }
}

