/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.bo;

import com.xunlei.common.bo.BaseBo;
import com.xunlei.common.bo.ILibConfigBo;
import com.xunlei.common.dao.ILibConfigDao;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.common.vo.LibConfig;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class LibConfigBoImpl
extends BaseBo
implements ILibConfigBo {
    @Autowired
    private ILibConfigDao libConfigDao;

    public ILibConfigDao getLibConfigDao() {
        return this.libConfigDao;
    }

    @Override
    public void setLibConfigDao(ILibConfigDao libConfigDao) {
        this.libConfigDao = libConfigDao;
    }

    @Override
    public List<LibConfig> getAllLibConfig() {
        return this.getLibConfigDao().getAllLibConfig();
    }

    @Override
    @Deprecated
    public int getLibConfigViewCount(LibConfig config) {
        return this.getLibConfigDao().getLibConfigViewCount(config);
    }

    @Override
    @Deprecated
    public List<LibConfig> getLibConfigView(LibConfig config, String sortClomun, int rowcount, int pagesize, int pageno) {
        return this.getLibConfigDao().getLibConfigView(config, sortClomun, rowcount, pagesize, pageno);
    }

    @Override
    public LibConfig getLibConfigById(Long id) {
        LibConfig lc = new LibConfig();
        lc.setSeqid(id);
        return this.getLibConfigDao().getALibConfig(lc);
    }

    @Override
    public List<LibConfig> getLibConfigByConfigNo(String configno) {
        LibConfig lc = new LibConfig();
        lc.setConfigno(configno);
        return this.getLibConfigDao().getLibConfig(lc);
    }

    private List<LibConfig> getLibConfigByConfigName(String configname) {
        LibConfig lc = new LibConfig();
        lc.setConfigname(configname);
        return this.getLibConfigDao().getLibConfig(lc);
    }

    @Override
    public void insertLibConfig(LibConfig data) {
        if (this.getLibConfigByConfigNo(data.getConfigno()).size() > 0) {
            throw new XLRuntimeException("\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u7f16\u53f7\u7684\u8bb0\u5f55");
        }
        if (this.getLibConfigByConfigName(data.getConfigname()).size() > 0) {
            throw new XLRuntimeException("\u5df2\u7ecf\u5b58\u5728\u540c\u540d\u7684\u8bb0\u5f55");
        }
        this.getLibConfigDao().insertLibConfig(data);
        LibConfig.clearLibconfig();
    }

    @Override
    public void updateLibConfig(LibConfig data) {
        LibConfig searchobj = new LibConfig();
        searchobj.setConfigno(data.getConfigno());
        LibConfig searchobj2 = new LibConfig();
        searchobj2.setConfigno(data.getConfigno());
        searchobj2.setSeqid(data.getSeqid());
        if (this.isNotEmpty(data.getConfigno()) && this.getLibConfigDao().countLibconfigs(searchobj) != this.getLibConfigDao().countLibconfigs(searchobj2)) {
            throw new XLRuntimeException("\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u7f16\u53f7\u7684\u8bb0\u5f55");
        }
        if (this.isNotEmpty(data.getConfigname())) {
            searchobj.setConfigno("");
            searchobj.setConfigname(data.getConfigname());
            searchobj2.setConfigname(data.getConfigname());
            searchobj2.setSeqid(data.getSeqid());
            if (this.getLibConfigDao().countLibconfigs(searchobj) != this.getLibConfigDao().countLibconfigs(searchobj2)) {
                throw new XLRuntimeException("\u5df2\u7ecf\u5b58\u5728\u540c\u540d\u7684\u8bb0\u5f55");
            }
        }
        data.setEdittime(LibConfigBoImpl.now());
        this.getLibConfigDao().updateLibConfig(data);
        LibConfig.clearLibconfig();
    }

    @Override
    public void removeLibConfig(LibConfig data) {
        this.removeLibConfig(data.getSeqid());
    }

    @Override
    public void removeLibConfig(long seqid) {
        LibConfig data = this.getLibConfigById(seqid);
        if ("PageSize".equalsIgnoreCase(data.getConfigno())) {
            throw new XLRuntimeException("\u9875\u7801\u7684\u7cfb\u7edf\u914d\u7f6e\u4e0d\u53ef\u4ee5\u5220\u9664\uff01");
        }
        if ("siteName".equals(data.getConfigno())) {
            throw new XLRuntimeException("\u7ad9\u70b9\u540d\u79f0\u4e0d\u53ef\u4ee5\u5220\u9664\uff01");
        }
        if ("siteSubName".equals(data.getConfigno())) {
            throw new XLRuntimeException("\u7ad9\u70b9\u5b50\u540d\u79f0\u4e0d\u53ef\u4ee5\u5220\u9664\uff01");
        }
        this.getLibConfigDao().removeLibConfig(seqid);
        LibConfig.clearLibconfig();
    }

    @Override
    @Deprecated
    public int getLibConfigViewCount() {
        return this.getLibConfigDao().getLibConfigViewCount();
    }

    @Override
    @Deprecated
    public List<LibConfig> getLibConfigView(int rowcount, int pagesize, int pageno) {
        return this.getLibConfigDao().getLibConfigView(rowcount, pagesize, pageno);
    }

    @Override
    public Sheet<LibConfig> queryLibconfigs(LibConfig config, PagedFliper fliper) {
        return this.getLibConfigDao().queryLibconfigs(config, fliper);
    }

    @Override
    public int countLibconfigs(LibConfig config) {
        return this.getLibConfigDao().countLibconfigs(config);
    }

    @Override
    public String getSiteName() {
        String sn = "\u8fc5\u96f7\u7ba1\u7406\u5e73\u53f0";
        List<LibConfig> config = this.getLibConfigByConfigNo("SiteName");
        if (config != null && config.size() > 0) {
            sn = config.get(0).getConfigvalue();
        }
        return sn;
    }

    @Override
    public String getSiteSubName() {
        String ssn = "www.xunlei.com";
        List<LibConfig> config = this.getLibConfigByConfigNo("SiteSubName");
        if (config != null && config.size() > 0) {
            ssn = config.get(0).getConfigvalue();
        }
        return ssn;
    }

    @Override
    public String getLibconfigValueByConfigNo(String configno) {
        return this.getLibconfigValueByConfigNo(configno, null);
    }

    @Override
    public String getLibconfigValueByConfigNo(String configno, String defalutValue) {
        String ssn = defalutValue;
        List<LibConfig> config = this.getLibConfigByConfigNo(configno);
        if (config != null && config.size() > 0) {
            ssn = config.get(0).getConfigvalue();
        }
        return ssn;
    }
}

