/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.common.bo;

import com.xunlei.common.bo.IAdvsBo;
import com.xunlei.common.dao.IAdvsDao;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.common.util.ApplicationConfigUtil;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.common.vo.Advs;
import java.io.File;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class AdvsBoImpl
implements IAdvsBo {
    private static Logger logger = Logger.getLogger(AdvsBoImpl.class);
    @Autowired
    private IAdvsDao advsDaoImpl;

    @Override
    public Advs getAdvsById(long seqid) {
        return this.advsDaoImpl.getAdvsById(seqid);
    }

    @Override
    public Advs insertAdvs(Advs data) {
        data.setAdvid(IFacadeCommon.INSTANCE.newAdvid());
        return this.advsDaoImpl.insertAdvs(data);
    }

    @Override
    public void updateAdvs(Advs data) {
        Advs olddata = IFacadeCommon.INSTANCE.getAdvsById(data.getSeqid());
        if (olddata != null) {
            olddata.setEditby(data.getEditby());
            olddata.setEdittime(data.getEdittime());
            olddata.setFlatno(data.getFlatno());
            olddata.setPlaceid(data.getPlaceid());
            olddata.setAdvtitle(data.getAdvtitle());
            olddata.setAdvurl(data.getAdvurl());
            olddata.setExpiretime(data.getExpiretime());
            if (StringTools.isNotEmpty(data.getPicurl())) {
                olddata.setPicurl(data.getPicurl());
            }
            olddata.setDisplayorder(data.getDisplayorder());
            olddata.setInuse(data.getInuse());
            olddata.setRemark(data.getRemark());
            this.advsDaoImpl.updateAdvs(olddata);
        }
    }

    @Override
    public void deleteAdvsById(long seqid) {
        Advs data = IFacadeCommon.INSTANCE.getAdvsById(seqid);
        if (null != data && StringTools.isNotEmpty(data.getPicurl())) {
            this.deleteFile(data);
        }
        this.advsDaoImpl.deleteAdvsById(seqid);
    }

    private void deleteFile(Advs data) {
        String filename = data.getPicurl();
        String path = ApplicationConfigUtil.getRootFilePath() + "upload" + File.separator + data.getFlatno() + File.separator + "advs" + File.separator + "images" + File.separator;
        logger.debug("path=" + path);
        if (filename == null || filename.equals("")) {
            return;
        }
        File file = new File(path + filename);
        if (!file.exists()) {
            logger.debug("\u6587\u4ef6" + filename + "\u4e0d\u5b58\u5728.");
        } else {
            file.delete();
        }
    }

    @Override
    public void deleteAdvs(Advs data) {
        this.advsDaoImpl.deleteAdvs(data);
    }

    @Override
    public Sheet<Advs> queryAdvs(Advs data, PagedFliper fliper) {
        return this.advsDaoImpl.queryAdvs(data, fliper);
    }

    @Override
    public String newAdvid() {
        return this.advsDaoImpl.newAdvid();
    }
}

