/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.util;

import com.xunlei.channel.util.PropertiesReader;
import com.xunlei.server.register.proxy.GameUserException;
import com.xunlei.server.register.proxy.GameUserProxy;
import com.xunlei.server.register.proxy.IGameUserProxy;
import com.xunlei.server.usercentre.vo.ResGameUserInfo;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GameUserUtility {
    private static final Log logger = LogFactory.getLog(GameUserUtility.class);
    private static String gameUserProxyHost;
    private static String gameUserProxyHost2;
    private static int gameUserProxyPort;
    private static int gameUserProxyTimeout;
    private static IGameUserProxy proxy;

    public static String getGameInnerIdByXunleiId(String xunleiId) throws GameUserException {
        ResGameUserInfo user = proxy.getGameUserInfo(xunleiId, 2);
        if (null != user && null != user.getGameUserInfo()) {
            String gameId = user.getGameUserInfo().getGameinternalno();
            return gameId;
        }
        return null;
    }

    public static String getGameInnerIdByUserName(String userName, String userType) throws GameUserException {
        ResGameUserInfo user = proxy.getGameUserInfo(userName, Integer.parseInt(userType));
        if (null != user && null != user.getGameUserInfo()) {
            String gameId = user.getGameUserInfo().getGameinternalno();
            return gameId;
        }
        return null;
    }

    static {
        try {
            PropertiesReader propReader = new PropertiesReader("xlchannelusersrv.properties");
            gameUserProxyHost = propReader.getProperty("game.user.proxy.host");
            gameUserProxyHost2 = propReader.getProperty("game.user.proxy.host2");
            gameUserProxyPort = Integer.parseInt(propReader.getProperty("game.user.proxy.port"));
            gameUserProxyTimeout = Integer.parseInt(propReader.getProperty("game.user.proxy.timeout"));
            proxy = new GameUserProxy(gameUserProxyHost, gameUserProxyPort, gameUserProxyTimeout, gameUserProxyHost2);
        }
        catch (IOException e) {
            logger.error(e);
        }
    }
}

