/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.server.client;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DBConnectionManager {
    private static final Log logger = LogFactory.getLog(DBConnectionManager.class);
    private static DBConnectionManager instance;
    public static Connection conn;
    private static String fileName;

    public static synchronized DBConnectionManager getInstance() {
        if (instance == null) {
            instance = new DBConnectionManager();
        }
        return instance;
    }

    private DBConnectionManager() {
        try {
            this.initJndi();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void initJndi() throws IOException {
        System.setProperty("java.naming.factory.initial", "com.xunlei.org.apache.naming.java.javaURLContextFactory");
        System.setProperty("java.naming.factory.url.pkgs", "com.xunlei.org.apache.naming");
        Properties prop = new Properties();
        String jndiname = "xlchanneldb";
        InputStream is = Object.class.getResourceAsStream(fileName);
        prop.load(is);
        if (is != null) {
            is.close();
        }
        String url = prop.getProperty("pool.url");
        String user = prop.getProperty("pool.user");
        String pwd = prop.getProperty("pool.password");
        BasicDataSource source = new BasicDataSource();
        source.setDriverClassName("com.mysql.jdbc.Driver");
        source.setUrl(url);
        source.setUsername(user);
        source.setPassword(pwd);
        try {
            InitialContext context = new InitialContext();
            Context contextjdbc = context.createSubcontext("java:comp").createSubcontext("env").createSubcontext("jdbc");
            contextjdbc.rebind(jndiname, (Object)source);
            logger.info("bind datasourse success..");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Connection getDBConnection() {
        try {
            if (null == conn || conn.isClosed()) {
                InitialContext initcont = new InitialContext();
                String contextPath = "java:comp/env/jdbc/xlchanneldb";
                DataSource ds = (DataSource)initcont.lookup(contextPath);
                conn = ds.getConnection();
                logger.info("get new connection");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return conn;
    }

    public static void main(String[] args) throws SQLException {
        DBConnectionManager db2 = DBConnectionManager.getInstance();
        Connection conn2 = db2.getDBConnection();
        String sql = "select count(1) from accountitem";
        Statement stmt = conn2.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        while (rs.next()) {
            System.out.println(rs.getInt(1));
        }
    }

    static {
        conn = null;
        fileName = "/dbjndi.properties";
    }
}

