/*
 * Decompiled with CFR 0.152.
 */
package com.ferret.common.dao.util;

import com.ferret.common.dao.annotation.Column;
import com.ferret.common.dao.annotation.Exclude;
import com.ferret.common.dao.annotation.Table;
import com.ferret.common.dao.enums.Operator;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class DaoUtil {
    public static <T> String getTableName(Class<T> clazz) {
        Table table = clazz.getAnnotation(Table.class);
        if (table == null) {
            return clazz.getSimpleName();
        }
        String tableName = table.tableName();
        if (tableName == null || "".equals(tableName)) {
            return clazz.getSimpleName();
        }
        return tableName;
    }

    public static <T> Field getDeclaredField(Class<?> clazz, String fieldName) {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> Field getPkField(Class<T> clazz) {
        Table table = clazz.getAnnotation(Table.class);
        if (table == null) {
            return null;
        }
        return DaoUtil.getDeclaredField(clazz, table.pkFieldName());
    }

    public static String getPkColumnName(Class<?> clazz) {
        Field pkField = DaoUtil.getPkField(clazz);
        if (pkField == null) {
            throw new RuntimeException(String.valueOf(clazz.getName()) + " is not have pk column");
        }
        String columnName = DaoUtil.getColumnName(pkField);
        if (columnName == null || "".equals(columnName)) {
            return pkField.getName();
        }
        return columnName;
    }

    public static String getColumnName(Field field) {
        String columnName = "";
        Column column = field.getAnnotation(Column.class);
        if (column != null) {
            columnName = column.columnName();
        }
        if (columnName == null || "".equals(columnName)) {
            return field.getName();
        }
        return columnName;
    }

    public static <T> Object getFiledValue(T obj, Field field) {
        try {
            PropertyDescriptor pd = new PropertyDescriptor(field.getName(), obj.getClass());
            Method method = pd.getReadMethod();
            return method.invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> void setFiledValue(T obj, Field field, Object value) {
        try {
            PropertyDescriptor pd = new PropertyDescriptor(field.getName(), obj.getClass());
            Method method = pd.getWriteMethod();
            method.invoke(obj, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> void getRSObject(ResultSet rs, Class<T> clazz, List<T> rsList) {
        try {
            do {
                Field[] fields;
                T object = clazz.newInstance();
                Field[] fieldArray = fields = clazz.getDeclaredFields();
                int n = fields.length;
                int n2 = 0;
                while (n2 < n) {
                    Column column;
                    Field field = fieldArray[n2];
                    if (!(Modifier.isPublic(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) || field.getAnnotation(Exclude.class) != null || (column = field.getAnnotation(Column.class)) != null && column.isWhereColumn())) {
                        String columnName = DaoUtil.getColumnName(field);
                        Object value = DaoUtil.getColumnValue(rs, field.getType(), columnName);
                        DaoUtil.setFiledValue(object, field, value);
                    }
                    ++n2;
                }
                rsList.add(object);
            } while (rs.next());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getColumnValue(ResultSet rs, Class<?> fieldType, String columnName) throws SQLException {
        if (fieldType == String.class) {
            return rs.getString(columnName);
        }
        if (fieldType == Long.class || fieldType == Long.TYPE) {
            return rs.getLong(columnName);
        }
        if (fieldType == Integer.class || fieldType == Integer.TYPE) {
            return rs.getInt(columnName);
        }
        if (fieldType == Double.class || fieldType == Double.TYPE) {
            return rs.getDouble(columnName);
        }
        if (fieldType == Float.class || fieldType == Float.TYPE) {
            return Float.valueOf(rs.getFloat(columnName));
        }
        if (fieldType == Boolean.class || fieldType == Boolean.TYPE) {
            return rs.getBoolean(columnName);
        }
        if (fieldType == Short.class || fieldType == Short.TYPE) {
            return rs.getShort(columnName);
        }
        if (fieldType == java.util.Date.class) {
            Date date1 = rs.getDate(columnName);
            if (date1 == null) {
                return null;
            }
            return new java.util.Date(date1.getTime());
        }
        if (fieldType == Date.class) {
            return rs.getDate(columnName);
        }
        if (fieldType == Byte.class || fieldType == Byte.TYPE) {
            return rs.getByte(columnName);
        }
        return rs.getObject(columnName);
    }

    public static String createWhere(Object obj, List<Object> paramList) {
        Field[] fields = obj.getClass().getDeclaredFields();
        StringBuilder where = new StringBuilder();
        Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (!Modifier.isPublic(field.getModifiers()) && !Modifier.isStatic(field.getModifiers()) && field.getAnnotation(Exclude.class) == null) {
                Object value = DaoUtil.getFiledValue(obj, field);
                Column column = field.getAnnotation(Column.class);
                if (column != null && column.emptyQuery() || value != null && !"".equals(String.valueOf(value))) {
                    Operator operator = Operator.EQ;
                    if (column != null) {
                        operator = column.operator();
                    }
                    String columnName = DaoUtil.getColumnName(field);
                    where.append("and ").append(DaoUtil.operatorStatement(columnName, operator, value, paramList));
                }
            }
            ++n2;
        }
        String whereSql = where.toString();
        if (whereSql.startsWith("and")) {
            whereSql = whereSql.substring(3);
        }
        if (whereSql.length() > 0) {
            whereSql = " where " + whereSql;
        }
        return whereSql;
    }

    public static String operatorStatement(String columnName, Operator operator, Object value, List<Object> paramList) {
        String operatorStatement = "";
        switch (operator) {
            case EQ: {
                operatorStatement = String.valueOf(columnName) + " =? ";
                break;
            }
            case NE: {
                operatorStatement = String.valueOf(columnName) + " !=? ";
                break;
            }
            case GT: {
                operatorStatement = String.valueOf(columnName) + " >? ";
                break;
            }
            case GE: {
                operatorStatement = String.valueOf(columnName) + " >=? ";
                break;
            }
            case LT: {
                operatorStatement = String.valueOf(columnName) + " <? ";
                break;
            }
            case LE: {
                operatorStatement = String.valueOf(columnName) + " <=? ";
                break;
            }
            case LIKE: {
                operatorStatement = String.valueOf(columnName) + " like ? ";
                break;
            }
            case LLIKE: {
                operatorStatement = String.valueOf(columnName) + " like ? ";
                break;
            }
            case RLIKE: {
                operatorStatement = String.valueOf(columnName) + " like ? ";
                break;
            }
            default: {
                operatorStatement = String.valueOf(columnName) + " =? ";
            }
        }
        paramList.add(value);
        return operatorStatement;
    }
}

