/*
 * Decompiled with CFR 0.152.
 */
package com.ferret.common.dao.util;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;

public class DaoLog {
    private static Logger logger = Logger.getLogger(DaoLog.class.getName());
    public static boolean isPrintSql = false;
    public static boolean isPrintAccessTime = false;
    private long beginTime = System.currentTimeMillis();
    private long entTime = 0L;

    static {
        DaoLog.init();
    }

    public void println(String presql, List<Object> paramList) {
        this.entTime = System.currentTimeMillis();
        StringBuilder sb = new StringBuilder();
        if (isPrintSql) {
            sb.append("sql[").append(presql).append("]");
            if (paramList != null) {
                sb.append("value[");
                for (Object object : paramList) {
                    if (object == null) continue;
                    sb.append(object.toString()).append(",");
                }
                sb.append("]");
            }
        }
        if (isPrintAccessTime) {
            sb.append("time[").append(this.entTime - this.beginTime).append("]");
        }
        if (isPrintSql || isPrintAccessTime) {
            logger.info(sb.toString());
        }
    }

    public void println(String presql) {
        this.println(presql, new ArrayList<Object>());
    }

    private static void init() {
        ResourceBundle rb = null;
        try {
            rb = ResourceBundle.getBundle("ferret_dao");
        }
        catch (Exception e) {
            logger.error(e);
        }
        if (rb != null) {
            try {
                String ps = rb.getString("isPrintSql").trim();
                isPrintSql = "true".equals(ps);
            }
            catch (Exception e) {
                logger.equals(e);
            }
            try {
                String pat = rb.getString("isPrintAccessTime").trim();
                isPrintAccessTime = "true".equals(pat);
            }
            catch (Exception e) {
                logger.equals(e);
            }
        }
    }
}

