/*
 * Decompiled with CFR 0.152.
 */
package com.ferret.common.dao.presql;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.util.DaoUtil;
import com.ferret.common.dao.vo.Order;
import com.ferret.common.dao.vo.Page;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class Select {
    private String preSql = "";
    private List<Object> paramsList = new ArrayList<Object>();

    public Select(Class<?> clazz, Number id) {
        String tableName = DaoUtil.getTableName(clazz);
        String pkColumnName = DaoUtil.getPkColumnName(clazz);
        this.preSql = "select * from " + tableName + " where " + pkColumnName + "=?";
        this.paramsList.add(id);
    }

    public Select(Class<?> clazz, String id) {
        String tableName = DaoUtil.getTableName(clazz);
        String pkColumnName = DaoUtil.getPkColumnName(clazz);
        this.preSql = "select * from " + tableName + " where " + pkColumnName + "=?";
        this.paramsList.add(id);
    }

    public Select(Object obj, Page page) {
        String tableName = DaoUtil.getTableName(obj.getClass());
        String where = DaoUtil.createWhere(obj, this.paramsList);
        String order = this.createOrder(obj, page);
        String limit = this.createLimit(page);
        this.preSql = "select * from " + tableName + where + order + limit;
    }

    public String getPreSql() {
        return this.preSql;
    }

    public List<Object> getParamsList() {
        return this.paramsList;
    }

    public String createLimit(Page page) {
        if (!page.isPage()) {
            return "";
        }
        int start = (page.getPageNo() - 1) * page.getPageSize();
        return " limit " + start + "," + page.getPageSize();
    }

    public String createOrder(Object obj, Page page) {
        if (!page.isOrder()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        List<Order> list = page.getOrderList();
        for (Order order : list) {
            Field field = DaoUtil.getDeclaredField(obj.getClass(), order.getOrderName());
            String columnName = DaoUtil.getColumnName(field);
            sb.append(",").append(columnName);
            if (order.getType() == OrderType.DESC) {
                sb.append(" desc");
                continue;
            }
            sb.append(" asc");
        }
        String orderStr = sb.toString();
        if (orderStr.startsWith(",")) {
            orderStr = orderStr.substring(1);
        }
        if (orderStr.length() > 0) {
            orderStr = " order by " + orderStr;
        }
        return orderStr;
    }
}

