/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.tomcat;

import ch.qos.logback.access.joran.JoranConfigurator;
import ch.qos.logback.access.spi.AccessEvent;
import ch.qos.logback.access.spi.IAccessEvent;
import ch.qos.logback.access.tomcat.TomcatServerAdapter;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.BasicStatusManager;
import ch.qos.logback.core.LifeCycleManager;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.spi.AppenderAttachable;
import ch.qos.logback.core.spi.AppenderAttachableImpl;
import ch.qos.logback.core.spi.FilterAttachable;
import ch.qos.logback.core.spi.FilterAttachableImpl;
import ch.qos.logback.core.spi.FilterReply;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.spi.LogbackLock;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.status.WarnStatus;
import ch.qos.logback.core.util.ExecutorServiceUtil;
import ch.qos.logback.core.util.OptionHelper;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogbackValve
extends ValveBase
implements Lifecycle,
ch.qos.logback.core.Context,
AppenderAttachable<IAccessEvent>,
FilterAttachable<IAccessEvent> {
    public static final String DEFAULT_CONFIG_FILE = "conf" + File.separatorChar + "logback-access.xml";
    private final LifeCycleManager lifeCycleManager = new LifeCycleManager();
    private long birthTime = System.currentTimeMillis();
    LogbackLock configurationLock = new LogbackLock();
    private String name;
    StatusManager sm = new BasicStatusManager();
    Map<String, String> propertyMap = new HashMap<String, String>();
    Map<String, Object> objectMap = new HashMap<String, Object>();
    private FilterAttachableImpl<IAccessEvent> fai = new FilterAttachableImpl();
    AppenderAttachableImpl<IAccessEvent> aai = new AppenderAttachableImpl();
    String filename;
    boolean quiet;
    boolean started;
    boolean alreadySetLogbackStatusManager = false;
    private ExecutorService executorService;

    public LogbackValve() {
        this.putObject("EVALUATOR_MAP", new HashMap());
    }

    public boolean isStarted() {
        return this.started;
    }

    public void startInternal() throws LifecycleException {
        File configFile;
        this.executorService = ExecutorServiceUtil.newExecutorService();
        if (this.filename == null) {
            String tomcatBaseProperty = OptionHelper.getSystemProperty("catalina.base");
            this.filename = tomcatBaseProperty + File.separatorChar + DEFAULT_CONFIG_FILE;
            File baseConfigFile = new File(this.filename);
            if (!baseConfigFile.exists()) {
                String tomcatHomeProperty = OptionHelper.getSystemProperty("catalina.home");
                this.filename = tomcatHomeProperty + File.separatorChar + DEFAULT_CONFIG_FILE;
            }
            this.getStatusManager().add(new InfoStatus("filename property not set. Assuming [" + this.filename + "]", this));
        }
        if ((configFile = new File(this.filename)).exists()) {
            try {
                JoranConfigurator jc = new JoranConfigurator();
                jc.setContext(this);
                jc.doConfigure(this.filename);
            }
            catch (JoranException e) {
                e.printStackTrace();
            }
        } else {
            this.getStatusManager().add(new WarnStatus("[" + this.filename + "] does not exist", this));
        }
        if (!this.quiet) {
            StatusPrinter.print(this.getStatusManager());
        }
        this.started = true;
        this.setState(LifecycleState.STARTING);
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        try {
            if (!this.alreadySetLogbackStatusManager) {
                ServletContext sc;
                this.alreadySetLogbackStatusManager = true;
                Context tomcatContext = request.getContext();
                if (tomcatContext != null && (sc = tomcatContext.getServletContext()) != null) {
                    sc.setAttribute("LOGBACK_STATUS_MANAGER", this.getStatusManager());
                }
            }
            this.getNext().invoke(request, response);
            TomcatServerAdapter adapter = new TomcatServerAdapter(request, response);
            AccessEvent accessEvent = new AccessEvent((HttpServletRequest)request, (HttpServletResponse)response, adapter);
            if (this.getFilterChainDecision(accessEvent) == FilterReply.DENY) {
                return;
            }
            this.aai.appendLoopOnAppenders(accessEvent);
        }
        finally {
            request.removeAttribute("LOGBACK_STATUS_MANAGER");
        }
    }

    protected void stopInternal() throws LifecycleException {
        this.started = false;
        this.setState(LifecycleState.STOPPING);
        this.lifeCycleManager.reset();
        if (this.executorService != null) {
            ExecutorServiceUtil.shutdown(this.executorService);
            this.executorService = null;
        }
    }

    @Override
    public void addAppender(Appender<IAccessEvent> newAppender) {
        this.aai.addAppender(newAppender);
    }

    @Override
    public Iterator<Appender<IAccessEvent>> iteratorForAppenders() {
        return this.aai.iteratorForAppenders();
    }

    @Override
    public Appender<IAccessEvent> getAppender(String name) {
        return this.aai.getAppender(name);
    }

    @Override
    public boolean isAttached(Appender<IAccessEvent> appender) {
        return this.aai.isAttached(appender);
    }

    @Override
    public void detachAndStopAllAppenders() {
        this.aai.detachAndStopAllAppenders();
    }

    @Override
    public boolean detachAppender(Appender<IAccessEvent> appender) {
        return this.aai.detachAppender(appender);
    }

    @Override
    public boolean detachAppender(String name) {
        return this.aai.detachAppender(name);
    }

    public String getInfo() {
        return "Logback's implementation of ValveBase";
    }

    @Override
    public StatusManager getStatusManager() {
        return this.sm;
    }

    public Map<String, String> getPropertyMap() {
        return this.propertyMap;
    }

    @Override
    public void putProperty(String key, String val) {
        this.propertyMap.put(key, val);
    }

    @Override
    public String getProperty(String key) {
        return this.propertyMap.get(key);
    }

    @Override
    public Map<String, String> getCopyOfPropertyMap() {
        return new HashMap<String, String>(this.propertyMap);
    }

    @Override
    public Object getObject(String key) {
        return this.objectMap.get(key);
    }

    @Override
    public void putObject(String key, Object value) {
        this.objectMap.put(key, value);
    }

    @Override
    public void addFilter(Filter<IAccessEvent> newFilter) {
        this.fai.addFilter(newFilter);
    }

    @Override
    public void clearAllFilters() {
        this.fai.clearAllFilters();
    }

    @Override
    public List<Filter<IAccessEvent>> getCopyOfAttachedFiltersList() {
        return this.fai.getCopyOfAttachedFiltersList();
    }

    @Override
    public FilterReply getFilterChainDecision(IAccessEvent event) {
        return this.fai.getFilterChainDecision(event);
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (this.name != null) {
            throw new IllegalStateException("LogbackValve has been already given a name");
        }
        this.name = name;
    }

    @Override
    public long getBirthTime() {
        return this.birthTime;
    }

    @Override
    public Object getConfigurationLock() {
        return this.configurationLock;
    }

    @Override
    public void register(LifeCycle component) {
        this.lifeCycleManager.register(component);
    }

    public void addLifecycleListener(LifecycleListener arg0) {
    }

    public LifecycleListener[] findLifecycleListeners() {
        return new LifecycleListener[0];
    }

    public void removeLifecycleListener(LifecycleListener arg0) {
    }
}

