/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.spi;

import ch.qos.logback.access.servlet.Util;
import ch.qos.logback.access.spi.IAccessEvent;
import ch.qos.logback.access.spi.ServerAdapter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessEvent
implements Serializable,
IAccessEvent {
    private static final long serialVersionUID = 866718993618836343L;
    private static final String EMPTY = "";
    private final transient HttpServletRequest httpRequest;
    private final transient HttpServletResponse httpResponse;
    String requestURI;
    String requestURL;
    String remoteHost;
    String remoteUser;
    String remoteAddr;
    String protocol;
    String method;
    String serverName;
    String requestContent;
    String responseContent;
    long elapsedTime;
    Map<String, String> requestHeaderMap;
    Map<String, String[]> requestParameterMap;
    Map<String, String> responseHeaderMap;
    long contentLength = -1L;
    int statusCode = -1;
    int localPort = -1;
    transient ServerAdapter serverAdapter;
    private long timeStamp = 0L;

    public AccessEvent(HttpServletRequest httpRequest, HttpServletResponse httpResponse, ServerAdapter adapter) {
        this.httpRequest = httpRequest;
        this.httpResponse = httpResponse;
        this.timeStamp = System.currentTimeMillis();
        this.serverAdapter = adapter;
        this.elapsedTime = this.calculateElapsedTime();
    }

    @Override
    public HttpServletRequest getRequest() {
        return this.httpRequest;
    }

    @Override
    public HttpServletResponse getResponse() {
        return this.httpResponse;
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        if (this.timeStamp != 0L) {
            throw new IllegalStateException("timeStamp has been already set for this event.");
        }
        this.timeStamp = timeStamp;
    }

    @Override
    public String getRequestURI() {
        if (this.requestURI == null) {
            this.requestURI = this.httpRequest != null ? this.httpRequest.getRequestURI() : "-";
        }
        return this.requestURI;
    }

    @Override
    public String getRequestURL() {
        if (this.requestURL == null) {
            if (this.httpRequest != null) {
                StringBuilder buf = new StringBuilder();
                buf.append(this.httpRequest.getMethod());
                buf.append(' ');
                buf.append(this.httpRequest.getRequestURI());
                String qStr = this.httpRequest.getQueryString();
                if (qStr != null) {
                    buf.append('?');
                    buf.append(qStr);
                }
                buf.append(' ');
                buf.append(this.httpRequest.getProtocol());
                this.requestURL = buf.toString();
            } else {
                this.requestURL = "-";
            }
        }
        return this.requestURL;
    }

    @Override
    public String getRemoteHost() {
        if (this.remoteHost == null) {
            this.remoteHost = this.httpRequest != null ? this.httpRequest.getRemoteHost() : "-";
        }
        return this.remoteHost;
    }

    @Override
    public String getRemoteUser() {
        if (this.remoteUser == null) {
            this.remoteUser = this.httpRequest != null ? this.httpRequest.getRemoteUser() : "-";
        }
        return this.remoteUser;
    }

    @Override
    public String getProtocol() {
        if (this.protocol == null) {
            this.protocol = this.httpRequest != null ? this.httpRequest.getProtocol() : "-";
        }
        return this.protocol;
    }

    @Override
    public String getMethod() {
        if (this.method == null) {
            this.method = this.httpRequest != null ? this.httpRequest.getMethod() : "-";
        }
        return this.method;
    }

    @Override
    public String getServerName() {
        if (this.serverName == null) {
            this.serverName = this.httpRequest != null ? this.httpRequest.getServerName() : "-";
        }
        return this.serverName;
    }

    @Override
    public String getRemoteAddr() {
        if (this.remoteAddr == null) {
            this.remoteAddr = this.httpRequest != null ? this.httpRequest.getRemoteAddr() : "-";
        }
        return this.remoteAddr;
    }

    @Override
    public String getRequestHeader(String key) {
        String result = null;
        key = key.toLowerCase();
        if (this.requestHeaderMap == null) {
            if (this.httpRequest != null) {
                this.buildRequestHeaderMap();
                result = this.requestHeaderMap.get(key);
            }
        } else {
            result = this.requestHeaderMap.get(key);
        }
        if (result != null) {
            return result;
        }
        return "-";
    }

    @Override
    public Enumeration getRequestHeaderNames() {
        if (this.httpRequest == null) {
            Vector<String> list = new Vector<String>(this.getRequestHeaderMap().keySet());
            return list.elements();
        }
        return this.httpRequest.getHeaderNames();
    }

    @Override
    public Map<String, String> getRequestHeaderMap() {
        if (this.requestHeaderMap == null) {
            this.buildRequestHeaderMap();
        }
        return this.requestHeaderMap;
    }

    public void buildRequestHeaderMap() {
        this.requestHeaderMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        Enumeration e = this.httpRequest.getHeaderNames();
        if (e == null) {
            return;
        }
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            this.requestHeaderMap.put(key, this.httpRequest.getHeader(key));
        }
    }

    public void buildRequestParameterMap() {
        this.requestParameterMap = new HashMap<String, String[]>();
        Enumeration e = this.httpRequest.getParameterNames();
        if (e == null) {
            return;
        }
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            this.requestParameterMap.put(key, this.httpRequest.getParameterValues(key));
        }
    }

    @Override
    public Map<String, String[]> getRequestParameterMap() {
        if (this.requestParameterMap == null) {
            this.buildRequestParameterMap();
        }
        return this.requestParameterMap;
    }

    @Override
    public String getAttribute(String key) {
        if (this.httpRequest != null) {
            Object value = this.httpRequest.getAttribute(key);
            if (value == null) {
                return "-";
            }
            return value.toString();
        }
        return "-";
    }

    @Override
    public String[] getRequestParameter(String key) {
        if (this.httpRequest != null) {
            String[] value = this.httpRequest.getParameterValues(key);
            if (value == null) {
                return new String[]{"-"};
            }
            return value;
        }
        return new String[]{"-"};
    }

    @Override
    public String getCookie(String key) {
        if (this.httpRequest != null) {
            Cookie[] cookieArray = this.httpRequest.getCookies();
            if (cookieArray == null) {
                return "-";
            }
            for (Cookie cookie : cookieArray) {
                if (!key.equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return "-";
    }

    @Override
    public long getContentLength() {
        if (this.contentLength == -1L && this.httpResponse != null) {
            this.contentLength = this.serverAdapter.getContentLength();
            return this.contentLength;
        }
        return this.contentLength;
    }

    @Override
    public int getStatusCode() {
        if (this.statusCode == -1 && this.httpResponse != null) {
            this.statusCode = this.serverAdapter.getStatusCode();
        }
        return this.statusCode;
    }

    @Override
    public long getElapsedTime() {
        return this.elapsedTime;
    }

    private long calculateElapsedTime() {
        if (this.serverAdapter.getRequestTimestamp() < 0L) {
            return -1L;
        }
        return this.getTimeStamp() - this.serverAdapter.getRequestTimestamp();
    }

    @Override
    public String getRequestContent() {
        if (this.requestContent != null) {
            return this.requestContent;
        }
        if (Util.isFormUrlEncoded(this.httpRequest)) {
            StringBuilder buf = new StringBuilder();
            Enumeration pramEnumeration = this.httpRequest.getParameterNames();
            int count = 0;
            try {
                while (pramEnumeration.hasMoreElements()) {
                    String key = (String)pramEnumeration.nextElement();
                    if (count++ != 0) {
                        buf.append("&");
                    }
                    buf.append(key);
                    buf.append("=");
                    String val = this.httpRequest.getParameter(key);
                    if (val != null) {
                        buf.append(val);
                        continue;
                    }
                    buf.append(EMPTY);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.requestContent = buf.toString();
        } else {
            byte[] inputBuffer = (byte[])this.httpRequest.getAttribute("LB_INPUT_BUFFER");
            if (inputBuffer != null) {
                this.requestContent = new String(inputBuffer);
            }
            if (this.requestContent == null || this.requestContent.length() == 0) {
                this.requestContent = EMPTY;
            }
        }
        return this.requestContent;
    }

    @Override
    public String getResponseContent() {
        if (this.responseContent != null) {
            return this.responseContent;
        }
        if (Util.isImageResponse(this.httpResponse)) {
            this.responseContent = "[IMAGE CONTENTS SUPPRESSED]";
        } else {
            byte[] outputBuffer = (byte[])this.httpRequest.getAttribute("LB_OUTPUT_BUFFER");
            if (outputBuffer != null) {
                this.responseContent = new String(outputBuffer);
            }
            if (this.responseContent == null || this.responseContent.length() == 0) {
                this.responseContent = EMPTY;
            }
        }
        return this.responseContent;
    }

    @Override
    public int getLocalPort() {
        if (this.localPort == -1 && this.httpRequest != null) {
            this.localPort = this.httpRequest.getLocalPort();
        }
        return this.localPort;
    }

    @Override
    public ServerAdapter getServerAdapter() {
        return this.serverAdapter;
    }

    @Override
    public String getResponseHeader(String key) {
        this.buildResponseHeaderMap();
        return this.responseHeaderMap.get(key);
    }

    void buildResponseHeaderMap() {
        if (this.responseHeaderMap == null) {
            this.responseHeaderMap = this.serverAdapter.buildResponseHeaderMap();
        }
    }

    @Override
    public Map<String, String> getResponseHeaderMap() {
        this.buildResponseHeaderMap();
        return this.responseHeaderMap;
    }

    @Override
    public List<String> getResponseHeaderNameList() {
        this.buildResponseHeaderMap();
        return new ArrayList<String>(this.responseHeaderMap.keySet());
    }

    @Override
    public void prepareForDeferredProcessing() {
        this.buildRequestHeaderMap();
        this.buildRequestParameterMap();
        this.buildResponseHeaderMap();
        this.getLocalPort();
        this.getMethod();
        this.getProtocol();
        this.getRemoteAddr();
        this.getRemoteHost();
        this.getRemoteUser();
        this.getRequestURI();
        this.getRequestURL();
        this.getServerName();
        this.getTimeStamp();
        this.getElapsedTime();
        this.getStatusCode();
        this.getContentLength();
        this.getRequestContent();
        this.getResponseContent();
    }
}

