/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.jinzuan.api;

import com.xunlei.netty.soaserver.client.SOAClientFactory;
import com.xunlei.niux.jinzuan.api.IGrowService;
import com.xunlei.niux.jinzuan.api.IMemberService;
import com.xunlei.niux.jinzuan.api.IPrivilegeService;
import com.xunlei.niux.jinzuan.api.ISignService;
import java.io.IOException;
import java.util.Properties;

public class ServiceFactory {
    public static final ServiceFactory INSTANCE = new ServiceFactory();
    private static final String appName = "xlniuxjinzuan";
    private IMemberService memberService;
    private IGrowService growService;
    private IPrivilegeService privilegeService;
    private ISignService signService;

    public ServiceFactory() {
        SOAClientFactory soaClient = this.getSOAClientFactory();
        this.memberService = (IMemberService)soaClient.getObject(IMemberService.class);
        this.growService = (IGrowService)soaClient.getObject(IGrowService.class);
        this.privilegeService = (IPrivilegeService)soaClient.getObject(IPrivilegeService.class);
        this.signService = (ISignService)soaClient.getObject(ISignService.class);
    }

    private SOAClientFactory getSOAClientFactory() {
        Properties config = this.getServiceClientProperties();
        SOAClientFactory soaClient = new SOAClientFactory();
        soaClient.setAppName(appName);
        soaClient.setServiceHost(config.getProperty("ServiceHost"));
        soaClient.setServicePort(Integer.parseInt(config.getProperty("ServicePort")));
        return soaClient;
    }

    private Properties getServiceClientProperties() {
        Properties config = new Properties();
        try {
            config.load(ServiceFactory.class.getClassLoader().getResourceAsStream("com/xunlei/niux/jinzuan/api/properties/serviceClient.properties"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return config;
    }

    public IMemberService getMemberService() {
        return this.memberService;
    }

    public IGrowService getGrowService() {
        return this.growService;
    }

    public IPrivilegeService getPrivilegeService() {
        return this.privilegeService;
    }

    public ISignService getSignService() {
        return this.signService;
    }
}

