/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.newplayercard.dao;

import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.newplayercard.dao.BaseDao;
import com.xunlei.newplayercard.dao.IKeyRuleDao;
import com.xunlei.newplayercard.vo.KeyRule;
import java.util.Collection;
import org.apache.log4j.Logger;

public class KeyRuleDaoImpl
extends BaseDao
implements IKeyRuleDao {
    private static Logger log = Logger.getLogger(KeyRuleDaoImpl.class);

    @Override
    public void delete(KeyRule data) {
        this.deleteObject(data);
    }

    @Override
    public void deleteByIds(long ... ids) {
        this.deleteObject("keyrule", ids);
    }

    @Override
    public KeyRule find(KeyRule data) {
        return (KeyRule)this.findObjectByCondition(data);
    }

    @Override
    public KeyRule findById(long id) {
        KeyRule data = new KeyRule();
        data.setSeqid(id);
        return this.find(data);
    }

    @Override
    public Sheet<KeyRule> query(KeyRule data, PagedFliper fliper) {
        String sql = "select * from keyrule ";
        String countsql = "select count(1) from keyrule ";
        StringBuilder where = new StringBuilder(" where 1=1 ");
        if (null != data) {
            if (this.isNotEmpty(data.getGameid())) {
                where.append(" And gameid='").append(data.getGameid()).append("'");
            }
            if (this.isNotEmpty(data.getGamename())) {
                where.append(" And gamename='").append(data.getGamename()).append("'");
            }
            if (this.isNotEmpty(data.getRuleid())) {
                where.append(" And ruleid='").append(data.getRuleid()).append("'");
            }
            if (this.isNotEmpty(data.getRulename())) {
                where.append(" And rulename='").append(data.getRulename()).append("'");
            }
            if (data.getRuletype() != 0) {
                where.append(" And ruletype=").append(data.getRuletype()).append("");
            }
            if (this.isNotEmpty(data.getRemark())) {
                where.append(" And remark='").append(data.getRemark()).append("'");
            }
            if (this.isNotEmpty(data.getBegintime())) {
                where.append(" And inputtime>='").append(data.getBegintime()).append("'");
            }
            if (this.isNotEmpty(data.getEdittime())) {
                where.append(" And inputtime<='").append(data.getEndtime()).append("'");
            }
        }
        countsql = countsql + where.toString();
        log.info((Object)countsql);
        int rowcount = this.getSingleInt(countsql);
        if (rowcount <= 0) {
            return Sheet.EMPTY;
        }
        sql = sql + where.toString();
        log.info((Object)sql);
        if (fliper != null) {
            if (this.isNotEmpty(fliper.getSortColumn())) {
                sql = sql + " order by " + fliper.getSortColumn();
            }
            sql = sql + fliper.limitsql(rowcount);
        }
        return new Sheet(rowcount, (Collection)this.query(KeyRule.class, sql, new String[0]));
    }

    @Override
    public void save(KeyRule data) {
        String maxruleidsql = "select max(ruleid) from keyrule";
        int maxruleid = this.str2int(this.getSingleString(maxruleidsql));
        String newruleid = String.valueOf(maxruleid + 1);
        data.setRuleid(newruleid);
        this.saveObject(data);
        String tablename = "keyinfo_" + newruleid;
        String droptablesql = "drop table if exists " + tablename;
        String uniqueKey = "";
        if (!"1".equals(data.getSameCdkey())) {
            uniqueKey = " , UNIQUE KEY key_serverid (cdkey,serverid)";
        }
        String createtablesql = "create table " + tablename + "(" + " seqid bigint(20) NOT NULL auto_increment," + " ruleid varchar(20) NOT NULL default ''," + " batid varchar(20) NOT NULL default ''," + " cdkey varchar(100) NOT NULL default ''," + " fromdate varchar(19) NOT NULL default ''," + " todate varchar(19) NOT NULL default ''," + " getuserid varchar(20) NOT NULL default ''," + " getloginname varchar(20) NOT NULL default ''," + " gettime varchar(19) NOT NULL default ''," + " getip varchar(15) NOT NULL default ''," + " state smallint(6) NOT NULL default '-1'," + " phone varchar(11) NOT NULL default ''," + " creditid varchar(30) NOT NULL default ''," + " qq varchar(30) NOT NULL default ''," + " email varchar(100) NOT NULL default ''," + " truename varchar(30) NOT NULL default ''," + " remark varchar(255) NOT NULL default ''," + " inputby varchar(30) NOT NULL default ''," + " inputtime varchar(19) NOT NULL default ''," + " editby varchar(30) NOT NULL default ''," + " edittime varchar(19) NOT NULL default ''," + " serverid varchar(19) NOT NULL default ''," + " PRIMARY KEY  (seqid)" + uniqueKey + " ) ENGINE=INNODB DEFAULT CHARSET=utf8";
        try {
            this.execute(droptablesql);
        }
        catch (Exception e) {
            log.error((Object)("drop talbe [" + tablename + "] failed:" + e.getMessage()));
        }
        try {
            this.execute(createtablesql);
        }
        catch (Exception e) {
            log.error((Object)("createsql:" + createtablesql));
            log.error((Object)("Create talbe [" + tablename + "] failed:" + e.getMessage()));
        }
    }

    @Override
    public void update(KeyRule data) {
        this.updateObject(data);
    }
}

