/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.newplayercard.dao;

import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.newplayercard.dao.BaseDao;
import com.xunlei.newplayercard.dao.IKeyInfoDao;
import com.xunlei.newplayercard.dto.KeyCount;
import com.xunlei.newplayercard.vo.KeyInfo;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.jdbc.core.RowMapper;

public class KeyInfoDaoImpl
extends BaseDao
implements IKeyInfoDao {
    private static Logger log = Logger.getLogger(KeyInfoDaoImpl.class);
    private static final String TAB_PREFIX = "keyinfo_";

    @Override
    public void delete(KeyInfo data) {
        if (this.isEmpty(data.getRuleid())) {
            log.error((Object)"ruleid is empty,can't delete.");
            return;
        }
        String tablename = TAB_PREFIX + data.getRuleid();
        String deletesql = "delete from " + tablename;
        StringBuffer wheresql = new StringBuffer(" where 1=1");
        if (null != data) {
            if (this.isNotEmpty(data.getRuleid())) {
                wheresql.append(" And ruleid='").append(data.getRuleid()).append("'");
            }
            if (this.isNotEmpty(data.getBatid())) {
                wheresql.append(" And batid='").append(data.getBatid()).append("'");
            }
            if (this.isNotEmpty(data.getCdkey())) {
                wheresql.append(" And cdkey='").append(data.getCdkey()).append("'");
            }
            if (this.isNotEmpty(data.getGetuserid())) {
                wheresql.append(" And getuserid='").append(data.getGetuserid()).append("'");
            }
            if (this.isNotEmpty(data.getGetloginname())) {
                wheresql.append(" And getloginname='").append(data.getGetloginname()).append("'");
            }
            if (this.isNotEmpty(data.getServerid())) {
                wheresql.append(" And serverid='").append(data.getServerid()).append("'");
            }
        }
        deletesql = deletesql + wheresql.toString();
        log.debug((Object)deletesql);
        this.execute(deletesql);
    }

    @Override
    public void deleteByIds(long[] ids, String ruleid) {
        String tablename = TAB_PREFIX + ruleid;
        String delsql = "delete from " + tablename + " where seqid = ";
        for (long id : ids) {
            log.debug((Object)(delsql + id));
            this.execute(delsql + id);
        }
    }

    @Override
    public KeyInfo find(KeyInfo data) {
        String tablename = TAB_PREFIX + data.getRuleid();
        String sql = "select * from " + tablename;
        String sqlcount = "select count(1) from " + tablename;
        StringBuffer wheresql = new StringBuffer(" where 1=1");
        if (null != data) {
            if (data.getSeqid() > 0L) {
                wheresql.append(" And seqid=").append(data.getSeqid()).append("");
            }
            if (this.isNotEmpty(data.getRuleid())) {
                wheresql.append(" And ruleid='").append(data.getRuleid()).append("'");
            }
            if (this.isNotEmpty(data.getBatid())) {
                wheresql.append(" And batid='").append(data.getBatid()).append("'");
            }
            if (this.isNotEmpty(data.getCdkey())) {
                wheresql.append(" And cdkey='").append(data.getCdkey()).append("'");
            }
            if (this.isNotEmpty(data.getGetuserid())) {
                wheresql.append(" And getuserid='").append(data.getGetuserid()).append("'");
            }
            if (this.isNotEmpty(data.getGetloginname())) {
                wheresql.append(" And getloginname='").append(data.getGetloginname()).append("'");
            }
            if (data.getState() != 0) {
                wheresql.append(" And state=").append(data.getState()).append("");
            }
            if (this.isNotEmpty(data.getServerid())) {
                wheresql.append(" And serverid='").append(data.getServerid()).append("'");
            }
        }
        sqlcount = sqlcount + wheresql.toString();
        log.debug((Object)sqlcount);
        int rowcount = this.getSingleInt(sqlcount);
        if (rowcount == 1) {
            sql = sql + wheresql.toString();
            log.debug((Object)sql);
            return (KeyInfo)this.queryOne(KeyInfo.class, sql, new String[0]);
        }
        return null;
    }

    @Override
    public KeyInfo findById(long id, String ruleid) {
        KeyInfo data = new KeyInfo();
        data.setSeqid(id);
        data.setRuleid(ruleid);
        return this.find(data);
    }

    @Override
    public Sheet<KeyInfo> query(KeyInfo data, PagedFliper fliper) {
        String tablename = TAB_PREFIX + data.getRuleid();
        String sql = "select * from " + tablename;
        String sqlcount = "select count(1) from " + tablename;
        StringBuffer wheresql = new StringBuffer(" where 1=1");
        if (null != data) {
            if (data.getSeqid() > 0L) {
                wheresql.append(" And seqid=").append(data.getSeqid()).append("");
            }
            if (this.isNotEmpty(data.getRuleid())) {
                wheresql.append(" And ruleid='").append(data.getRuleid()).append("'");
            }
            if (this.isNotEmpty(data.getBatid())) {
                wheresql.append(" And batid='").append(data.getBatid()).append("'");
            }
            if (this.isNotEmpty(data.getCdkey())) {
                wheresql.append(" And cdkey='").append(data.getCdkey()).append("'");
            }
            if (this.isNotEmpty(data.getGetuserid())) {
                wheresql.append(" And getuserid='").append(data.getGetuserid()).append("'");
            }
            if (this.isNotEmpty(data.getGetloginname())) {
                wheresql.append(" And getloginname='").append(data.getGetloginname()).append("'");
            }
            if (data.getState() != 0) {
                wheresql.append(" And state=").append(data.getState()).append("");
            }
            if (this.isNotEmpty(data.getRemark())) {
                wheresql.append(" And remark='").append(data.getRemark()).append("'");
            }
            if (this.isNotEmpty(data.getServerid())) {
                wheresql.append(" And serverid='").append(data.getServerid()).append("'");
            }
        }
        sqlcount = sqlcount + wheresql.toString();
        log.debug((Object)sqlcount);
        int rowcount = this.getSingleInt(sqlcount);
        if (rowcount <= 0) {
            return Sheet.EMPTY;
        }
        sql = sql + wheresql.toString();
        if (fliper != null) {
            if (this.isNotEmpty(fliper.getSortColumn())) {
                sql = sql + " order by " + fliper.getSortColumn();
            }
            sql = sql + fliper.limitsql(rowcount);
        }
        return new Sheet(rowcount, (Collection)this.query(KeyInfo.class, sql, new String[0]));
    }

    @Override
    public void save(KeyInfo data) {
        String tablename = TAB_PREFIX + data.getRuleid();
        String savesql = "insert into " + tablename + "(ruleid,batid,cdkey,fromdate,todate,state,serverid) values('" + data.getRuleid() + "','" + data.getBatid() + "','" + data.getCdkey() + "','" + data.getFromdate() + "','" + data.getTodate() + "','" + data.getState() + "','" + data.getServerid() + "')";
        log.debug((Object)("save sql:" + savesql));
        try {
            this.execute(savesql);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void update(KeyInfo data) {
    }

    @Override
    public void deleteKeyAll(int type, String batid, String ruleid) throws Exception {
        if (this.isEmpty(batid) || this.isEmpty(ruleid)) {
            throw new XLRuntimeException("\u5361\u5bc6\u6216\u6279\u6b21\u4e3a\u7a7a");
        }
        String tablename = TAB_PREFIX + ruleid;
        String deletesql = "delete from " + tablename;
        StringBuffer wheresql = new StringBuffer(" where 1=1");
        wheresql.append(" And ruleid='").append(ruleid).append("'").append(" And batid='").append(batid).append("'");
        if (type == -1 || type == 1) {
            wheresql.append(" And state=").append(type).append("");
        }
        deletesql = deletesql + wheresql.toString();
        log.debug((Object)("keyinfo  deleteKeyAll  deletesql===>" + deletesql));
        log.debug((Object)("keyinfo  deleteKeyAll  deletesql===>" + deletesql));
        this.execute(deletesql);
    }

    @Override
    public boolean isBatchEnoughToSend(String ruleId, String batId, int num) {
        if (this.isEmpty(batId) || this.isEmpty(ruleId)) {
            throw new XLRuntimeException("\u5361\u5bc6\u6216\u6279\u6b21\u4e3a\u7a7a");
        }
        String tablename = TAB_PREFIX + ruleId;
        StringBuffer sql = new StringBuffer("select count(*) from ");
        sql.append(tablename);
        sql.append(" where batid=");
        sql.append(batId);
        sql.append(" and state=-1");
        int batCount = this.getSingleInt(sql.toString());
        return batCount >= num;
    }

    @Override
    public List<String> getActivationCodes(String ruleId, String batId, int num) {
        String tablename = TAB_PREFIX + ruleId;
        StringBuffer sql = new StringBuffer("select cdkey from ");
        sql.append(tablename);
        sql.append(" where batid=");
        sql.append(batId);
        sql.append(" and state=-1");
        sql.append(" limit 0, ");
        sql.append(num);
        List lists = this.queryToList(sql.toString());
        return lists;
    }

    @Override
    public void updateKeyInfoState(String ruleId, String batId, Map<String, String> succMap) {
        String tablename = TAB_PREFIX + ruleId;
        for (Map.Entry<String, String> entry : succMap.entrySet()) {
            StringBuffer sql = new StringBuffer("update ");
            sql.append(tablename);
            sql.append(" set state = 1,");
            sql.append(" getuserid=");
            sql.append(entry.getKey());
            sql.append(" where batid=");
            sql.append(batId);
            sql.append(" and cdkey=");
            sql.append("'" + entry.getValue() + "'");
            this.execute(sql.toString());
        }
    }

    @Override
    public List<KeyCount> findByBatIdIn(String ruleId, String batids) {
        String tablename = TAB_PREFIX + ruleId;
        batids = this.getBatids(batids);
        String sql = "SELECT batid,count(1) count from  " + tablename + " where batid in (" + batids + ")  and state =1  GROUP BY batid ";
        return this.getJdbcTemplate().query(sql, new RowMapper(){

            public KeyCount mapRow(ResultSet resultSet, int i) throws SQLException {
                KeyCount keyCount = new KeyCount();
                keyCount.setBatid(resultSet.getString("batid") == null ? "" : resultSet.getString("batid"));
                keyCount.setCount(resultSet.getInt("count"));
                return keyCount;
            }
        });
    }

    @Override
    public List<KeyInfo> findByUidAndBatIdIn(String ruleId, String uid, String batids) {
        String tablename = TAB_PREFIX + ruleId;
        batids = this.getBatids(batids);
        String sql = "SELECT * from  " + tablename + " where getuserid='" + uid + "' and batid in (" + batids + ") ";
        return this.getJdbcTemplate().query(sql, new RowMapper(){

            public Object mapRow(ResultSet rs, int i) throws SQLException {
                KeyInfo keyInfo = new KeyInfo();
                keyInfo.setSeqid(rs.getLong("seqid"));
                keyInfo.setRuleid(rs.getString("ruleid") == null ? "" : rs.getString("ruleid"));
                keyInfo.setBatid(rs.getString("batid") == null ? "" : rs.getString("batid"));
                keyInfo.setCdkey(rs.getString("cdkey") == null ? "" : rs.getString("cdkey"));
                keyInfo.setFromdate(rs.getString("fromdate") == null ? "" : rs.getString("fromdate"));
                keyInfo.setTodate(rs.getString("todate") == null ? "" : rs.getString("todate"));
                keyInfo.setGetuserid(rs.getString("getuserid") == null ? "" : rs.getString("getuserid"));
                keyInfo.setGetloginname(rs.getString("getloginname") == null ? "" : rs.getString("getloginname"));
                keyInfo.setGettime(rs.getString("gettime") == null ? "" : rs.getString("gettime"));
                keyInfo.setGetip(rs.getString("getip") == null ? "" : rs.getString("getip"));
                keyInfo.setState(rs.getInt("state"));
                keyInfo.setPhone(rs.getString("phone") == null ? "" : rs.getString("phone"));
                keyInfo.setCreditid(rs.getString("creditid") == null ? "" : rs.getString("creditid"));
                keyInfo.setQq(rs.getString("qq") == null ? "" : rs.getString("qq"));
                keyInfo.setEmail(rs.getString("email") == null ? "" : rs.getString("email"));
                keyInfo.setTruename(rs.getString("truename") == null ? "" : rs.getString("truename"));
                keyInfo.setRemark(rs.getString("remark") == null ? "" : rs.getString("remark"));
                keyInfo.setInputby(rs.getString("inputby") == null ? "" : rs.getString("inputby"));
                keyInfo.setInputtime(rs.getString("inputtime") == null ? "" : rs.getString("inputtime"));
                keyInfo.setEditby(rs.getString("editby") == null ? "" : rs.getString("editby"));
                keyInfo.setEdittime(rs.getString("edittime") == null ? "" : rs.getString("edittime"));
                keyInfo.setServerid(rs.getString("serverid") == null ? "" : rs.getString("serverid"));
                return keyInfo;
            }
        });
    }

    private String getBatids(String batids) {
        if (batids.endsWith(",")) {
            batids = batids.substring(0, batids.length() - 1);
        }
        if (!batids.contains("'")) {
            batids = "'" + batids.replace(",", "','") + "'";
        }
        return batids;
    }
}

