/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.newplayercard.web.model;

import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.newplayercard.facade.IFacade;
import com.xunlei.newplayercard.vo.KeyRule;
import com.xunlei.newplayercard.web.model.BaseManageBean;
import java.util.HashMap;
import java.util.Map;
import javax.faces.model.SelectItem;
import org.apache.log4j.Logger;

@FunRef(value="playercardkeyrule")
public class KeyRuleManageBean
extends BaseManageBean {
    private static Logger log = Logger.getLogger(KeyRuleManageBean.class);
    private static IFacade facade = IFacade.INSTANCE;
    private static Map<String, String> ruletypeMap;
    private static SelectItem[] ruletypeItems;

    public String getQueryKeyRule() {
        log.info((Object)"Start query keyrule ...");
        this.authenticateRun();
        KeyRule query = (KeyRule)this.findBean(KeyRule.class, "keyrule_query");
        if (null != query) {
            PagedFliper fliper = this.getFliper();
            fliper.setSortColumnIfEmpty("inputTime desc");
            Sheet<KeyRule> sheet = facade.queryKeyRule(query, fliper);
            this.mergePagedDataModel(sheet, new PagedFliper[]{fliper});
        }
        log.info((Object)"Query keyrule over");
        return "";
    }

    public String add() {
        log.info((Object)"Start add keyrule...");
        this.authenticateAdd();
        KeyRule data = (KeyRule)this.findBean(KeyRule.class, "keyrule_data");
        log.info((Object)("gameid:" + data.getGameid() + ",gamename:" + data.getGamename()));
        log.info((Object)("ruleid:" + data.getRuleid() + ",rulename:" + data.getRulename()));
        data.setInputtime(this.now());
        data.setInputby(this.currentUserLogo());
        if (data.getKeysize() == 0) {
            data.setKeysize(100);
        }
        try {
            facade.saveKeyRule(data);
        }
        catch (XLRuntimeException e) {
            log.error((Object)("Add keyrule error:" + e.getMessage()));
            this.mergeBean(e.getMessage(), "jsmessage");
        }
        log.info((Object)"Add keyrule over.");
        this.getQueryKeyRule();
        return "";
    }

    public String edit() {
        log.info((Object)"Start edit keyrule...");
        this.authenticateEdit();
        KeyRule data = (KeyRule)this.findBean(KeyRule.class, "keyrule_data");
        log.info((Object)("gameid:" + data.getGameid() + ",gamename:" + data.getGamename()));
        log.info((Object)("ruleid:" + data.getRuleid() + ",rulename:" + data.getRulename()));
        data.setEditby(this.currentUserLogo());
        data.setEdittime(this.now());
        if (data.getKeysize() == 0) {
            data.setKeysize(20);
        }
        try {
            facade.updateKeyRule(data);
        }
        catch (XLRuntimeException e) {
            log.info((Object)("Edit keyrule error:" + e.getMessage()));
            this.mergeBean(e.getMessage(), "jsmessage");
        }
        log.info((Object)"Edit keyrule over.");
        this.getQueryKeyRule();
        return "";
    }

    public String deleteSome() {
        log.info((Object)"Start delete keyrule...");
        long[] ids = this.findParamSeqids();
        try {
            facade.deleteKeyRuleByIds(ids);
        }
        catch (XLRuntimeException e) {
            log.error((Object)("Delete key rule error:" + e.getMessage()));
            this.mergeBean(e.getMessage(), "jsmessage");
        }
        log.info((Object)"Delete keyrule over.");
        this.getQueryKeyRule();
        return "";
    }

    public Map<String, String> getRuletypeMap() {
        if (ruletypeMap == null) {
            ruletypeMap = new HashMap<String, String>();
            ruletypeMap.put("1", "\u968f\u673a");
            ruletypeMap.put("2", "\u9996\u5b57\u6bcd+\u968f\u673a");
        }
        return ruletypeMap;
    }

    public SelectItem[] getRuletypeItems() {
        ruletypeItems = new SelectItem[2];
        KeyRuleManageBean.ruletypeItems[0] = new SelectItem((Object)"1", "\u968f\u673a");
        KeyRuleManageBean.ruletypeItems[1] = new SelectItem((Object)"2", "\u9996\u5b57\u6bcd+\u968f\u673a");
        return ruletypeItems;
    }
}

