/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.newplayercard.web.model;

import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.newplayercard.facade.IFacade;
import com.xunlei.newplayercard.vo.KeyBatch;
import com.xunlei.newplayercard.vo.KeyInfo;
import com.xunlei.newplayercard.vo.KeyRule;
import com.xunlei.newplayercard.web.model.BaseManageBean;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GameServers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.model.SelectItem;
import org.apache.log4j.Logger;

@FunRef(value="playercardkeyrule")
public class KeyInfoManageBean
extends BaseManageBean {
    private static Logger log = Logger.getLogger(KeyInfoManageBean.class);
    private static IFacade facade = IFacade.INSTANCE;
    private static Map<Integer, String> statusMap;
    private static SelectItem[] statusItems;

    public String getQueryKeyInfo() {
        log.debug((Object)"Start query keyinfo ...");
        KeyInfo query = (KeyInfo)this.findBean(KeyInfo.class, "keyinfo_query");
        KeyBatch keybatch = (KeyBatch)this.findBean(KeyBatch.class, "keybatch2");
        log.info((Object)("ruleid:" + keybatch.getRuleid() + ",batid:" + keybatch.getBatid()));
        query.setBatid(keybatch.getBatid());
        query.setRuleid(keybatch.getRuleid());
        PagedFliper fliper = this.getFliper();
        fliper.setSortColumnIfEmpty("inputtime desc");
        Sheet<KeyInfo> sheet = facade.queryKeyInfo(query, fliper);
        this.mergePagedDataModel(sheet, new PagedFliper[]{fliper});
        log.debug((Object)"Query keyinfo over.");
        return "";
    }

    public String deleteSome() {
        log.debug((Object)"Start delete some keyinfo ...");
        long[] ids = this.findParamSeqids();
        KeyBatch keybatch = (KeyBatch)this.findBean(KeyBatch.class, "keybatch2");
        log.info((Object)("ruleid:" + keybatch.getRuleid() + ",batid:" + keybatch.getBatid() + ",ids:" + ids));
        KeyBatch querykeybatch = new KeyBatch();
        querykeybatch.setBatid(keybatch.getBatid());
        querykeybatch.setRuleid(keybatch.getRuleid());
        KeyBatch result = facade.findKeyBatch(querykeybatch);
        facade.deleteKeyInfoByIds(ids, keybatch.getRuleid());
        result.setKeynum(result.getKeynum() - ids.length);
        facade.updateKeyBatch(result);
        log.debug((Object)"Delete keyinfo over.");
        return "";
    }

    public String deleteAll() {
        log.debug((Object)"start delete All keyinfo ...");
        KeyBatch keybatch = (KeyBatch)this.findBean(KeyBatch.class, "keybatch2");
        String batid = keybatch.getBatid();
        String ruleid = keybatch.getRuleid();
        try {
            int type = this.findParamInt("type");
            if (this.isEmpty(batid)) {
                throw new XLRuntimeException("\u5361\u5bc6\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u5220\u9664");
            }
            if (this.isEmpty(ruleid)) {
                throw new XLRuntimeException("\u6279\u6b21\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u5220\u9664");
            }
            if (type != 0 && type != 1 && type != -1) {
                throw new XLRuntimeException("\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u5220\u9664\u7c7b\u578b");
            }
            facade.deleteKeyAll(type, batid, ruleid);
        }
        catch (Exception e) {
            logger.error((Object)"\u4e00\u952e\u5220\u9664\u5931\u8d25", (Throwable)e);
            this.alertJS("\u4e00\u952e\u5220\u9664\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
        }
        return "";
    }

    public String delete() {
        log.debug((Object)"Start delete some keyinfo ...");
        String delseqids = this.findParameter("delseqids");
        long[] ids = new long[delseqids.length()];
        String[] dels = delseqids.split(",");
        for (int i = 0; i < dels.length; ++i) {
            String del = dels[i];
            if (del.indexOf("_") > -1) {
                del = del.split("_")[0];
            }
            ids[i] = Long.parseLong(del);
        }
        KeyBatch keybatch = (KeyBatch)this.findBean(KeyBatch.class, "keybatch2");
        log.info((Object)("ruleid:" + keybatch.getRuleid() + ",batid:" + keybatch.getBatid() + ",ids:" + ids));
        KeyBatch querykeybatch = new KeyBatch();
        querykeybatch.setBatid(keybatch.getBatid());
        querykeybatch.setRuleid(keybatch.getRuleid());
        KeyBatch result = facade.findKeyBatch(querykeybatch);
        facade.deleteKeyInfoByIds(ids, keybatch.getRuleid());
        result.setKeynum(result.getKeynum() - ids.length);
        facade.updateKeyBatch(result);
        log.debug((Object)"Delete keyinfo over.");
        return "";
    }

    public String doImport() {
        log.debug((Object)"Start import ...");
        KeyBatch keybatch = (KeyBatch)this.findBean(KeyBatch.class, "keybatch2");
        log.info((Object)("keyruleid:" + keybatch.getRuleid() + ",batid:" + keybatch.getBatid() + ",serverid:" + keybatch.getServerid()));
        try {
            if (this.isEmpty(keybatch.getRuleid()) || keybatch.getKeyfile() == null || this.isEmpty(keybatch.getServerid())) {
                log.error((Object)"\u5bfc\u5165\u6570\u636e\u6240\u9700\u53c2\u6570\u4e0d\u8db3\uff01");
                throw new XLRuntimeException("\u5bfc\u5165\u6570\u636e\u6240\u9700\u53c2\u6570\u4e0d\u8db3\uff01");
            }
            String keyinfostr = null;
            try {
                keyinfostr = new String(keybatch.getKeyfile().getBytes(), "GBK");
            }
            catch (Exception ex) {
                log.error((Object)("Read keyfile error:" + ex.getMessage()));
            }
            KeyBatch keybatchquery = new KeyBatch();
            keybatchquery.setBatid(keybatch.getBatid());
            keybatchquery.setRuleid(keybatch.getRuleid());
            KeyBatch keybatchdata = facade.findKeyBatch(keybatchquery);
            KeyRule keyrulequery = new KeyRule();
            keyrulequery.setRuleid(keybatch.getRuleid());
            KeyRule keyruledata = facade.findKeyRule(keyrulequery);
            int keylength = 20;
            if (keyruledata != null) {
                keylength = keyruledata.getKeysize();
            }
            if (keyinfostr != null && keybatchdata != null) {
                log.info((Object)"keyinfostr is not null");
                String[] keyinfoarray = keyinfostr.split("\\r\\n");
                KeyInfo queryforexist = new KeyInfo();
                queryforexist.setRuleid(keybatch.getRuleid());
                queryforexist.setBatid(keybatch.getBatid());
                int keynum = 0;
                for (String key : keyinfoarray) {
                    if (key == null || key.length() == 0 || key.trim().length() == 0) continue;
                    if ((key = key.trim()).length() > keylength) {
                        this.alertJS("NewPlayerCard Key:" + key + " \u8d85\u8fc7\u5361\u5bc6\u89c4\u5b9a\u957f\u5ea6,Ignore this one. key.length:" + key.length() + ",keylength:" + keylength + ", key:" + key);
                        log.info((Object)("NewPlayerCard Key:" + key + " \u8d85\u8fc7\u5361\u5bc6\u89c4\u5b9a\u957f\u5ea6,Ignore this one.key:" + key));
                        return "";
                    }
                    KeyInfo data = new KeyInfo();
                    data.setBatid(keybatch.getBatid());
                    data.setRuleid(keybatch.getRuleid());
                    data.setCdkey(key);
                    data.setState(-1);
                    data.setFromdate(this.now());
                    data.setInputby(this.currentUserLogo());
                    data.setInputtime(this.now());
                    data.setTodate(keybatch.getEdittime());
                    data.setServerid(keybatch.getServerid());
                    facade.saveKeyInfo(data);
                    ++keynum;
                }
                keybatchdata.setKeynum(keybatchdata.getKeynum() + keynum);
                facade.updateKeyBatch(keybatchdata);
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u5bfc\u5165\u5931\u8d25", (Throwable)e);
            this.alertJS("\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
        }
        this.alertJS("\u5bfc\u5165\u5b8c\u6210");
        log.debug((Object)"End import .");
        return "go_back";
    }

    public Map<Integer, String> getStatusMap() {
        if (statusMap == null) {
            statusMap = new HashMap<Integer, String>();
            statusMap.put(-1, "\u672a\u4f7f\u7528");
            statusMap.put(1, "\u5df2\u9886\u53d6");
        }
        return statusMap;
    }

    public List<SelectItem> getServerItems() {
        KeyBatch keybatch = (KeyBatch)this.findBean(KeyBatch.class, "keybatch2");
        String ruleid = keybatch.getRuleid();
        KeyRule keyrule = new KeyRule();
        keyrule.setRuleid(ruleid);
        KeyRule myrule = facade.findKeyRule(keyrule);
        String gameid = myrule.getGameid();
        if (gameid != null && gameid.length() == 5) {
            gameid = "0" + gameid;
        }
        GameServers servers = new GameServers();
        servers.setGameId(gameid);
        List gslist = FacadeFactory.INSTANCE.getGameServersBo().findGameServers(servers, 0, 0);
        ArrayList<SelectItem> result = new ArrayList<SelectItem>();
        for (GameServers gs : gslist) {
            int openstatus = Integer.parseInt(gs.getOpenStatus());
            if (openstatus != 0 && openstatus != 1 && openstatus != 3 && openstatus != 4) continue;
            result.add(new SelectItem((Object)gs.getServerId(), gs.getServerName()));
        }
        return result;
    }

    public SelectItem[] getStatusItems() {
        if (statusItems == null) {
            statusItems = new SelectItem[2];
            KeyInfoManageBean.statusItems[0] = new SelectItem((Object)-1, "\u672a\u4f7f\u7528");
            KeyInfoManageBean.statusItems[1] = new SelectItem((Object)1, "\u5df2\u9886\u53d6");
        }
        return statusItems;
    }
}

