/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.newplayercard.web.model;

import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.newplayercard.facade.IFacade;
import com.xunlei.newplayercard.vo.KeyBatch;
import com.xunlei.newplayercard.vo.KeyInfo;
import com.xunlei.newplayercard.vo.KeyRule;
import com.xunlei.newplayercard.web.model.BaseManageBean;
import java.util.HashMap;
import java.util.Map;
import javax.faces.model.SelectItem;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

@FunRef(value="playercardkeyrule")
public class KeyBatchManageBean
extends BaseManageBean {
    private static Logger log = Logger.getLogger(KeyBatchManageBean.class);
    private static IFacade facade = IFacade.INSTANCE;
    private static Map<String, String> statusMap;
    private static SelectItem[] statusItems;
    private static Map<String, String> battypeMap;
    private static SelectItem[] battypeItems;

    public String getQueryKeyBatch() {
        log.debug((Object)"Start query keybatch...");
        this.authenticateRun();
        KeyBatch query = (KeyBatch)this.findBean(KeyBatch.class, "keybatch_query");
        KeyRule keyrule = (KeyRule)this.findBean(KeyRule.class, "keyrule2");
        if (keyrule != null) {
            log.debug((Object)keyrule.getRuleid());
            query.setRuleid(keyrule.getRuleid());
        }
        PagedFliper fliper = this.getFliper();
        fliper.setSortColumnIfEmpty("inputtime desc");
        Sheet<KeyBatch> sheet = facade.queryKeyBatch(query, fliper);
        this.mergePagedDataModel(sheet, new PagedFliper[]{fliper});
        log.debug((Object)"Query keybatch over.");
        return "";
    }

    public String add() {
        log.debug((Object)"Start save keybatch...");
        this.authenticateAdd();
        KeyBatch data = (KeyBatch)this.findBean(KeyBatch.class, "keybatch_data");
        if (this.existedBatchName(data.getRuleid(), data.getBatname())) {
            this.alertJS("\u8be5\u6279\u6b21\u540d\u79f0\u7684\u6279\u6b21\u5df2\u5b58\u5728");
            return "";
        }
        String ruleid = ((KeyRule)this.findBean(KeyRule.class, "keyrule2")).getRuleid();
        log.debug((Object)ruleid);
        data.setRuleid(ruleid);
        data.setInputtime(this.now());
        data.setInputby(this.currentUserLogo());
        data.setStatus("1");
        try {
            KeyBatch kbquery = new KeyBatch();
            kbquery.setRuleid(ruleid);
            if ("1".equals(data.getBattype())) {
                kbquery.setBattype("1");
                Sheet<KeyBatch> kblist = facade.queryKeyBatch(kbquery, null);
                if (kblist != null && kblist.getRowcount() > 0) {
                    this.alertJS("\u8be5\u6e38\u620f\u7684\u65b0\u624b\u5361\u7c7b\u578b\u5df2\u5b58\u5728");
                    return "";
                }
            }
            facade.saveKeyBatch(data);
            KeyRule query = new KeyRule();
            query.setRuleid(data.getRuleid());
            KeyRule keyrule = facade.findKeyRule(query);
            keyrule.setBatcount(keyrule.getBatcount() + 1);
            facade.updateKeyRule(keyrule);
        }
        catch (XLRuntimeException e) {
            log.error((Object)("Save keybatch error:" + e.getMessage()));
            this.mergeBean(e.getMessage(), "jsmessage");
        }
        log.debug((Object)"Save keybatch over.");
        this.getQueryKeyBatch();
        return "";
    }

    public String edit() {
        log.debug((Object)"Start edit keybatch...");
        this.authenticateEdit();
        KeyBatch data = (KeyBatch)this.findBean(KeyBatch.class, "keybatch_data");
        if (this.existedBatchName(data.getRuleid(), data.getBatname(), data.getSeqid())) {
            this.alertJS("\u8be5\u6279\u6b21\u540d\u79f0\u7684\u6279\u6b21\u5df2\u5b58\u5728");
            return "";
        }
        data.setEdittime(this.now());
        data.setEditby(this.currentUserLogo());
        try {
            facade.saveKeyBatch(data);
        }
        catch (XLRuntimeException e) {
            log.error((Object)("Edit keybatch error:" + e.getMessage()));
            this.mergeBean(e.getMessage(), "jsmessage");
        }
        log.debug((Object)"Edit keybatch over.");
        this.getQueryKeyBatch();
        return "";
    }

    public String editsome() {
        log.debug((Object)"Start edit keybatch...");
        this.authenticateEdit();
        KeyBatch data = (KeyBatch)this.findBean(KeyBatch.class, "keybatch_data");
        if (this.existedBatchName(data.getRuleid(), data.getBatname(), data.getSeqid())) {
            this.alertJS("\u8be5\u6279\u6b21\u540d\u79f0\u7684\u6279\u6b21\u5df2\u5b58\u5728");
            return "";
        }
        try {
            KeyBatch kbatch = facade.findKeyBatchById(data.getSeqid());
            kbatch.setEditby(this.now());
            kbatch.setEditby(this.currentUserLogo());
            kbatch.setIslimitserver(data.getIslimitserver());
            kbatch.setBatname(data.getBatname());
            kbatch.setBattype(data.getBattype());
            kbatch.setGiftname(data.getGiftname());
            kbatch.setGiftcontent(data.getGiftcontent());
            kbatch.setGiftcondition(data.getGiftcondition());
            kbatch.setRemark(data.getRemark());
            facade.updateKeyBatch(kbatch);
        }
        catch (XLRuntimeException e) {
            log.error((Object)("Edit keybatch error:" + e.getMessage()));
            this.mergeBean(e.getMessage(), "jsmessage");
        }
        log.debug((Object)"Edit keybatch over.");
        this.getQueryKeyBatch();
        return "";
    }

    public String deleteSome() {
        log.debug((Object)"Start delete keybatch...");
        this.authenticateDel();
        long[] ids = this.findParamSeqids();
        String ruleid = ((KeyRule)this.findBean(KeyRule.class, "keyrule2")).getRuleid();
        try {
            for (long id : ids) {
                KeyBatch batch = facade.findKeyBatchById(id);
                KeyInfo info = new KeyInfo();
                info.setBatid(batch.getBatid());
                info.setRuleid(ruleid);
                Sheet<KeyInfo> kilist = facade.queryKeyInfo(info, this.getFliper());
                if (kilist == null || kilist.getRowcount() <= 0) continue;
                this.alertJS("\u8bf7\u5148\u5220\u9664\u6fc0\u6d3b\u7801\uff0c\u518d\u5220\u9664\u6279\u6b21");
                return "";
            }
            facade.deleteKeyBatchByIds(ids);
            KeyRule query = new KeyRule();
            query.setRuleid(ruleid);
            KeyRule keyrule = facade.findKeyRule(query);
            keyrule.setBatcount(keyrule.getBatcount() - ids.length);
            facade.updateKeyRule(keyrule);
        }
        catch (XLRuntimeException e) {
            log.error((Object)("Delete keybatch error:" + e.getMessage()));
            this.mergeBean(e.getMessage(), "jsmessage");
        }
        log.debug((Object)"Delete keybatch over.");
        this.getQueryKeyBatch();
        return "";
    }

    private boolean existedBatchName(String ruleid, String batname) {
        if (StringUtils.isEmpty((String)ruleid) || StringUtils.isEmpty((String)batname)) {
            return false;
        }
        KeyBatch data = new KeyBatch();
        data.setRuleid(ruleid);
        data.setBatname(batname);
        try {
            KeyBatch result = facade.findKeyBatch(data);
            if (result != null) {
                return true;
            }
        }
        catch (XLRuntimeException e) {
            log.error((Object)("existedBatchName XLRuntimeException:" + e.getMessage()));
        }
        catch (Exception e) {
            log.error((Object)("existedBatchName Exception:" + e.getMessage()));
        }
        return false;
    }

    private boolean existedBatchName(String ruleid, String batname, long seqId) {
        if (StringUtils.isEmpty((String)ruleid) || StringUtils.isEmpty((String)batname) || seqId == 0L) {
            return false;
        }
        KeyBatch data = new KeyBatch();
        data.setRuleid(ruleid);
        data.setBatname(batname);
        PagedFliper fliper = new PagedFliper();
        try {
            Sheet<KeyBatch> result = facade.queryKeyBatch(data, fliper);
            if (result != null && result.getDatas() != null) {
                for (KeyBatch kb : result.getDatas()) {
                    if (seqId == kb.getSeqid()) continue;
                    return true;
                }
            }
        }
        catch (XLRuntimeException e) {
            log.error((Object)("existedBatchName XLRuntimeException:" + e.getMessage()));
        }
        catch (Exception e) {
            log.error((Object)("existedBatchName Exception:" + e.getMessage()));
        }
        return false;
    }

    public Map<String, String> getStatusMap() {
        if (statusMap == null) {
            statusMap = new HashMap<String, String>();
            statusMap.put("1", "\u4f7f\u7528");
            statusMap.put("2", "\u505c\u7528");
        }
        return statusMap;
    }

    public SelectItem[] getStatusItems() {
        if (statusItems == null) {
            statusItems = new SelectItem[2];
            KeyBatchManageBean.statusItems[0] = new SelectItem((Object)"1", "\u4f7f\u7528");
            KeyBatchManageBean.statusItems[1] = new SelectItem((Object)"2", "\u505c\u7528");
        }
        return statusItems;
    }

    public Map<String, String> getBattypeMap() {
        if (battypeMap == null) {
            battypeMap = new HashMap<String, String>();
            battypeMap.put("1", "\u65b0\u624b\u5361");
            battypeMap.put("2", "\u793c\u5305");
        }
        return battypeMap;
    }

    public SelectItem[] getBattypeItems() {
        if (battypeItems == null) {
            battypeItems = new SelectItem[2];
            KeyBatchManageBean.battypeItems[0] = new SelectItem((Object)"1", "\u65b0\u624b\u5361");
            KeyBatchManageBean.battypeItems[1] = new SelectItem((Object)"2", "\u793c\u5305");
        }
        return battypeItems;
    }
}

