package com.xunlei.newplayercard.web.model;

import java.util.HashMap;
import java.util.Map;

import javax.faces.model.SelectItem;

import org.apache.log4j.Logger;

import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.newplayercard.vo.KeyRule;

@FunRef("playercardkeyrule")
public class KeyRuleManageBean extends BaseManageBean {

	private static Logger log = Logger.getLogger(KeyRuleManageBean.class);
	private static com.xunlei.newplayercard.facade.IFacade facade = com.xunlei.newplayercard.facade.IFacade.INSTANCE;
	
	private static Map<String,String> ruletypeMap;
	private static SelectItem[] ruletypeItems; 
	public String getQueryKeyRule(){
		log.info("Start query keyrule ...");
		this.authenticateRun();
		KeyRule query = this.findBean(KeyRule.class, "keyrule_query");
		if(null != query){
			 PagedFliper fliper=this.getFliper();
	         fliper.setSortColumnIfEmpty("inputTime desc");
	         Sheet<KeyRule> sheet = facade.queryKeyRule(query, fliper);
	         this.mergePagedDataModel(sheet, fliper);
		}
		log.info("Query keyrule over");
		return "";
	}
	
	public String add(){
		log.info("Start add keyrule...");
		this.authenticateAdd();
		KeyRule data = this.findBean(KeyRule.class, "keyrule_data");
		log.info("gameid:"+data.getGameid()+",gamename:"+data.getGamename());
		log.info("ruleid:"+data.getRuleid()+",rulename:"+data.getRulename());
		data.setInputtime(now());
		data.setInputby(currentUserLogo());
		if(data.getKeysize()==0){
			data.setKeysize(100);//默认长度是100
		}
		try{
			facade.saveKeyRule(data);
		}catch(XLRuntimeException e){    
			log.error("Add keyrule error:"+e.getMessage());
            mergeBean(e.getMessage(), "jsmessage");
        }
		log.info("Add keyrule over.");
		this.getQueryKeyRule();
		return "";
	}
	
	public String edit(){
		log.info("Start edit keyrule...");
		this.authenticateEdit();
		KeyRule data = this.findBean(KeyRule.class, "keyrule_data");
		log.info("gameid:"+data.getGameid()+",gamename:"+data.getGamename());
		log.info("ruleid:"+data.getRuleid()+",rulename:"+data.getRulename());
		data.setEditby(currentUserLogo());
        data.setEdittime(now()); 
        if(data.getKeysize()==0){
			data.setKeysize(20);
		}
        try{
        	facade.updateKeyRule(data);
        }catch(XLRuntimeException e){      
        	log.info("Edit keyrule error:"+e.getMessage());
            mergeBean(e.getMessage(), "jsmessage");
        }
        log.info("Edit keyrule over.");
        this.getQueryKeyRule();
        return "";
	}
	
	public String deleteSome(){
		log.info("Start delete keyrule...");
		long[] ids = this.findParamSeqids();
		
		try{
        	facade.deleteKeyRuleByIds(ids);
        }catch(XLRuntimeException e){    
        	 log.error("Delete key rule error:"+e.getMessage());
             mergeBean(e.getMessage(), "jsmessage");
        }
        log.info("Delete keyrule over.");
        this.getQueryKeyRule();
        return "";
	}
	
	
	public Map<String,String> getRuletypeMap(){
		if(ruletypeMap==null){
			ruletypeMap = new HashMap<String,String>();
			ruletypeMap.put("1", "随机");
			ruletypeMap.put("2", "首字母+随机");
		}
		return ruletypeMap;
	}
	
	public SelectItem[] getRuletypeItems(){
		ruletypeItems = new SelectItem[2];
		ruletypeItems[0] = new SelectItem("1", "随机");
		ruletypeItems[1] = new SelectItem("2", "首字母+随机");
		return ruletypeItems;
	}
}
