package com.xunlei.newplayercard.web.model;

import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.newplayercard.vo.KeyBatch;
import com.xunlei.newplayercard.vo.KeyInfo;
import com.xunlei.newplayercard.vo.KeyRule;
import com.xunlei.niux.data.vipgame.vo.GameServers;
import org.apache.log4j.Logger;

import javax.faces.model.SelectItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@FunRef("playercardkeyrule")
public class KeyInfoManageBean extends BaseManageBean {

    private static Logger log = Logger.getLogger(KeyInfoManageBean.class);
    private static com.xunlei.newplayercard.facade.IFacade facade = com.xunlei.newplayercard.facade.IFacade.INSTANCE;
    private static Map<Integer, String> statusMap;
    private static SelectItem[] statusItems;

    public String getQueryKeyInfo() {
        log.debug("Start query keyinfo ...");
        this.authenticateRun();

        KeyInfo query = this.findBean(KeyInfo.class, "keyinfo_query");
        KeyBatch keybatch = this.findBean(KeyBatch.class, "keybatch2");
        log.info("ruleid:" + keybatch.getRuleid() + ",batid:" + keybatch.getBatid());
        query.setBatid(keybatch.getBatid());
        query.setRuleid(keybatch.getRuleid());
        PagedFliper fliper = this.getFliper();
        fliper.setSortColumnIfEmpty("inputtime desc");
        Sheet<KeyInfo> sheet = facade.queryKeyInfo(query, fliper);
        this.mergePagedDataModel(sheet, fliper);
        log.debug("Query keyinfo over.");
        return "";
    }

    public String deleteSome() {
        log.debug("Start delete some keyinfo ...");
        this.authenticateDel();
        long[] ids = this.findParamSeqids();
        KeyBatch keybatch = this.findBean(KeyBatch.class, "keybatch2");
        log.info("ruleid:" + keybatch.getRuleid() + ",batid:" + keybatch.getBatid() + ",ids:" + ids);
        KeyBatch querykeybatch = new KeyBatch();
        querykeybatch.setBatid(keybatch.getBatid());
        querykeybatch.setRuleid(keybatch.getRuleid());
        KeyBatch result = facade.findKeyBatch(querykeybatch);
        facade.deleteKeyInfoByIds(ids, keybatch.getRuleid());
        result.setKeynum(result.getKeynum() - ids.length);
        facade.updateKeyBatch(result);
        log.debug("Delete keyinfo over.");
        return "";
    }

    /**
     * 一键删除同一个批次下的所有激活码
     *
     * @return
     */
    public String deleteAll() {
        log.debug("start delete All keyinfo ...");
        this.authenticateDel();
        KeyBatch keybatch = this.findBean(KeyBatch.class, "keybatch2");
        String batid = keybatch.getBatid();
        String ruleid = keybatch.getRuleid();
        try {
            int type = findParamInt("type");
            if (isEmpty(batid)) {
                throw new XLRuntimeException("卡密为空，不能删除");
            }
            if (isEmpty(ruleid)) {
                throw new XLRuntimeException("批次为空，不能删除");
            }
            if (type != 0 && type != 1 && type != -1) {
                throw new XLRuntimeException("请选择正确的删除类型");
            }
            facade.deleteKeyAll(type, batid, ruleid);
        } catch (Exception e) {
            logger.error("一键删除失败", e);
            alertJS("一键删除失败，原因：" + e.getMessage());
        }
        return "";
    }

    public String delete() {
        log.debug("Start delete some keyinfo ...");
        this.authenticateDel();
        String delseqids = findParameter("delseqids");
        long[] ids = new long[delseqids.length()];
        String dels[] = delseqids.split(",");
        for (int i = 0; i < dels.length; i++) {
            String del = dels[i];
            if (del.indexOf("_") > -1) {
                del = del.split("_")[0];
            }
            ids[i] = Long.parseLong(del);
        }
        KeyBatch keybatch = this.findBean(KeyBatch.class, "keybatch2");
        log.info("ruleid:" + keybatch.getRuleid() + ",batid:" + keybatch.getBatid() + ",ids:" + ids);
        KeyBatch querykeybatch = new KeyBatch();
        querykeybatch.setBatid(keybatch.getBatid());
        querykeybatch.setRuleid(keybatch.getRuleid());
        KeyBatch result = facade.findKeyBatch(querykeybatch);
        facade.deleteKeyInfoByIds(ids, keybatch.getRuleid());
        result.setKeynum(result.getKeynum() - ids.length);
        facade.updateKeyBatch(result);
        log.debug("Delete keyinfo over.");
        return "";
    }

    public String doImport() {
        log.debug("Start import ...");
        this.authenticateAdd();
        KeyBatch keybatch = this.findBean(KeyBatch.class, "keybatch2");
        log.info("keyruleid:" + keybatch.getRuleid() + ",batid:" + keybatch.getBatid() + ",serverid:" + keybatch.getServerid());
        try {

            if (isEmpty(keybatch.getRuleid()) || keybatch.getKeyfile() == null || isEmpty(keybatch.getServerid())) {
                log.error("导入数据所需参数不足！");
                throw new XLRuntimeException("导入数据所需参数不足！");
            }

            String keyinfostr = null;
            try {
                keyinfostr = new String(keybatch.getKeyfile().getBytes(), "GBK");
            } catch (Exception ex) {
                log.error("Read keyfile error:" + ex.getMessage());
            }
            KeyBatch keybatchquery = new KeyBatch();
            keybatchquery.setBatid(keybatch.getBatid());
            keybatchquery.setRuleid(keybatch.getRuleid());

            KeyBatch keybatchdata = facade.findKeyBatch(keybatchquery);

            KeyRule keyrulequery = new KeyRule();
            keyrulequery.setRuleid(keybatch.getRuleid());
            KeyRule keyruledata = facade.findKeyRule(keyrulequery);
            int keylength = 20;
            if (keyruledata != null) {
                keylength = keyruledata.getKeysize();
            }

            if (keyinfostr != null && keybatchdata != null) {
                log.info("keyinfostr is not null");
                //keyinfostr = keyinfostr.replaceAll("\\n", "\\r");
                String[] keyinfoarray = keyinfostr.split("\\r\\n");
                //            if (!keybatch.getAppendImport()) {
                //                log.info("非追加导入");
                //                KeyInfo datadel = new KeyInfo();
                //                datadel.setBatid(keybatch.getBatid());
                //                datadel.setRuleid(keybatch.getRuleid());
                //                datadel.setServerid(keybatch.getServerid());
                //                facade.deleteKeyInfo(datadel);
                //                keybatchdata.setKeynum(0);
                //                keybatchdata.setGetnum(0);
                //            }
                KeyInfo queryforexist = new KeyInfo();
                queryforexist.setRuleid(keybatch.getRuleid());
                queryforexist.setBatid(keybatch.getBatid());
                int keynum = 0;
                for (String key : keyinfoarray) {
                    if ((key == null) || (key.length() == 0)
                            || (key.trim().length() == 0)) {
                        continue;
                    }
                    key = key.trim();

                    if (key.length() > keylength) {
                        alertJS("NewPlayerCard Key:" + key
                                + " 超过卡密规定长度,Ignore this one. key.length:" + key.length() + ",keylength:" + keylength + ", key:" + key);
                        log.info("NewPlayerCard Key:" + key
                                + " 超过卡密规定长度,Ignore this one.key:" + key);
                        return "";
                        //continue;
                    }

                    //                queryforexist.setCdkey(key);
                    //                queryforexist.setServerid(keybatch.getServerid());
                    //                if (null != facade.findKeyInfo(queryforexist)) {
                    //                    log.info("NewPlayerCard Key:" + key
                    //                            + " is already exist,Ignore this one.");
                    //                } else {
                    KeyInfo data = new KeyInfo();
                    data.setBatid(keybatch.getBatid());
                    data.setRuleid(keybatch.getRuleid());
                    data.setCdkey(key);
                    data.setState(-1);
                    data.setFromdate(now());
                    data.setInputby(currentUserLogo());
                    data.setInputtime(now());
                    //                    data.setTodate(com.xunlei.common.util.DatetimeUtil.addDate(
                    //                            com.xunlei.common.util.DatetimeUtil.today(), "D",
                    //                            90));
                    data.setTodate(keybatch.getEdittime());
                    data.setServerid(keybatch.getServerid());
                    facade.saveKeyInfo(data);
                    keynum++;
                    //                }
                }
                keybatchdata.setKeynum(keybatchdata.getKeynum() + keynum);
                facade.updateKeyBatch(keybatchdata);

            }

        } catch (Exception e) {
            logger.error("导入失败", e);
            alertJS("导入失败，原因：" + e.getMessage());
            //mergeJsmessage("修改失败，原因：" + e.getMessage());
        }
        alertJS("导入完成");
        log.debug("End import .");
        return "go_back";
    }

    public Map<Integer, String> getStatusMap() {
        if (statusMap == null) {
            statusMap = new HashMap<Integer, String>();
            statusMap.put(-1, "未使用");
            statusMap.put(1, "已领取");
        }
        return statusMap;
    }

    public List<SelectItem> getServerItems() {
        KeyBatch keybatch = this.findBean(KeyBatch.class, "keybatch2");
        String ruleid = keybatch.getRuleid();
        KeyRule keyrule = new KeyRule();
        keyrule.setRuleid(ruleid);
        KeyRule myrule = facade.findKeyRule(keyrule);
        String gameid = myrule.getGameid();
        if (gameid != null) {
            if (gameid.length() == 5) {
                gameid = "0" + gameid;
            }
        }
        GameServers servers = new GameServers();
        servers.setGameId(gameid);
        List<GameServers> gslist = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getGameServersBo().findGameServers(servers, 0, 0);
        List<SelectItem> result = new ArrayList<SelectItem>();
        for (GameServers gs : gslist) {
            int openstatus = Integer.parseInt(gs.getOpenStatus());
            if (openstatus == 0 || openstatus == 1 || openstatus == 3 || openstatus == 4) {
                result.add(new SelectItem(gs.getServerId(), gs.getServerName()));
            }
        }

        return result;
    }

    public SelectItem[] getStatusItems() {
        if (statusItems == null) {
            statusItems = new SelectItem[2];
            statusItems[0] = new SelectItem(-1, "未使用");
            statusItems[1] = new SelectItem(1, "已领取");
        }
        return statusItems;
    }
}
