package com.xunlei.newplayercard.web.model;

import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.newplayercard.vo.KeyBatch;
import com.xunlei.newplayercard.vo.KeyInfo;
import com.xunlei.newplayercard.vo.KeyRule;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

import javax.faces.model.SelectItem;
import java.util.HashMap;
import java.util.Map;

@FunRef("playercardkeyrule")
public class KeyBatchManageBean extends BaseManageBean {

    private static Logger log = Logger.getLogger(KeyBatchManageBean.class);
    private static com.xunlei.newplayercard.facade.IFacade facade = com.xunlei.newplayercard.facade.IFacade.INSTANCE;
    private static Map<String, String> statusMap;
    private static SelectItem[] statusItems;
    private static Map<String, String> battypeMap;
    private static SelectItem[] battypeItems;

    public String getQueryKeyBatch() {
        log.debug("Start query keybatch...");
        this.authenticateRun();
        KeyBatch query = this.findBean(KeyBatch.class, "keybatch_query");
        KeyRule keyrule = this.findBean(KeyRule.class, "keyrule2");

        if (keyrule != null) {
            log.debug(keyrule.getRuleid());
            query.setRuleid(keyrule.getRuleid());
        }

        PagedFliper fliper = this.getFliper();
        fliper.setSortColumnIfEmpty("inputtime desc");
        Sheet<KeyBatch> sheet = facade.queryKeyBatch(query, fliper);
        this.mergePagedDataModel(sheet, fliper);
        log.debug("Query keybatch over.");
        return "";
    }

    public String add() {
        log.debug("Start save keybatch...");
        this.authenticateAdd();
        KeyBatch data = this.findBean(KeyBatch.class, "keybatch_data");
        
        if(existedBatchName(data.getBatname())){
            alertJS("该批次名称的批次已存在");
            return "";
        }
        
        String ruleid = this.findBean(KeyRule.class, "keyrule2").getRuleid();
        log.debug(ruleid);
        data.setRuleid(ruleid);
        data.setInputtime(now());
        data.setInputby(currentUserLogo());
        data.setStatus("1");
        try {
            KeyBatch kbquery = new KeyBatch();
            kbquery.setRuleid(ruleid);
            if ("1".equals(data.getBattype())) {
                kbquery.setBattype("1");//新手卡
                Sheet<KeyBatch> kblist = facade.queryKeyBatch(kbquery, null);
                if (kblist != null && kblist.getRowcount() > 0) {
                    alertJS("该游戏的新手卡类型已存在");
                    return "";
                }
            }

            facade.saveKeyBatch(data);
            KeyRule query = new KeyRule();
            query.setRuleid(data.getRuleid());
            KeyRule keyrule = facade.findKeyRule(query);
            keyrule.setBatcount(keyrule.getBatcount() + 1);
            facade.updateKeyRule(keyrule);
        } catch (XLRuntimeException e) {
            log.error("Save keybatch error:" + e.getMessage());
            mergeBean(e.getMessage(), "jsmessage");
        }
        log.debug("Save keybatch over.");
        this.getQueryKeyBatch();
        return "";
    }

    public String edit() {
        log.debug("Start edit keybatch...");
        this.authenticateEdit();
        KeyBatch data = this.findBean(KeyBatch.class, "keybatch_data");

        if(existedBatchName(data.getBatname())){
            alertJS("该批次名称的批次已存在");
            return "";
        }
        
        data.setEdittime(now());
        data.setEditby(currentUserLogo());
        try {
            facade.saveKeyBatch(data);
        } catch (XLRuntimeException e) {
            log.error("Edit keybatch error:" + e.getMessage());
            mergeBean(e.getMessage(), "jsmessage");
        }
        log.debug("Edit keybatch over.");
        this.getQueryKeyBatch();
        return "";
    }

    public String editsome() {
        log.debug("Start edit keybatch...");
        this.authenticateEdit();
        KeyBatch data = this.findBean(KeyBatch.class, "keybatch_data");

        if(existedBatchName(data.getBatname())){
            alertJS("该批次名称的批次已存在");
            return "";
        }
        
        try {
            KeyBatch kbatch = facade.findKeyBatchById(data.getSeqid());
            kbatch.setEditby(now());
            kbatch.setEditby(currentUserLogo());
            kbatch.setIslimitserver(data.getIslimitserver());
            kbatch.setBatname(data.getBatname());//修改批次名称
            kbatch.setBattype(data.getBattype());
            kbatch.setGiftname(data.getGiftname());
            kbatch.setGiftcontent(data.getGiftcontent());
            kbatch.setRemark(data.getRemark());
            facade.updateKeyBatch(kbatch);
        } catch (XLRuntimeException e) {
            log.error("Edit keybatch error:" + e.getMessage());
            mergeBean(e.getMessage(), "jsmessage");
        }
        log.debug("Edit keybatch over.");
        this.getQueryKeyBatch();
        return "";
    }

    public String deleteSome() {
        log.debug("Start delete keybatch...");
        this.authenticateDel();
        long[] ids = this.findParamSeqids();
        String ruleid = this.findBean(KeyRule.class, "keyrule2").getRuleid();
        try {
            //add by lisu 2013-07-03
            //删除批次号之前，先检查该批次号下是否有激活码，如果有激活码，则提示必须先删除激活码
            for (long id : ids) {
                KeyBatch batch = facade.findKeyBatchById(id);
                KeyInfo info = new KeyInfo();
                info.setBatid(batch.getBatid());
                info.setRuleid(ruleid);
                Sheet<KeyInfo> kilist = facade.queryKeyInfo(info, this.getFliper());
                if (kilist != null && kilist.getRowcount() > 0) {
                    alertJS("请先删除激活码，再删除批次");
                    return "";
                }
            }

            facade.deleteKeyBatchByIds(ids);
            KeyRule query = new KeyRule();
            query.setRuleid(ruleid);
            KeyRule keyrule = facade.findKeyRule(query);
            keyrule.setBatcount(keyrule.getBatcount() - ids.length);
            facade.updateKeyRule(keyrule);
        } catch (XLRuntimeException e) {
            log.error("Delete keybatch error:" + e.getMessage());
            mergeBean(e.getMessage(), "jsmessage");
        }
        log.debug("Delete keybatch over.");
        this.getQueryKeyBatch();
        return "";
    }
    
    /**
     * 检查批次名称是否存在。
     * 限制重复批次名称。
     * @param batname 批次名称。为空时返回false.
     * @return true:存在 false:不存在
     */
    private boolean existedBatchName(String batname){
    	if(StringUtils.isEmpty(batname)){
    		return false;
    	}
    	
    	KeyBatch data = new KeyBatch();
        data.setBatname(batname);
        
    	try {
    		KeyBatch result = facade.findKeyBatch(data);
    		
    		if(result != null){
    			return true;
    		}
        } catch (XLRuntimeException e) {
            log.error("existedBatchName XLRuntimeException:" + e.getMessage());
        }catch (Exception e) {
            log.error("existedBatchName Exception:" + e.getMessage());
        }
    	
    	return false;
    }

    public Map<String, String> getStatusMap() {
        if (statusMap == null) {
            statusMap = new HashMap<String, String>();
            statusMap.put("1", "使用");
            statusMap.put("2", "停用");
        }
        return statusMap;
    }

    public SelectItem[] getStatusItems() {
        if (statusItems == null) {
            statusItems = new SelectItem[2];
            statusItems[0] = new SelectItem("1", "使用");
            statusItems[1] = new SelectItem("2", "停用");
        }
        return statusItems;
    }

    public Map<String, String> getBattypeMap() {
        if (battypeMap == null) {
            battypeMap = new HashMap<String, String>();
            battypeMap.put("1", "新手卡");
            battypeMap.put("2", "礼包");
        }
        return battypeMap;
    }

    public SelectItem[] getBattypeItems() {
        if (battypeItems == null) {
            battypeItems = new SelectItem[2];
            battypeItems[0] = new SelectItem("1", "新手卡");
            battypeItems[1] = new SelectItem("2", "礼包");
        }
        return battypeItems;
    }
}
