package com.xunlei.newplayercard.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import com.xunlei.newplayercard.dto.KeyCount;
import org.apache.log4j.Logger;

import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.newplayercard.vo.KeyInfo;
import org.springframework.jdbc.core.RowMapper;

public class KeyInfoDaoImpl extends BaseDao implements IKeyInfoDao {

	private static Logger log = Logger.getLogger(KeyInfoDaoImpl.class);
	private final static String TAB_PREFIX = "keyinfo_";
	
	@Override
	public void delete(KeyInfo data) {
		if(isEmpty(data.getRuleid())){
			log.error("ruleid is empty,can't delete.");
			return;
		}
		String tablename = TAB_PREFIX + data.getRuleid();
		String deletesql = "delete from " + tablename ;
		StringBuffer wheresql = new StringBuffer(" where 1=1");
		if(null!=data){
			if(isNotEmpty(data.getRuleid())){
				wheresql.append(" And ruleid='").append(data.getRuleid()).append("'");
			}
			
			if(isNotEmpty(data.getBatid())){
				wheresql.append(" And batid='").append(data.getBatid()).append("'");
			}
			
			if(isNotEmpty(data.getCdkey())){
				wheresql.append(" And cdkey='").append(data.getCdkey()).append("'");
			}
			
			if(isNotEmpty(data.getGetuserid())){
				wheresql.append(" And getuserid='").append(data.getGetuserid()).append("'");
			}
			
			if(isNotEmpty(data.getGetloginname())){
				wheresql.append(" And getloginname='").append(data.getGetloginname()).append("'");
			}
			
			if(isNotEmpty(data.getServerid())){
				wheresql.append(" And serverid='").append(data.getServerid()).append("'");
			}
		}
		
		deletesql = deletesql + wheresql.toString();
		log.debug(deletesql);
		this.execute(deletesql);
	}

	@Override
	public void deleteByIds(long[] ids,String ruleid) {
		String tablename = TAB_PREFIX + ruleid;
		String delsql = "delete from "+ tablename +" where seqid = ";
		for(long id:ids){
			log.debug(delsql + id);
			this.execute(delsql + id);
		}
	}

	@Override
	public KeyInfo find(KeyInfo data) {
		String tablename = TAB_PREFIX + data.getRuleid();
		String sql = "select * from " + tablename ;
		String sqlcount = "select count(1) from " + tablename;
		StringBuffer wheresql = new StringBuffer(" where 1=1");
		if(null!=data){
			if(data.getSeqid() > 0L){
				wheresql.append(" And seqid=").append(data.getSeqid()).append("");
			}
			if(isNotEmpty(data.getRuleid())){
				wheresql.append(" And ruleid='").append(data.getRuleid()).append("'");
			}
			
			if(isNotEmpty(data.getBatid())){
				wheresql.append(" And batid='").append(data.getBatid()).append("'");
			}
			
			if(isNotEmpty(data.getCdkey())){
				wheresql.append(" And cdkey='").append(data.getCdkey()).append("'");
			}
			
			if(isNotEmpty(data.getGetuserid())){
				wheresql.append(" And getuserid='").append(data.getGetuserid()).append("'");
			}
			
			if(isNotEmpty(data.getGetloginname())){
				wheresql.append(" And getloginname='").append(data.getGetloginname()).append("'");
			}
			if(data.getState() != 0){
				wheresql.append(" And state=").append(data.getState()).append("");
			}
			if(isNotEmpty(data.getServerid())){
				wheresql.append(" And serverid='").append(data.getServerid()).append("'");
			}
			
			
		}
		sqlcount += wheresql.toString();
		log.debug(sqlcount);
		int rowcount = this.getSingleInt(sqlcount);
		if(rowcount == 1){
			sql = sql + wheresql.toString();
			log.debug(sql);
			return this.queryOne(KeyInfo.class, sql);
		}
		return null;
	}

	@Override
	public KeyInfo findById(long id,String ruleid) {
		KeyInfo data = new KeyInfo();
		data.setSeqid(id);
		data.setRuleid(ruleid);
		return find(data);
	}

	@Override
	public Sheet<KeyInfo> query(KeyInfo data,PagedFliper fliper) {
		
		String tablename = TAB_PREFIX + data.getRuleid();
		String sql = "select * from " + tablename ;
		String sqlcount = "select count(1) from " + tablename;
		StringBuffer wheresql = new StringBuffer(" where 1=1");
		if(null!=data){
			if(data.getSeqid() > 0L){
				wheresql.append(" And seqid=").append(data.getSeqid()).append("");
			}
			if(isNotEmpty(data.getRuleid())){
				wheresql.append(" And ruleid='").append(data.getRuleid()).append("'");
			}
			
			if(isNotEmpty(data.getBatid())){
				wheresql.append(" And batid='").append(data.getBatid()).append("'");
			}
			
			if(isNotEmpty(data.getCdkey())){
				wheresql.append(" And cdkey='").append(data.getCdkey()).append("'");
			}
			
			if(isNotEmpty(data.getGetuserid())){
				wheresql.append(" And getuserid='").append(data.getGetuserid()).append("'");
			}
			
			if(isNotEmpty(data.getGetloginname())){
				wheresql.append(" And getloginname='").append(data.getGetloginname()).append("'");
			}
			if(data.getState() != 0){
				wheresql.append(" And state=").append(data.getState()).append("");
			}
			
			if(isNotEmpty(data.getRemark())){
				wheresql.append(" And remark='").append(data.getRemark()).append("'");
			}
			if(isNotEmpty(data.getServerid())){
				wheresql.append(" And serverid='").append(data.getServerid()).append("'");
			}
		}
		sqlcount += wheresql.toString();
		log.debug(sqlcount);
		int rowcount = this.getSingleInt(sqlcount);
		if(rowcount <=0){
			return Sheet.EMPTY;
		}
		sql = sql + wheresql.toString();
		
		if (fliper != null) {
			if (isNotEmpty(fliper.getSortColumn())) {
				sql = sql + " order by " + fliper.getSortColumn();
			}
			sql = sql + fliper.limitsql(rowcount);
		}
		return new Sheet<KeyInfo>(rowcount, query(KeyInfo.class, sql, new String[0]));
	}

	@Override
	public void save(KeyInfo data) {
		String tablename =  TAB_PREFIX + data.getRuleid();
		String savesql = "insert into "+ tablename
					+ "(ruleid,batid,cdkey,fromdate,todate,state,serverid) values('"
					+ data.getRuleid()+"','"
					+ data.getBatid()+"','"
					+ data.getCdkey()+"','"
					+ data.getFromdate()+"','"
					+ data.getTodate() +"','"
					+ data.getState() +"','"
					+ data.getServerid()+"')";
		
		log.debug("save sql:"+savesql);
		try{
			this.execute(savesql);
		}catch(Exception e){}
	}

	@Override
	public void update(KeyInfo data) {
		//
	}

	@Override
	public void deleteKeyAll(int type,String batid,String ruleid) throws Exception {
		if(isEmpty(batid)||isEmpty(ruleid)){//如果卡号或批次号为空
			throw new XLRuntimeException("卡密或批次为空");
		}
		String tablename = TAB_PREFIX + ruleid;
		String deletesql = "delete from " + tablename ;
		StringBuffer wheresql = new StringBuffer(" where 1=1");
		wheresql.append(" And ruleid='").append(ruleid).append("'")
		             .append(" And batid='").append(batid).append("'");		
		if(type == -1||type==1){//未使用或者已使用
			wheresql.append(" And state=").append(type).append("");
		}
		deletesql = deletesql + wheresql.toString();
		log.debug("keyinfo  deleteKeyAll  deletesql===>"+deletesql);
		log.debug("keyinfo  deleteKeyAll  deletesql===>"+deletesql);
		this.execute(deletesql);
	}

	@Override
	public boolean isBatchEnoughToSend(String ruleId, String batId, int num) {
		if(isEmpty(batId)||isEmpty(ruleId)){//如果卡号或批次号为空
			throw new XLRuntimeException("卡密或批次为空");
		}
		
		String tablename = TAB_PREFIX + ruleId;
		StringBuffer sql = new StringBuffer("select count(*) from ");
		sql.append(tablename);
		sql.append(" where batid=");
		sql.append(batId);
		sql.append(" and state=-1");
		
		int batCount = this.getSingleInt(sql.toString());
		return batCount >= num;
	}

	@Override
	public List<String> getActivationCodes(String ruleId, String batId, int num) {
		String tablename = TAB_PREFIX + ruleId;
		StringBuffer sql = new StringBuffer("select cdkey from ");
		sql.append(tablename);
		sql.append(" where batid=");
		sql.append(batId);
		sql.append(" and state=-1");
		sql.append(" limit 0, ");
		sql.append(num);		

		List<String> lists = this.queryToList(sql.toString());
		
		return lists;
	}

	@Override
	public void updateKeyInfoState(String ruleId, String batId,
			Map<String, String> succMap) {
		String tablename = TAB_PREFIX + ruleId;
		
		for(Entry<String, String> entry : succMap.entrySet()){
			StringBuffer sql = new StringBuffer("update ");
			sql.append(tablename);
			sql.append(" set state = 1,");
			sql.append(" getuserid=");
			sql.append(entry.getKey());
			sql.append(" where batid=");
			sql.append(batId);
			sql.append(" and cdkey=");
			sql.append("'" + entry.getValue() + "'");
			
			this.execute(sql.toString());
		}
	}

	public List<KeyCount> findByBatIdIn(String ruleId,String batids){
		String tablename = TAB_PREFIX + ruleId;
		batids=getBatids(batids);
		String sql="SELECT batid,count(1) count from  "+tablename+" where batid in ("+batids+")  and state =1  GROUP BY batid ";
		return  getJdbcTemplate().query(sql, new RowMapper() {
			@Override
			public KeyCount mapRow(ResultSet resultSet, int i) throws SQLException {
				KeyCount keyCount=new KeyCount();
				keyCount.setBatid(resultSet.getString("batid")==null?"":resultSet.getString("batid"));
				keyCount.setCount(resultSet.getInt("count"));
				return keyCount;
			}
		});
	}

	public List<KeyInfo> findByUidAndBatIdIn(String ruleId,String uid,String batids){
		String tablename = TAB_PREFIX + ruleId;
		batids=getBatids(batids);
		String sql="SELECT * from  "+tablename+" where getuserid='"+uid+"' and batid in ("+batids+") ";
		return getJdbcTemplate().query(sql, new RowMapper() {
			@Override
			public Object mapRow(ResultSet rs, int i) throws SQLException {
				KeyInfo keyInfo=new KeyInfo();
				keyInfo.setSeqid(rs.getLong("seqid"));
				keyInfo.setRuleid(rs.getString("ruleid")==null?"":rs.getString("ruleid"));
				keyInfo.setBatid(rs.getString("batid")==null?"":rs.getString("batid"));
				keyInfo.setCdkey(rs.getString("cdkey")==null?"":rs.getString("cdkey"));
				keyInfo.setFromdate(rs.getString("fromdate")==null?"":rs.getString("fromdate"));
				keyInfo.setTodate(rs.getString("todate")==null?"":rs.getString("todate"));
				keyInfo.setGetuserid(rs.getString("getuserid")==null?"":rs.getString("getuserid"));
				keyInfo.setGetloginname(rs.getString("getloginname")==null?"":rs.getString("getloginname"));
				keyInfo.setGettime(rs.getString("gettime")==null?"":rs.getString("gettime"));
				keyInfo.setGetip(rs.getString("getip")==null?"":rs.getString("getip"));
				keyInfo.setState(rs.getInt("state"));
				keyInfo.setPhone(rs.getString("phone")==null?"":rs.getString("phone"));
				keyInfo.setCreditid(rs.getString("creditid")==null?"":rs.getString("creditid"));
				keyInfo.setQq(rs.getString("qq")==null?"":rs.getString("qq"));
				keyInfo.setEmail(rs.getString("email")==null?"":rs.getString("email"));
				keyInfo.setTruename(rs.getString("truename")==null?"":rs.getString("truename"));
				keyInfo.setRemark(rs.getString("remark")==null?"":rs.getString("remark"));
				keyInfo.setInputby(rs.getString("inputby")==null?"":rs.getString("inputby"));
				keyInfo.setInputtime(rs.getString("inputtime")==null?"":rs.getString("inputtime"));
				keyInfo.setEditby(rs.getString("editby")==null?"":rs.getString("editby"));
				keyInfo.setEdittime(rs.getString("edittime")==null?"":rs.getString("edittime"));
				keyInfo.setServerid(rs.getString("serverid")==null?"":rs.getString("serverid"));
				return keyInfo;
			}
		});
		//return  getJdbcTemplate().queryForList(sql, KeyInfo.class);
	}

	private String getBatids(String batids){
		if(batids.endsWith(",")){
			batids=batids.substring(0,batids.length()-1);
		}
		if(!batids.contains("'")){
			batids="'"+batids.replace(",","','")+"'";
		}
		return batids;
	}

}
