package com.xunlei.newplayercard.dao;

import org.apache.log4j.Logger;

import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.newplayercard.vo.KeyBatch;


public class KeyBatchDaoImpl extends BaseDao implements IKeyBatchDao {

	private static Logger log = Logger.getLogger(KeyBatchDaoImpl.class);
	@Override
	public void delete(KeyBatch data) {
		this.deleteObject(data);
	}

	@Override
	public void deleteByIds(long... ids) {
		this.deleteObject("keybatch", ids);
	}

	@Override
	public KeyBatch find(KeyBatch data) {
		return this.findObjectByCondition(data);
	}

	@Override
	public KeyBatch findById(long id) {
		KeyBatch data = new KeyBatch();
		data.setSeqid(id);
		return this.find(data);
	}

	@Override
	public Sheet<KeyBatch> query(KeyBatch data,PagedFliper fliper) {
		// 计算卡密获取数量
//		String tablename = "keyinfo_"+data.getRuleid();
//		String sumsql = "update keybatch a set getnum = (select count(1) from "
//					+ tablename
//					+ " b where b.batid = a.batid and b.state=1),keynum=(select count(1) from "
//					+ tablename
//					+ " c where c.batid = a.batid) where ruleid = "+data.getRuleid();
//		log.debug("sumsql:"+sumsql);
//		this.execute(sumsql);
		String sql = "select * from keybatch ";
		String sqlcount = "select count(1) from keybatch ";
		StringBuffer wheresql = new StringBuffer(" where 1=1 ");
		if(null != data){
			if(isNotEmpty(data.getBatid())){
				wheresql.append(" And batid='").append(data.getBatid()).append("'");
			}
			if(isNotEmpty(data.getRuleid())){
				wheresql.append(" And ruleid='").append(data.getRuleid()).append("'");
			}
			if(isNotEmpty(data.getBatname())){
				wheresql.append(" And batname='").append(data.getBatname()).append("'");
			}
			if(isNotEmpty(data.getStatus())){
				wheresql.append(" And status='").append(data.getStatus()).append("'");
			}
			if(isNotEmpty(data.getBattype())){
				wheresql.append(" And battype='").append(data.getBattype()).append("'");
			}
		}
		sqlcount = sqlcount + wheresql.toString();
		
		log.info(sqlcount);
		int counts = this.getSingleInt(sqlcount);
		if(counts<=0){
			return Sheet.EMPTY;
		}
		
		sql = sql + wheresql.toString();
		log.info(sql);
		if (fliper != null) {
			if (isNotEmpty(fliper.getSortColumn())) {
				sql = sql + " order by " + fliper.getSortColumn();
			}
			sql = sql + fliper.limitsql(counts);
		}
		return new Sheet<KeyBatch>(counts, query(KeyBatch.class, sql, new String[0]));
	}

	@Override
	public void save(KeyBatch data) {
		String maxbatidsql = "select max(batid) from keybatch";
		int maxbatid = str2int(this.getSingleString(maxbatidsql));
		String newbatid = String.valueOf(maxbatid + 1);
		data.setBatid(newbatid);
		this.saveObject(data);
	}

	@Override
	public void update(KeyBatch data) {
		this.updateObject(data);
	}
	
	@Override
	public String queryRuleIdByBatId(String batid) {
		String sql = "select ruleid from keybatch where batid=";
		sql += batid;
		
		String ruleId = this.getSingleString(sql);
		
		return ruleId;
	}

}
