/**
 * 
 */
package com.xunlei.newplayercard.dao;

import java.util.List;
import java.util.Map;

import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.newplayercard.dto.KeyCount;
import com.xunlei.newplayercard.vo.KeyInfo;

/**
 * @author Weizhi
 *
 */
public interface IKeyInfoDao {
	public void save(KeyInfo data);
	public void update(KeyInfo data);
	public KeyInfo find(KeyInfo data);
	public KeyInfo findById(long id,String ruleid);
	public Sheet<KeyInfo> query(KeyInfo data,PagedFliper fliper);
	public void delete(KeyInfo data);
	public void deleteByIds(long[] id,String ruleid);
	public void deleteKeyAll(int type,String batid,String ruleid) throws Exception;
	
	public boolean isBatchEnoughToSend(String ruleId, String batId, int num);
	
	public List<String> getActivationCodes(String ruleId, String batId,int num);
	
	public void updateKeyInfoState(String ruleId,String batId, Map<String, String> succMap);

	public List<KeyCount> findByBatIdIn(String ruleId, String batids);

	public List<KeyInfo> findByUidAndBatIdIn(String ruleId,String uid,String batids);
}
