package com.xunlei.newplayercard.bo;

import java.util.List;
import java.util.Map;

import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.newplayercard.dao.IKeyInfoDao;
import com.xunlei.newplayercard.dto.KeyCount;
import com.xunlei.newplayercard.vo.KeyInfo;

public class KeyInfoBoImpl extends BaseBo implements IKeyInfoBo {

	private IKeyInfoDao keyinfodao;
	
	public IKeyInfoDao getKeyinfodao() {
		return keyinfodao;
	}

	public void setKeyinfodao(IKeyInfoDao keyinfodao) {
		this.keyinfodao = keyinfodao;
	}

	@Override
	public void deleteKeyInfo(KeyInfo data) {
		this.getKeyinfodao().delete(data);
	}

	@Override
	public void deleteKeyInfoByIds(long[] id, String ruleid) {
		this.getKeyinfodao().deleteByIds(id, ruleid);
	}

	@Override
	public KeyInfo findKeyInfo(KeyInfo data) {
		return this.getKeyinfodao().find(data);
	}

	@Override
	public KeyInfo findKeyInfoById(long id, String ruleid) {
		return this.getKeyinfodao().findById(id, ruleid);
	}

	@Override
	public Sheet<KeyInfo> queryKeyInfo(KeyInfo data, PagedFliper fliper) {
		return this.getKeyinfodao().query(data, fliper);
	}

	@Override
	public void saveKeyInfo(KeyInfo data) {
		this.getKeyinfodao().save(data);
	}

	@Override
	public void updateKeyInfo(KeyInfo data) {
		this.getKeyinfodao().update(data);
	}

	@Override
	public void deleteKeyAll(int type,String batid,String ruleid)  throws Exception{
         this.getKeyinfodao().deleteKeyAll(type, batid, ruleid);
	}

	@Override
	public boolean isBatchEnoughToSend(String ruleId, String batId, int num) {
		return this.getKeyinfodao().isBatchEnoughToSend(ruleId, batId, num);
	}

	@Override
	public List<String> getActivationCodes(String ruleId, String batId, int num) {
		return this.getKeyinfodao().getActivationCodes(ruleId, batId, num);
	}

	@Override
	public void updateKeyInfoState(String ruleId, String batId,
			Map<String, String> succMap) {
		this.getKeyinfodao().updateKeyInfoState(ruleId, batId, succMap);
		
	}

	public List<KeyCount> findByBatIdIn(String ruleId, String batids){
		return this.getKeyinfodao().findByBatIdIn(ruleId, batids);
	}

	public List<KeyInfo> findByUidAndBatIdIn(String ruleId,String uid,String batids){
		return this.getKeyinfodao().findByUidAndBatIdIn(ruleId,uid, batids);
	}

}
