package com.xunlei.newplayercard.bo;

import java.util.List;
import java.util.Map;

import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.newplayercard.dto.KeyCount;
import com.xunlei.newplayercard.vo.KeyInfo;

public interface IKeyInfoBo {

	public void saveKeyInfo(KeyInfo data);
	public void updateKeyInfo(KeyInfo data);
	public KeyInfo findKeyInfo(KeyInfo data);
	public KeyInfo findKeyInfoById(long id,String ruleid);
	public Sheet<KeyInfo> queryKeyInfo(KeyInfo data,PagedFliper fliper);
	public void deleteKeyInfo(KeyInfo data);
	public void deleteKeyInfoByIds(long[] id,String ruleid);
	public void deleteKeyAll(int type,String batid,String ruleid) throws Exception;
	
	/**
	 * 判断该批次号下的激活码是否足够
	 * @param ruleId
	 * @param batId
	 * @param num
	 * @return
	 */
	public boolean isBatchEnoughToSend(String ruleId, String batId, int num);
	
	/**
	 * 获取某批次下的指定数量的激活码
	 * @param batId
	 * @param num
	 * @return 激活码集合
	 */
	public List<String> getActivationCodes(String ruleId, String batId, int num);
	
	/**
	 * 更新keyinfo的领取状态，并更新其领取人
	 * @param ruleId
	 * @param batId
	 * @param succMap 记载领取人手机号和激活码的对应关系
	 */
	public void updateKeyInfoState(String ruleId,String batId, Map<String, String> succMap);

	public List<KeyCount> findByBatIdIn(String ruleId, String batids);

	public List<KeyInfo> findByUidAndBatIdIn(String ruleId,String uid,String batids);
	
}
