/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.newGift.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DateUtil {
    private static final ThreadLocal<Map<String, SimpleDateFormat>> local = new ThreadLocal<Map<String, SimpleDateFormat>>(){

        @Override
        protected Map<String, SimpleDateFormat> initialValue() {
            HashMap<String, SimpleDateFormat> map = new HashMap<String, SimpleDateFormat>();
            map.put("msformat", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS"));
            map.put("timeformate", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
            map.put("dayformate", new SimpleDateFormat("yyyy-MM-dd"));
            map.put("yyyyMMdd", new SimpleDateFormat("yyyyMMdd"));
            map.put("month", new SimpleDateFormat("MM"));
            map.put("day", new SimpleDateFormat("dd"));
            map.put("week", new SimpleDateFormat("W"));
            map.put("yyyyMd", new SimpleDateFormat("yyyy-M-d"));
            return map;
        }
    };

    public static SimpleDateFormat getFormart(String formart) {
        return local.get().get(formart);
    }

    public static String now() {
        return local.get().get("msformat").format(new Date());
    }

    public static String month() {
        return local.get().get("month").format(new Date());
    }

    public static String day() {
        return local.get().get("day").format(new Date());
    }

    public static String week() {
        return local.get().get("week").format(new Date());
    }

    public static String getELTime(String el) {
        if (el.matches("^(\\d{4})-(0\\d{1}|1[0-2])-(0\\d{1}|[12]\\d{1}|3[01])")) {
            return el;
        }
        Calendar calendar = Calendar.getInstance();
        String[] dateKey = el.split(",");
        String key = el;
        if (!key.equalsIgnoreCase("now")) {
            if (key.equalsIgnoreCase("week")) {
                calendar = Calendar.getInstance();
                int day_of_week = calendar.get(7) - 1;
                if (day_of_week == 0) {
                    day_of_week = 7;
                }
                calendar.add(5, -day_of_week + 1);
            } else if (key.equalsIgnoreCase("month")) {
                calendar.set(5, 1);
            } else if (key.equalsIgnoreCase("year")) {
                calendar.set(6, 1);
            }
        }
        int index = 1;
        if (dateKey.length >= 2 && dateKey[1].matches("-?\\d+")) {
            calendar.add(6, Integer.valueOf(dateKey[index++]));
        }
        String formatKey = null;
        formatKey = dateKey.length > index ? dateKey[index] : "yyyy-MM-dd";
        SimpleDateFormat format = new SimpleDateFormat(formatKey);
        return format.format(calendar.getTime());
    }
}

